/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.DateUtils;

public class OsmWriter
extends XmlWriter
implements Visitor {
    private long newIdCounter = -1L;
    public HashMap<OsmPrimitive, Long> usedNewIds = new HashMap();
    private boolean osmConform;
    private boolean withBody = true;
    private String version;
    private Changeset changeset;

    public OsmWriter(PrintWriter printWriter, boolean bl, String string) {
        super(printWriter);
        this.osmConform = bl;
        this.version = string;
    }

    public void setWithBody(boolean bl) {
        this.withBody = bl;
    }

    public void setChangeset(Changeset changeset) {
        this.changeset = changeset;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void header() {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    public void writeContent(DataSet dataSet) {
        for (Node osmPrimitive : dataSet.nodes) {
            if (!this.shouldWrite(osmPrimitive)) continue;
            this.visit(osmPrimitive);
        }
        for (Way way : dataSet.ways) {
            if (!this.shouldWrite(way)) continue;
            this.visit(way);
        }
        for (Relation relation : dataSet.relations) {
            if (!this.shouldWrite(relation)) continue;
            this.visit(relation);
        }
    }

    private boolean shouldWrite(OsmPrimitive osmPrimitive) {
        return osmPrimitive.id != 0L || !osmPrimitive.deleted;
    }

    public void writeDataSources(DataSet dataSet) {
        for (DataSource dataSource : dataSet.dataSources) {
            this.out.println("  <bounds minlat='" + dataSource.bounds.min.lat() + "' minlon='" + dataSource.bounds.min.lon() + "' maxlat='" + dataSource.bounds.max.lat() + "' maxlon='" + dataSource.bounds.max.lon() + "' origin='" + XmlWriter.encode(dataSource.origin) + "' />");
        }
    }

    public void visit(Node node) {
        if (node.incomplete) {
            return;
        }
        this.addCommon(node, "node");
        this.out.print(" lat='" + node.coor.lat() + "' lon='" + node.coor.lon() + "'");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.addTags(node, "node", true);
        }
    }

    public void visit(Way way) {
        if (way.incomplete) {
            return;
        }
        this.addCommon(way, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (Node node : way.nodes) {
                this.out.println("    <nd ref='" + this.getUsedId(node) + "' />");
            }
            this.addTags(way, "way", false);
        }
    }

    public void visit(Relation relation) {
        if (relation.incomplete) {
            return;
        }
        this.addCommon(relation, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (RelationMember relationMember : relation.members) {
                this.out.print("    <member type='");
                this.out.print(OsmApi.which(relationMember.member));
                this.out.println("' ref='" + this.getUsedId(relationMember.member) + "' role='" + XmlWriter.encode(relationMember.role) + "' />");
            }
            this.addTags(relation, "relation", false);
        }
    }

    public void visit(Changeset changeset) {
        this.addCommon(changeset, "changeset");
        this.out.println(">\n");
        this.addTags(changeset, "changeset", false);
    }

    public final void footer(PrintWriter printWriter) {
        printWriter.println("</osm>");
    }

    private long getUsedId(OsmPrimitive osmPrimitive) {
        long l;
        if (osmPrimitive.id != 0L) {
            return osmPrimitive.id;
        }
        if (this.usedNewIds.containsKey(osmPrimitive)) {
            return this.usedNewIds.get(osmPrimitive);
        }
        this.usedNewIds.put(osmPrimitive, this.newIdCounter);
        if (this.osmConform) {
            l = 0L;
        } else {
            long l2 = this.newIdCounter;
            l = l2;
            this.newIdCounter = l2 - 1L;
        }
        return l;
    }

    private void addTags(OsmPrimitive osmPrimitive, String string, boolean bl) {
        if (osmPrimitive.keys != null) {
            if (bl) {
                this.out.println(">");
            }
            for (Map.Entry<String, String> entry : osmPrimitive.keys.entrySet()) {
                this.out.println("    <tag k='" + XmlWriter.encode(entry.getKey()) + "' v='" + XmlWriter.encode(entry.getValue()) + "' />");
            }
            this.out.println("  </" + string + ">");
        } else if (bl) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + string + ">");
        }
    }

    private void addCommon(OsmPrimitive osmPrimitive, String string) {
        long l = this.getUsedId(osmPrimitive);
        this.out.print("  <" + string);
        if (l != 0L) {
            this.out.print(" id='" + this.getUsedId(osmPrimitive) + "'");
        }
        if (!this.osmConform) {
            String string2 = null;
            if (osmPrimitive.deleted) {
                string2 = "delete";
            } else if (osmPrimitive.modified) {
                string2 = "modify";
            }
            if (string2 != null) {
                this.out.print(" action='" + string2 + "'");
            }
        }
        if (!osmPrimitive.isTimestampEmpty()) {
            this.out.print(" timestamp='" + DateUtils.fromDate(osmPrimitive.getTimestamp()) + "'");
        }
        if (osmPrimitive.user != null) {
            this.out.print(" user='" + XmlWriter.encode(osmPrimitive.user.name) + "'");
        }
        this.out.print(" visible='" + osmPrimitive.visible + "'");
        if (osmPrimitive.version != -1) {
            this.out.print(" version='" + osmPrimitive.version + "'");
        }
        if (this.changeset != null && this.changeset.id != 0L) {
            this.out.print(" changeset='" + this.changeset.id + "'");
        }
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }
}

