/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MarkerLayer
extends Layer {
    public final Collection<Marker> data;
    private boolean mousePressed = false;
    public GpxLayer fromLayer = null;

    public MarkerLayer(GpxData gpxData, String string, File file, GpxLayer gpxLayer) {
        super(string);
        this.associatedFile = file;
        this.data = new ArrayList<Marker>();
        this.fromLayer = gpxLayer;
        double d = -1.0;
        String string2 = "";
        for (WayPoint wayPoint : gpxData.waypoints) {
            GpxLink gpxLink;
            Iterator iterator;
            double d2 = wayPoint.time;
            boolean bl = wayPoint.attr.containsKey("link");
            if (d < 0.0 && bl) {
                d = d2;
                iterator = ((Collection)wayPoint.attr.get("link")).iterator();
                if (iterator.hasNext()) {
                    gpxLink = (GpxLink)iterator.next();
                    string2 = gpxLink.uri;
                }
            }
            if (bl && (iterator = ((Collection)wayPoint.attr.get("link")).iterator()).hasNext()) {
                gpxLink = (GpxLink)iterator.next();
                if (!gpxLink.uri.equals(string2)) {
                    d = d2;
                }
                string2 = gpxLink.uri;
            }
            if ((iterator = Marker.createMarker(wayPoint, gpxData.storageFile, this, d2, d2 - d)) == null) continue;
            this.data.add((Marker)((Object)iterator));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() != 1) {
                            return;
                        }
                        boolean bl = false;
                        if (mouseEvent.getPoint() != null) {
                            for (Marker marker : MarkerLayer.this.data) {
                                if (!marker.containsPoint(mouseEvent.getPoint())) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) {
                            return;
                        }
                        MarkerLayer.this.mousePressed = true;
                        if (MarkerLayer.this.visible) {
                            Main.map.mapView.repaint();
                        }
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() != 1 || !MarkerLayer.this.mousePressed) {
                            return;
                        }
                        MarkerLayer.this.mousePressed = false;
                        if (!MarkerLayer.this.visible) {
                            return;
                        }
                        if (mouseEvent.getPoint() != null) {
                            for (Marker marker : MarkerLayer.this.data) {
                                if (!marker.containsPoint(mouseEvent.getPoint())) continue;
                                marker.actionPerformed(new ActionEvent(this, 0, null));
                            }
                        }
                        Main.map.mapView.repaint();
                    }
                });
            }
        });
    }

    public Icon getIcon() {
        return ImageProvider.get("layer", "marker_small");
    }

    public static Color getColor(String string) {
        return Main.pref.getColor(I18n.marktr("gps marker"), string != null ? "layer " + string : null, Color.gray);
    }

    public void paint(Graphics graphics, MapView mapView) {
        boolean bl = this.mousePressed;
        Point point = mapView.getMousePosition();
        String string = Main.pref.get("marker.show " + this.name, "show");
        graphics.setColor(MarkerLayer.getColor(this.name));
        for (Marker marker : this.data) {
            if (point != null && marker.containsPoint(point)) {
                marker.paint(graphics, mapView, bl, string);
                bl = false;
                continue;
            }
            marker.paint(graphics, mapView, false, string);
        }
    }

    public String getToolTipText() {
        return this.data.size() + " " + I18n.trn("marker", "markers", this.data.size());
    }

    public void mergeFrom(Layer layer) {
        MarkerLayer markerLayer = (MarkerLayer)layer;
        this.data.addAll(markerLayer.data);
    }

    public boolean isMergable(Layer layer) {
        return layer instanceof MarkerLayer;
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Marker marker : this.data) {
            boundingXYVisitor.visit(marker.eastNorth);
        }
    }

    public Object getInfoComponent() {
        return "<html>" + I18n.trn("{0} consists of {1} marker", "{0} consists of {1} markers", this.data.size(), this.name, this.data.size()) + "</html>";
    }

    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
        jMenuItem.putClientProperty("help", "Action/LayerCustomizeColor");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(MarkerLayer.getColor(MarkerLayer.this.name));
                Object[] objectArray = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
                int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color"), 2, -1, null, objectArray, objectArray[0]);
                switch (n) {
                    case 0: {
                        Main.pref.putColor("layer " + MarkerLayer.this.name, jColorChooser.getColor());
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        Main.pref.putColor("layer " + MarkerLayer.this.name, null);
                    }
                }
                Main.map.repaint();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(I18n.tr("Synchronize Audio"), ImageProvider.get("audio-sync"));
        jMenuItem2.putClientProperty("help", "Action/SynchronizeAudio");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!AudioPlayer.paused()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to pause audio at the moment when you hear your synchronization cue."));
                    return;
                }
                AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
                if (MarkerLayer.this.synchronizeAudioMarkers(audioMarker)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", audioMarker.text));
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played."));
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(I18n.tr("Make Audio Marker at Play Head"), ImageProvider.get("addmarkers"));
        jMenuItem3.putClientProperty("help", "Action/MakeAudioMarkerAtPlayHead");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!AudioPlayer.paused()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to have paused audio at the point on the track where you want the marker."));
                    return;
                }
                PlayHeadMarker playHeadMarker = Main.map.mapView.playHeadMarker;
                if (playHeadMarker == null) {
                    return;
                }
                MarkerLayer.this.addAudioMarker(playHeadMarker.time, playHeadMarker.eastNorth);
                Main.map.mapView.repaint();
            }
        });
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(new JMenuItem(new LayerListDialog.ShowHideLayerAction(this)));
        arrayList.add(new JMenuItem(new LayerListDialog.ShowHideMarkerText(this)));
        arrayList.add(new JMenuItem(new LayerListDialog.DeleteLayerAction(this)));
        arrayList.add(new JSeparator());
        arrayList.add(jMenuItem);
        arrayList.add(new JSeparator());
        arrayList.add(jMenuItem2);
        if (Main.pref.getBoolean("marker.traceaudio", true)) {
            arrayList.add(jMenuItem3);
        }
        arrayList.add(new JMenuItem(new RenameLayerAction(this.associatedFile, this)));
        arrayList.add(new JSeparator());
        arrayList.add(new JMenuItem(new LayerListPopup.InfoAction(this)));
        return arrayList.toArray(new Component[0]);
    }

    public boolean synchronizeAudioMarkers(AudioMarker audioMarker) {
        if (audioMarker != null && !this.data.contains(audioMarker)) {
            audioMarker = null;
        }
        if (audioMarker == null) {
            for (Marker marker : this.data) {
                if (!(marker instanceof AudioMarker)) continue;
                audioMarker = (AudioMarker)marker;
                break;
            }
        }
        if (audioMarker == null) {
            return false;
        }
        double d = AudioPlayer.position() - audioMarker.offset;
        boolean bl = false;
        URL uRL = audioMarker.url();
        for (Marker marker : this.data) {
            AudioMarker audioMarker2;
            if (marker == audioMarker) {
                bl = true;
            }
            if (!bl || !(audioMarker2 = (AudioMarker)marker).url().equals(uRL)) continue;
            audioMarker2.adjustOffset(d);
        }
        return true;
    }

    public AudioMarker addAudioMarker(double d, EastNorth eastNorth) {
        double d2 = 0.0;
        AudioMarker audioMarker = null;
        for (Marker object2 : this.data) {
            if (object2.getClass() != AudioMarker.class) continue;
            audioMarker = (AudioMarker)object2;
            d2 = d - audioMarker.time;
            break;
        }
        if (audioMarker == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No existing audio markers in this layer to offset from."));
            return null;
        }
        Object object3 = AudioMarker.create(Main.proj.eastNorth2latlon(eastNorth), AudioMarker.inventName(d2), AudioPlayer.url().toString(), this, d, d2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        audioMarker = null;
        Object object = object3;
        for (Marker marker : this.data) {
            if (marker.getClass() == AudioMarker.class) {
                audioMarker = (AudioMarker)marker;
                if (object3 != null && d2 < audioMarker.offset) {
                    ((AudioMarker)object3).adjustOffset(audioMarker.syncOffset());
                    arrayList.add(object3);
                    object3 = null;
                }
            }
            arrayList.add(marker);
        }
        if (object3 != null) {
            if (audioMarker != null) {
                ((AudioMarker)object3).adjustOffset(audioMarker.syncOffset());
            }
            arrayList.add(object3);
        }
        this.data.clear();
        this.data.addAll(arrayList);
        return object;
    }

    public static void playAudio() {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        block0: for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (layer.getClass() != MarkerLayer.class) continue;
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker : markerLayer.data) {
                if (marker.getClass() != AudioMarker.class) continue;
                ((AudioMarker)marker).play();
                continue block0;
            }
        }
    }

    public static void playNextMarker() {
        MarkerLayer.playAdjacentMarker(true);
    }

    public static void playPreviousMarker() {
        MarkerLayer.playAdjacentMarker(false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void playAdjacentMarker(boolean bl) {
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker == null) {
            return;
        }
        Object var2_2 = null;
        boolean bl2 = false;
        if (Main.map == null) return;
        if (Main.map.mapView == null) {
            return;
        }
        Iterator<Layer> iterator = Main.map.mapView.getAllLayers().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            Layer layer = iterator.next();
            if (layer.getClass() != MarkerLayer.class) continue;
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker : markerLayer.data) {
                block10: {
                    if (marker == audioMarker) {
                        if (bl) {
                            bl2 = true;
                            break block10;
                        } else {
                            void var2_3;
                            if (var2_3 == null) {
                                AudioMarker audioMarker2 = audioMarker;
                            }
                            ((AudioMarker)var2_3).play();
                            break;
                        }
                    }
                    if (bl2 && marker.getClass() == AudioMarker.class) {
                        ((AudioMarker)marker).play();
                        return;
                    }
                }
                if (marker.getClass() != AudioMarker.class) continue;
                Marker marker2 = marker;
            }
            if (bl2) break;
        }
        audioMarker.play();
    }
}

