/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.Destroyable;

public abstract class Layer
implements Destroyable,
MapViewPaintable {
    public static final Collection<LayerChangeListener> listeners = new CopyOnWriteArrayList<LayerChangeListener>();
    public boolean visible = true;
    public boolean background = false;
    public String name;
    public File associatedFile;

    public Layer(String string) {
        this.name = string;
    }

    public abstract void paint(Graphics var1, MapView var2);

    public abstract Icon getIcon();

    public abstract String getToolTipText();

    public abstract void mergeFrom(Layer var1);

    public abstract boolean isMergable(Layer var1);

    public abstract void visitBoundingBox(BoundingXYVisitor var1);

    public abstract Object getInfoComponent();

    public abstract Component[] getMenuEntries();

    public void destroy() {
    }

    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

