/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FallbackDateParser {
    private static final String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy'T'HH:mm:ss.SSS'Z'", "MM/dd/yyyy'T'HH:mm:ss.SSSZ", "MM/dd/yyyy'T'HH:mm:ss.SSS", "MM/dd/yyyy'T'HH:mm:ssZ", "MM/dd/yyyy'T'HH:mm:ss", "yyyy:MM:dd HH:mm:ss"};
    private List<DateFormat> dateParsers = new ArrayList<DateFormat>(formats.length);
    private int activeDateParser;

    public FallbackDateParser() {
        for (int i = 0; i < formats.length; ++i) {
            this.dateParsers.add(new SimpleDateFormat(formats[i]));
        }
        this.activeDateParser = -1;
    }

    public Date parse(String string) throws ParseException {
        String string2 = string.length() == 25 && string.charAt(22) == ':' ? string.substring(0, 22) + string.substring(23, 25) : string;
        if (this.activeDateParser >= 0) {
            try {
                return this.dateParsers.get(this.activeDateParser).parse(string2);
            }
            catch (ParseException parseException) {
                this.activeDateParser = -1;
            }
        }
        for (int i = 0; i < this.dateParsers.size(); ++i) {
            try {
                Date date = this.dateParsers.get(i).parse(string2);
                this.activeDateParser = i;
                return date;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        throw new ParseException("The date string (" + string + ") could not be parsed.", 0);
    }
}

