/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter {
    public Collection<OsmPrimitive> processed;
    private OsmApi api = new OsmApi();
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - this.uploadStartTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        float f = (float)n / (float)l2;
        float f2 = n2 - n;
        int n3 = (int)(f2 / f);
        int n4 = n3 / 60000;
        int n5 = n3 / 1000 % 60;
        String string = Integer.toString(n4) + ":";
        if (n5 < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n5);
        return string;
    }

    public void uploadOsm(String string, Collection<OsmPrimitive> collection) {
        this.processed = new LinkedList<OsmPrimitive>();
        this.api.initialize();
        Main.pleaseWaitDlg.progress.setMaximum(collection.size());
        Main.pleaseWaitDlg.progress.setValue(0);
        boolean bl = this.api.hasChangesetSupport();
        boolean bl2 = Main.pref.getBoolean("osm-server.atomic-upload", "0.6".equals(this.api.getVersion()));
        String string2 = null;
        while (bl && string2 == null) {
            string2 = JOptionPane.showInputDialog(Main.parent, I18n.tr("Provide a brief comment for the changes you are uploading:"), I18n.tr("Commit comment"), 3);
            if (string2 == null) {
                return;
            }
            if (string2.trim().length() >= 3) break;
            string2 = null;
        }
        try {
            if (bl) {
                this.api.createChangeset(string2);
            }
        }
        catch (OsmTransferException osmTransferException) {
            this.dealWithTransferException(osmTransferException);
            return;
        }
        try {
            if (bl2) {
                this.processed.addAll(this.api.uploadDiff(collection));
            } else {
                NameVisitor nameVisitor = new NameVisitor();
                this.uploadStartTime = System.currentTimeMillis();
                for (OsmPrimitive osmPrimitive : collection) {
                    osmPrimitive.visit(nameVisitor);
                    int n = Main.pleaseWaitDlg.progress.getValue();
                    String string3 = this.timeLeft(n, collection.size());
                    Main.pleaseWaitDlg.currentAction.setText(I18n.tr("{0}% ({1}/{2}), {3} left. Uploading {4}: {5} (id: {6})", Math.round(100.0 * (double)n / (double)collection.size()), n, collection.size(), string3, I18n.tr(nameVisitor.className), nameVisitor.name, osmPrimitive.id));
                    this.makeApiRequest(osmPrimitive);
                    this.processed.add(osmPrimitive);
                    Main.pleaseWaitDlg.progress.setValue(n + 1);
                }
            }
            if (bl) {
                this.api.stopChangeset();
            }
        }
        catch (OsmTransferException osmTransferException) {
            try {
                if (bl) {
                    this.api.stopChangeset();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dealWithTransferException(osmTransferException);
        }
    }

    void makeApiRequest(OsmPrimitive osmPrimitive) throws OsmTransferException {
        if (osmPrimitive.deleted) {
            this.api.deletePrimitive(osmPrimitive);
        } else if (osmPrimitive.id == 0L) {
            this.api.createPrimitive(osmPrimitive);
        } else {
            this.api.modifyPrimitive(osmPrimitive);
        }
    }

    private void dealWithTransferException(OsmTransferException osmTransferException) {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Transfer aborted due to error (will wait for 5 seconds):") + osmTransferException.getMessage());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

