/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AddVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmReader {
    static InputStream currSource;
    private DataSet references;
    private DataSet ds = new DataSet();
    private String parseNotes = new String();
    private int parseNotesCount = 0;
    private AddVisitor adder = new AddVisitor(this.ds);
    private Map<Long, Node> nodes = new HashMap<Long, Node>();
    private Map<OsmPrimitiveData, Collection<Long>> ways = new HashMap<OsmPrimitiveData, Collection<Long>>();
    private Map<OsmPrimitiveData, Collection<RelationMemberData>> relations = new HashMap<OsmPrimitiveData, Collection<RelationMemberData>>();

    public DataSet getDs() {
        return this.ds;
    }

    public String getParseNotes() {
        return this.parseNotes;
    }

    void readCommon(Attributes attributes, OsmPrimitive osmPrimitive) throws SAXException {
        String string;
        String string2;
        String string3;
        String string4;
        osmPrimitive.id = this.getLong(attributes, "id");
        if (osmPrimitive.id == 0L) {
            throw new SAXException(I18n.tr("Illegal object with id=0"));
        }
        String string5 = attributes.getValue("timestamp");
        if (string5 != null && string5.length() != 0) {
            osmPrimitive.setTimestamp(DateUtils.fromString(string5));
        }
        if ((string4 = attributes.getValue("user")) != null) {
            osmPrimitive.user = User.get(string4);
        }
        if ((string3 = attributes.getValue("visible")) != null) {
            osmPrimitive.visible = Boolean.parseBoolean(string3);
        }
        if ((string2 = attributes.getValue("version")) != null) {
            osmPrimitive.version = Integer.parseInt(string2);
        }
        if ((string2 = attributes.getValue("old_version")) != null) {
            osmPrimitive.version = Integer.parseInt(string2);
        }
        if ((string = attributes.getValue("action")) == null) {
            return;
        }
        if (string.equals("delete")) {
            osmPrimitive.delete(true);
        } else if (string.startsWith("modify")) {
            osmPrimitive.modified = true;
        }
    }

    private long getLong(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new SAXException(I18n.tr("Missing required attribute \"{0}\".", string));
        }
        return Long.parseLong(string2);
    }

    private Node findNode(long l) {
        Node node = this.nodes.get(l);
        if (node != null) {
            return node;
        }
        for (Node node2 : this.references.nodes) {
            if (node2.id != l) continue;
            return node2;
        }
        for (Node node2 : Main.ds.nodes) {
            if (node2.id != l) continue;
            return new Node(node2);
        }
        return null;
    }

    private void createWays() {
        for (Map.Entry<OsmPrimitiveData, Collection<Long>> entry : this.ways.entrySet()) {
            Way way = new Way();
            boolean bl = false;
            for (long l : entry.getValue()) {
                Node node = this.findNode(l);
                if (node == null) {
                    if (this.parseNotesCount++ < 6) {
                        this.parseNotes = this.parseNotes + I18n.tr("Skipping a way because it includes a node that doesn''t exist: {0}\n", l);
                    } else if (this.parseNotesCount == 6) {
                        this.parseNotes = this.parseNotes + "...\n";
                    }
                    bl = true;
                    break;
                }
                way.nodes.add(node);
            }
            if (bl) continue;
            entry.getKey().copyTo(way);
            this.adder.visit(way);
        }
    }

    private Way findWay(long l) {
        for (Way way : Main.ds.ways) {
            if (way.id != l) continue;
            return way;
        }
        return null;
    }

    private Relation findRelation(long l) {
        for (Relation relation : this.ds.relations) {
            if (relation.id != l) continue;
            return relation;
        }
        for (Relation relation : Main.ds.relations) {
            if (relation.id != l) continue;
            return relation;
        }
        return null;
    }

    private void createRelations() {
        for (Map.Entry<OsmPrimitiveData, Collection<RelationMemberData>> iterator : this.relations.entrySet()) {
            Relation relation = new Relation();
            iterator.getKey().copyTo(relation);
            this.adder.visit(relation);
        }
        Object object = new HashMap(10000);
        for (Way way : this.ds.ways) {
            ((HashMap)object).put(way.id, way);
        }
        for (Map.Entry<OsmPrimitiveData, Collection<RelationMemberData>> entry : this.relations.entrySet()) {
            Relation relation = this.findRelation(entry.getKey().id);
            if (relation == null) {
                throw new Error("Failed to create relation " + entry.getKey().id);
            }
            for (RelationMemberData relationMemberData : entry.getValue()) {
                RelationMember relationMember = relationMemberData.relationMember;
                if (relationMemberData.type.equals("node")) {
                    relationMember.member = this.findNode(relationMemberData.id);
                    if (relationMember.member == null) {
                        relationMember.member = new Node(relationMemberData.id);
                        this.adder.visit((Node)relationMember.member);
                    }
                } else if (relationMemberData.type.equals("way")) {
                    relationMember.member = (OsmPrimitive)((HashMap)object).get(relationMemberData.id);
                    if (relationMember.member == null) {
                        relationMember.member = this.findWay(relationMemberData.id);
                    }
                    if (relationMember.member == null) {
                        relationMember.member = new Way(relationMemberData.id);
                        this.adder.visit((Way)relationMember.member);
                    }
                } else if (relationMemberData.type.equals("relation")) {
                    relationMember.member = this.findRelation(relationMemberData.id);
                    if (relationMember.member == null) {
                        relationMember.member = new Relation(relationMemberData.id);
                        this.adder.visit((Relation)relationMember.member);
                    }
                }
                relation.members.add(relationMember);
            }
        }
        object = null;
    }

    public static DataSet parseDataSet(InputStream inputStream, DataSet dataSet, PleaseWaitDialog pleaseWaitDialog) throws SAXException, IOException {
        return OsmReader.parseDataSetOsm((InputStream)inputStream, (DataSet)dataSet, (PleaseWaitDialog)pleaseWaitDialog).ds;
    }

    public static OsmReader parseDataSetOsm(InputStream inputStream, DataSet dataSet, PleaseWaitDialog pleaseWaitDialog) throws SAXException, IOException {
        OsmReader osmReader = new OsmReader();
        osmReader.references = dataSet == null ? new DataSet() : dataSet;
        currSource = inputStream;
        InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmReader osmReader2 = osmReader;
            osmReader2.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmReader2.new Parser());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Prepare OSM data..."));
        Main.pleaseWaitDlg.setIndeterminate(true);
        for (Node osmPrimitive : osmReader.nodes.values()) {
            osmReader.adder.visit(osmPrimitive);
        }
        try {
            osmReader.createWays();
            osmReader.createRelations();
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new SAXException(I18n.tr("Ill-formed node id"));
        }
        for (OsmPrimitive osmPrimitive : osmReader.ds.allPrimitives()) {
            if (osmPrimitive.id >= 0L) continue;
            osmPrimitive.id = 0L;
        }
        Main.pleaseWaitDlg.setIndeterminate(false);
        Main.pleaseWaitDlg.progress.setValue(0);
        return osmReader;
    }

    private class Parser
    extends DefaultHandler {
        private OsmPrimitive current;
        private String generator;
        private Map<String, String> keys = new HashMap<String, String>();

        private Parser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (string3.equals("osm")) {
                    if (attributes == null) {
                        throw new SAXException(I18n.tr("Unknown version"));
                    }
                    String string4 = attributes.getValue("version");
                    if (string4 == null) {
                        throw new SAXException(I18n.tr("Version number missing from OSM data"));
                    }
                    if (!string4.equals("0.5") && !string4.equals("0.6")) {
                        throw new SAXException(I18n.tr("Unknown version: {0}", string4));
                    }
                    this.generator = attributes.getValue("generator");
                    ((OsmReader)OsmReader.this).ds.version = string4;
                } else if (string3.equals("bounds")) {
                    String string5 = attributes.getValue("minlon");
                    String string6 = attributes.getValue("minlat");
                    String string7 = attributes.getValue("maxlon");
                    String string8 = attributes.getValue("maxlat");
                    String string9 = attributes.getValue("origin");
                    if (string5 != null && string7 != null && string6 != null && string8 != null) {
                        if (string9 == null) {
                            string9 = this.generator;
                        }
                        Bounds bounds = new Bounds(new LatLon(Double.parseDouble(string6), Double.parseDouble(string5)), new LatLon(Double.parseDouble(string8), Double.parseDouble(string7)));
                        DataSource dataSource = new DataSource(bounds, string9);
                        ((OsmReader)OsmReader.this).ds.dataSources.add(dataSource);
                    }
                } else if (string3.equals("node")) {
                    this.current = new Node(new LatLon(this.getDouble(attributes, "lat"), this.getDouble(attributes, "lon")));
                    OsmReader.this.readCommon(attributes, this.current);
                    OsmReader.this.nodes.put(this.current.id, (Node)this.current);
                } else if (string3.equals("way")) {
                    this.current = new OsmPrimitiveData();
                    OsmReader.this.readCommon(attributes, this.current);
                    OsmReader.this.ways.put((OsmPrimitiveData)this.current, new ArrayList());
                } else if (string3.equals("nd")) {
                    Collection collection = (Collection)OsmReader.this.ways.get(this.current);
                    if (collection == null) {
                        throw new SAXException(I18n.tr("Found <nd> element in non-way."));
                    }
                    long l = OsmReader.this.getLong(attributes, "ref");
                    if (l == 0L) {
                        throw new SAXException(I18n.tr("<nd> has zero ref"));
                    }
                    collection.add(l);
                } else if (string3.equals("relation")) {
                    this.current = new OsmPrimitiveData();
                    OsmReader.this.readCommon(attributes, this.current);
                    OsmReader.this.relations.put((OsmPrimitiveData)this.current, new LinkedList());
                } else if (string3.equals("member")) {
                    Collection collection = (Collection)OsmReader.this.relations.get(this.current);
                    if (collection == null) {
                        throw new SAXException(I18n.tr("Found <member> element in non-relation."));
                    }
                    RelationMemberData relationMemberData = new RelationMemberData();
                    relationMemberData.relationMember = new RelationMember();
                    relationMemberData.id = OsmReader.this.getLong(attributes, "ref");
                    relationMemberData.type = attributes.getValue("type");
                    relationMemberData.relationMember.role = attributes.getValue("role");
                    if (relationMemberData.id == 0L) {
                        throw new SAXException(I18n.tr("Incomplete <member> specification with ref=0"));
                    }
                    collection.add(relationMemberData);
                } else if (string3.equals("tag")) {
                    String string10 = attributes.getValue("k");
                    String string11 = this.keys.get(string10);
                    if (string11 == null) {
                        string11 = string10;
                        this.keys.put(string10, string10);
                    }
                    this.current.put(string11, attributes.getValue("v"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SAXException(I18n.tr("NullPointerException, possibly some missing tags."), nullPointerException);
            }
        }

        private double getDouble(Attributes attributes, String string) {
            return Double.parseDouble(attributes.getValue(string));
        }
    }

    private static class RelationMemberData {
        public String type;
        public long id;
        public RelationMember relationMember;

        private RelationMemberData() {
        }
    }

    private static class OsmPrimitiveData
    extends OsmPrimitive {
        private OsmPrimitiveData() {
        }

        public void visit(Visitor visitor) {
        }

        public int compareTo(OsmPrimitive osmPrimitive) {
            return 0;
        }

        public void copyTo(OsmPrimitive osmPrimitive) {
            osmPrimitive.id = this.id;
            osmPrimitive.keys = this.keys;
            osmPrimitive.modified = this.modified;
            osmPrimitive.selected = this.selected;
            osmPrimitive.deleted = this.deleted;
            osmPrimitive.setTimestamp(this.getTimestamp());
            osmPrimitive.user = this.user;
            osmPrimitive.visible = this.visible;
            osmPrimitive.version = this.version;
            osmPrimitive.mappaintStyle = null;
        }
    }
}

