/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.josm.io.OsmConnection;

public class MultiPartFormOutputStream
extends OsmConnection {
    private static final String NEWLINE = "\r\n";
    private static final String PREFIX = "--";
    private DataOutputStream out = null;
    private String boundary = null;

    public MultiPartFormOutputStream(OutputStream outputStream, String string) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Boundary stream is required.");
        }
        this.out = new DataOutputStream(outputStream);
        this.boundary = string;
        this.initAuthentication();
    }

    public void writeField(String string, boolean bl) throws IOException {
        this.writeField(string, new Boolean(bl).toString());
    }

    public void writeField(String string, double d) throws IOException {
        this.writeField(string, Double.toString(d));
    }

    public void writeField(String string, float f) throws IOException {
        this.writeField(string, Float.toString(f));
    }

    public void writeField(String string, long l) throws IOException {
        this.writeField(string, Long.toString(l));
    }

    public void writeField(String string, int n) throws IOException {
        this.writeField(string, Integer.toString(n));
    }

    public void writeField(String string, short s) throws IOException {
        this.writeField(string, Short.toString(s));
    }

    public void writeField(String string, char c) throws IOException {
        this.writeField(string, new Character(c).toString());
    }

    public void writeField(String string, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (string2 == null) {
            string2 = "";
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"");
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes(string2);
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void writeFile(String string, String string2, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory.");
        }
        this.writeFile(string, string2, file.getCanonicalPath(), new FileInputStream(file));
    }

    public void writeFile(String string, String string2, String string3, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string3 + "\"");
        this.out.writeBytes(NEWLINE);
        if (string2 != null) {
            this.out.writeBytes("Content-Type: " + string2);
            this.out.writeBytes(NEWLINE);
        }
        this.out.writeBytes(NEWLINE);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            this.out.write(byArray, 0, n);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void writeFile(String string, String string2, String string3, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string3 + "\"");
        this.out.writeBytes(NEWLINE);
        if (string2 != null) {
            this.out.writeBytes("Content-Type: " + string2);
            this.out.writeBytes(NEWLINE);
        }
        this.out.writeBytes(NEWLINE);
        this.out.write(byArray, 0, byArray.length);
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void flush() {
    }

    public void close() throws IOException {
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(NEWLINE);
        this.out.flush();
        this.out.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public static URLConnection createConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod("POST");
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setDefaultUseCaches(false);
        return uRLConnection;
    }

    public static String createBoundary() {
        return "--------------------" + Long.toString(System.currentTimeMillis(), 16);
    }

    public static String getContentType(String string) {
        return "multipart/form-data; boundary=" + string;
    }
}

