/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceSelection
implements DownloadSelection {
    private JTextField searchTerm = new JTextField();
    private JButton submitSearch = new JButton(I18n.tr("Search..."));
    private DefaultTableModel searchResults = new DefaultTableModel(){

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    private JTable searchResultDisplay = new JTable(this.searchResults);
    private boolean updatingSelf;

    public void queryServer(final JComponent jComponent) {
        final Cursor cursor = jComponent.getCursor();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String string = PlaceSelection.this.searchTerm.getText();
                    if (string.length() == 0) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please enter a search string"));
                    } else {
                        jComponent.setCursor(Cursor.getPredefinedCursor(3));
                        jComponent.repaint();
                        URL uRL = new URL("http://gazetteer.openstreetmap.org/namefinder/search.xml?find=" + URLEncoder.encode(PlaceSelection.this.searchTerm.getText(), "UTF-8"));
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setConnectTimeout(15000);
                        InputStream inputStream = httpURLConnection.getInputStream();
                        InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
                        SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new Parser());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot read place search results from server"));
                    exception.printStackTrace();
                }
                jComponent.setCursor(cursor);
            }
        };
        new Thread(runnable).start();
    }

    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Enter a place name to search for:")), GBC.eol().insets(5, 5, 5, 5));
        jPanel.add((Component)this.searchTerm, GBC.std().fill(2).insets(5, 0, 5, 4));
        jPanel.add((Component)this.submitSearch, GBC.eol().insets(5, 0, 5, 5));
        Dimension dimension = this.submitSearch.getPreferredSize();
        dimension.setSize((double)dimension.width, (double)dimension.height * 0.8);
        this.submitSearch.setPreferredSize(dimension);
        GBC gBC = GBC.std().fill().insets(5, 0, 5, 5);
        gBC.gridwidth = 2;
        JScrollPane jScrollPane = new JScrollPane(this.searchResultDisplay);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        jPanel.add((Component)jScrollPane, gBC);
        downloadDialog.tabpane.add((Component)jPanel, I18n.tr("Places"));
        jScrollPane.setPreferredSize(jScrollPane.getPreferredSize());
        this.submitSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaceSelection.this.queryServer(downloadDialog);
            }
        });
        this.searchTerm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaceSelection.this.queryServer(downloadDialog);
            }
        });
        this.searchResults.addColumn(I18n.tr("name"));
        this.searchResults.addColumn(I18n.tr("type"));
        this.searchResults.addColumn(I18n.tr("near"));
        this.searchResults.addColumn(I18n.tr("zoom"));
        this.searchResultDisplay.getColumn(I18n.tr("name")).setPreferredWidth(200);
        this.searchResultDisplay.getColumn(I18n.tr("type")).setPreferredWidth(100);
        this.searchResultDisplay.getColumn(I18n.tr("near")).setPreferredWidth(100);
        this.searchResultDisplay.getColumn(I18n.tr("zoom")).setPreferredWidth(50);
        this.searchResultDisplay.getSelectionModel().setSelectionMode(0);
        this.searchResultDisplay.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object != null) {
                    SearchResult searchResult = (SearchResult)object;
                    switch (n2) {
                        case 0: {
                            this.setText(searchResult.name);
                            break;
                        }
                        case 1: {
                            this.setText(searchResult.type);
                            break;
                        }
                        case 2: {
                            this.setText(searchResult.nearestPlace);
                            break;
                        }
                        case 3: {
                            this.setText(Integer.toString(searchResult.zoom));
                        }
                    }
                    this.setToolTipText("<html>" + ((SearchResult)object).description + "</html>");
                }
                return this;
            }
        });
        this.searchResultDisplay.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SearchResult searchResult = null;
                try {
                    searchResult = (SearchResult)PlaceSelection.this.searchResults.getValueAt(listSelectionEvent.getFirstIndex(), 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (searchResult != null) {
                    double d = 180.0 / Math.pow(2.0, searchResult.zoom);
                    downloadDialog.minlat = searchResult.lat - d / 2.0;
                    downloadDialog.maxlat = searchResult.lat + d / 2.0;
                    downloadDialog.minlon = searchResult.lon - d;
                    downloadDialog.maxlon = searchResult.lon + d;
                    PlaceSelection.this.updatingSelf = true;
                    downloadDialog.boundingBoxChanged(null);
                    PlaceSelection.this.updatingSelf = false;
                }
            }
        });
        this.searchResultDisplay.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() <= 1 || PlaceSelection.this.searchResultDisplay.getSelectionModel().getMinSelectionIndex() > -1) {
                    // empty if block
                }
            }
        });
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        if (!this.updatingSelf) {
            this.searchResultDisplay.clearSelection();
        }
    }

    private class Parser
    extends DefaultHandler {
        private SearchResult currentResult = null;
        private StringBuffer description = null;
        private int depth = 0;

        private Parser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.depth;
            try {
                String string4;
                if (string3.equals("searchresults")) {
                    PlaceSelection.this.searchResults.setRowCount(0);
                } else if (string3.equals("named") && this.depth == 2) {
                    this.currentResult = new SearchResult();
                    this.currentResult.name = attributes.getValue("name");
                    this.currentResult.type = attributes.getValue("info");
                    this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                    this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                    this.currentResult.zoom = Integer.parseInt(attributes.getValue("zoom"));
                    PlaceSelection.this.searchResults.addRow(new Object[]{this.currentResult, this.currentResult, this.currentResult, this.currentResult});
                } else if (string3.equals("description") && this.depth == 3) {
                    this.description = new StringBuffer();
                } else if (string3.equals("named") && this.depth == 4 && ("city".equals(string4 = attributes.getValue("info")) || "town".equals(string4) || "village".equals(string4))) {
                    this.currentResult.nearestPlace = attributes.getValue("name");
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags."), nullPointerException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals("searchresults") && string3.equals("description") && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.description != null) {
                this.description.append(cArray, n, n2);
            }
        }
    }

    class SearchResult {
        public String name;
        public String type;
        public String nearestPlace;
        public String description;
        public double lat;
        public double lon;
        public int zoom;

        SearchResult() {
        }
    }
}

