/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ToggleDialog
extends JPanel
implements HelpAction.Helpful {
    public ToggleDialogAction action;
    public final String prefName;
    public JPanel parent;
    WindowAdapter winadapter;
    private ActionListener stickyActionListener;
    private final JPanel titleBar = new JPanel(new GridBagLayout());
    public JLabel label = new JLabel();

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n) {
        super(new BorderLayout());
        this.prefName = string2;
        this.ToggleDialogInit(string, string2, string3, shortcut, n);
    }

    private void ToggleDialogInit(final String string, String string2, String string3, Shortcut shortcut, final int n) {
        this.setPreferredSize(new Dimension(330, n));
        this.action = new ToggleDialogAction(string, "dialogs/" + string2, string3, shortcut, string2);
        String string4 = "Dialog/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        this.action.putValue("help", string4.substring(0, string4.length() - 6));
        this.setLayout(new BorderLayout());
        final JLabel jLabel = new JLabel(ImageProvider.get("misc", "normal"));
        this.titleBar.add(jLabel);
        ImageIcon imageIcon = ImageProvider.get("dialogs", string2);
        ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        JLabel jLabel2 = new JLabel(string, imageIcon2, 11);
        jLabel2.setIconTextGap(8);
        this.titleBar.add((Component)jLabel2, GBC.std());
        this.titleBar.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                Component[] componentArray = ToggleDialog.this.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] == ToggleDialog.this.titleBar) continue;
                    if (componentArray[i].isVisible()) {
                        componentArray[i].setVisible(false);
                        continue;
                    }
                    componentArray[i].setVisible(true);
                    bl = true;
                }
                Main.pref.put(ToggleDialog.this.action.prefname + ".minimized", !bl);
                if (bl) {
                    ToggleDialog.this.setPreferredSize(new Dimension(330, n));
                    ToggleDialog.this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                    jLabel.setIcon(ImageProvider.get("misc", "normal"));
                } else {
                    ToggleDialog.this.setPreferredSize(new Dimension(330, 20));
                    ToggleDialog.this.setMaximumSize(new Dimension(330, 20));
                    jLabel.setIcon(ImageProvider.get("misc", "minimized"));
                }
                if (ToggleDialog.this.parent != null) {
                    ToggleDialog.this.parent.setVisible(false);
                    ToggleDialog.this.parent.setVisible(true);
                }
            }
        };
        final MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                actionListener.actionPerformed(null);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
        this.titleBar.addMouseListener(mouseListener);
        JButton jButton = new JButton(ImageProvider.get("misc", "sticky"));
        jButton.setToolTipText(I18n.tr("Undock the panel"));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        this.stickyActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final JFrame jFrame = new JFrame(string);
                try {
                    jFrame.setAlwaysOnTop(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                ToggleDialog.this.parent.remove(ToggleDialog.this);
                jFrame.getContentPane().add(ToggleDialog.this);
                ToggleDialog.this.winadapter = new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        jFrame.getContentPane().removeAll();
                        jFrame.dispose();
                        ToggleDialog.this.winadapter = null;
                        ToggleDialog.this.setVisible(false);
                        ToggleDialog.this.parent.add(ToggleDialog.this);
                        if (Main.pref.getBoolean(ToggleDialog.this.action.prefname + ".visible")) {
                            ToggleDialog.this.setVisible(true);
                        }
                        ToggleDialog.this.titleBar.setVisible(true);
                        if (windowEvent != null) {
                            Main.pref.put(ToggleDialog.this.action.prefname + ".docked", true);
                        }
                    }
                };
                jFrame.addWindowListener(ToggleDialog.this.winadapter);
                jFrame.addComponentListener(new ComponentAdapter(){

                    public void componentMoved(ComponentEvent componentEvent) {
                        Main.pref.put(ToggleDialog.this.action.prefname + ".bounds", jFrame.getX() + "," + jFrame.getY() + "," + jFrame.getWidth() + "," + jFrame.getHeight());
                    }
                });
                String string2 = Main.pref.get(ToggleDialog.this.action.prefname + ".bounds", null);
                if (string2 != null) {
                    String[] stringArray = string2.split(",");
                    jFrame.setBounds(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                } else {
                    jFrame.pack();
                }
                Main.pref.put(ToggleDialog.this.action.prefname + ".docked", false);
                jFrame.setVisible(true);
                ToggleDialog.this.titleBar.setVisible(false);
                ToggleDialog.this.parent.setVisible(false);
                ToggleDialog.this.parent.setVisible(true);
            }
        };
        jButton.addActionListener(this.stickyActionListener);
        this.titleBar.add(jButton);
        JButton jButton2 = new JButton(ImageProvider.get("misc", "close"));
        jButton2.setToolTipText(I18n.tr("Close this panel. You can reopen it with the buttons in the left toolbar."));
        jButton2.setBorder(BorderFactory.createEmptyBorder());
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToggleDialog.this.action.actionPerformed(new ActionEvent(ToggleDialog.this.titleBar, 0, ""));
            }
        };
        jButton2.addActionListener(actionListener2);
        this.titleBar.add(jButton2);
        this.add((Component)this.titleBar, "North");
        this.titleBar.setToolTipText(I18n.tr("Click to minimize/maximize the panel content"));
        this.setVisible(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        if (!Main.pref.getBoolean(this.action.prefname + ".docked", true)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ToggleDialog.this.stickyActionListener.actionPerformed(null);
                }
            });
        }
        if (Main.pref.getBoolean(this.action.prefname + ".minimized", false)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    mouseListener.mouseClicked(null);
                }
            });
        }
    }

    public void close() {
        if (this.winadapter != null) {
            this.winadapter.windowClosing(null);
        }
    }

    public void setTitle(String string, boolean bl) {
        if (bl) {
            this.label.setText("<html><b>" + string + "</b>");
        } else {
            this.label.setText(string);
        }
    }

    public String helpTopic() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length() - 6);
        return "Dialog/" + string;
    }

    public final class ToggleDialogAction
    extends JosmAction {
        public final String prefname;
        public AbstractButton button;

        private ToggleDialogAction(String string, String string2, String string3, Shortcut shortcut, String string4) {
            super(string, string2, string3, shortcut, false);
            this.prefname = string4;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent != null && !(actionEvent.getSource() instanceof AbstractButton)) {
                this.button.setSelected(!this.button.isSelected());
            }
            Boolean bl = this.button.isSelected();
            ToggleDialog.this.setVisible(bl);
            Main.pref.put(this.prefname + ".visible", bl);
            if (!bl.booleanValue() && ToggleDialog.this.winadapter != null) {
                ToggleDialog.this.winadapter.windowClosing(null);
            } else if (!Main.pref.getBoolean(ToggleDialog.this.action.prefname + ".docked", true)) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ToggleDialog.this.stickyActionListener.actionPerformed(null);
                    }
                });
            }
        }
    }
}

