/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable {
    public boolean silent = false;
    public String errorMessage;
    private boolean closeDialogCalled = false;
    private boolean cancelled = false;
    private boolean ignoreException;
    private final String title;

    public PleaseWaitRunnable(String string) {
        this(string, false);
    }

    public PleaseWaitRunnable(String string, boolean bl) {
        this.title = string;
        this.ignoreException = bl;
        Main.pleaseWaitDlg.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!PleaseWaitRunnable.this.cancelled) {
                    PleaseWaitRunnable.this.cancelled = true;
                    PleaseWaitRunnable.this.cancel();
                }
            }
        });
        Main.pleaseWaitDlg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!PleaseWaitRunnable.this.closeDialogCalled) {
                    if (!PleaseWaitRunnable.this.cancelled) {
                        PleaseWaitRunnable.this.cancelled = true;
                        PleaseWaitRunnable.this.cancel();
                    }
                    PleaseWaitRunnable.this.closeDialog();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        block18: {
            try {
                try {
                    if (this.cancelled) {
                        return;
                    }
                    Main.pleaseWaitDlg.setTitle(this.title);
                    Main.pleaseWaitDlg.cancel.setEnabled(true);
                    Main.pleaseWaitDlg.setCustomText("");
                    this.errorMessage = null;
                    this.closeDialogCalled = false;
                    PleaseWaitRunnable pleaseWaitRunnable = this;
                    synchronized (pleaseWaitRunnable) {
                        EventQueue.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                PleaseWaitRunnable pleaseWaitRunnable = PleaseWaitRunnable.this;
                                synchronized (pleaseWaitRunnable) {
                                    PleaseWaitRunnable.this.notifyAll();
                                }
                                Main.pleaseWaitDlg.setVisible(true);
                            }
                        });
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.realRun();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                    this.errorMessage = I18n.tr("Error while parsing") + ": " + sAXException.getMessage();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    this.errorMessage = I18n.tr("File not found") + ": " + fileNotFoundException.getMessage();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.errorMessage = iOException.getMessage();
                }
                finally {
                    this.closeDialog();
                }
            }
            catch (Throwable throwable) {
                if (this.ignoreException) break block18;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        throw new RuntimeException(throwable);
                    }
                });
            }
        }
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException;

    protected abstract void finish();

    public void closeDialog() {
        if (this.closeDialogCalled) {
            return;
        }
        this.closeDialogCalled = true;
        try {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        PleaseWaitRunnable.this.finish();
                    }
                    finally {
                        Main.pleaseWaitDlg.setVisible(false);
                        Main.pleaseWaitDlg.dispose();
                    }
                    if (PleaseWaitRunnable.this.errorMessage != null && !PleaseWaitRunnable.this.silent) {
                        JOptionPane.showMessageDialog(Main.parent, PleaseWaitRunnable.this.errorMessage);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }
}

