/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class CollectBackReferencesVisitor
extends AbstractVisitor {
    private final DataSet ds;
    private final boolean indirectRefs;
    public final Collection<OsmPrimitive> data = new HashSet<OsmPrimitive>();

    public CollectBackReferencesVisitor(DataSet dataSet) {
        this.ds = dataSet;
        this.indirectRefs = true;
    }

    public CollectBackReferencesVisitor(DataSet dataSet, boolean bl) {
        this.ds = dataSet;
        this.indirectRefs = bl;
    }

    public void visit(Node node) {
        for (Way way : this.ds.ways) {
            if (way.deleted || way.incomplete) continue;
            for (Node node2 : way.nodes) {
                if (node != node2) continue;
                this.data.add(way);
                if (!this.indirectRefs) continue;
                this.visit(way);
            }
        }
        this.checkRelationMembership(node);
    }

    public void visit(Way way) {
        this.checkRelationMembership(way);
    }

    public void visit(Relation relation) {
        this.checkRelationMembership(relation);
    }

    private void checkRelationMembership(OsmPrimitive osmPrimitive) {
        block0: for (Relation relation : this.ds.relations) {
            if (relation.incomplete || relation.deleted) continue;
            for (RelationMember relationMember : relation.members) {
                if (relationMember.member != osmPrimitive) continue;
                if (this.data.contains(relation)) continue block0;
                this.data.add(relation);
                if (!this.indirectRefs) continue block0;
                this.checkRelationMembership(relation);
                continue block0;
            }
        }
    }
}

