/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOsmTask
implements DownloadDialog.DownloadTask {
    private static Bounds currentBounds;
    private Future<Task> task = null;
    private JCheckBox checkBox = new JCheckBox(I18n.tr("OpenStreetMap data"), true);

    public void download(DownloadAction downloadAction, double d, double d2, double d3, double d4, boolean bl, String string) {
        double d5;
        if (d > d3) {
            d5 = d;
            d = d3;
            d3 = d5;
        }
        if (d2 > d4) {
            d5 = d2;
            d2 = d4;
            d4 = d5;
        }
        boolean bl2 = downloadAction != null && (downloadAction.dialog == null || downloadAction.dialog.newLayer.isSelected());
        Task task = new Task(bl2, new BoundingBoxDownloader(d, d2, d3, d4), bl, this.getDataLayersCount(), string);
        currentBounds = new Bounds(new LatLon(d, d2), new LatLon(d3, d4));
        this.task = Main.worker.submit(task, task);
    }

    public void download(DownloadAction downloadAction, double d, double d2, double d3, double d4) {
        this.download(downloadAction, d, d2, d3, d4, false, "");
    }

    public void loadUrl(boolean bl, String string) {
        Task task = new Task(bl, new OsmServerLocationReader(string), false, this.getDataLayersCount(), "");
        this.task = Main.worker.submit(task, task);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getPreferencesSuffix() {
        return "osm";
    }

    private int getDataLayersCount() {
        if (Main.map == null || Main.map.mapView == null) {
            return 0;
        }
        int n = 0;
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!(layer instanceof OsmDataLayer)) continue;
            ++n;
        }
        return n;
    }

    public String getErrorMessage() {
        if (this.task == null) {
            return "";
        }
        try {
            Task task = this.task.get();
            return task.errorMessage == null ? "" : task.errorMessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static class Task
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private DataSet dataSet;
        private boolean newLayer;
        private int num = 1;
        private String msg = "";

        public Task(boolean bl, OsmServerReader osmServerReader, boolean bl2, int n, String string) {
            super(I18n.tr("Downloading data"));
            this.msg = string;
            this.reader = osmServerReader;
            this.newLayer = bl;
            this.silent = bl2;
        }

        public void realRun() throws IOException, SAXException {
            Main.pleaseWaitDlg.setCustomText(this.msg);
            this.dataSet = this.reader.parseOsm();
        }

        protected void finish() {
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                if (!this.silent) {
                    this.errorMessage = I18n.tr("No data imported.");
                }
                this.dataSet.dataSources.add(new DataSource(currentBounds, "OpenStreetMap server"));
            }
            OsmDataLayer osmDataLayer = new OsmDataLayer(this.dataSet, I18n.tr("Data Layer {0}", this.num), null);
            if (this.newLayer) {
                Main.main.addLayer(osmDataLayer);
            } else {
                Main.main.editLayer().mergeFrom(osmDataLayer);
            }
            Main.pleaseWaitDlg.setCustomText("");
        }

        protected void cancel() {
            if (this.reader != null) {
                this.reader.cancel();
            }
            Main.pleaseWaitDlg.cancel.setEnabled(false);
        }
    }
}

