/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinNodeWayAction
extends JosmAction {
    public JoinNodeWayAction() {
        super(I18n.tr("Join Node to Way"), "joinnodeway", I18n.tr("Join a node into the nearest way segments"), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way")), 74, 3), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (collection.size() != 1 || !(collection.iterator().next() instanceof Node)) {
            return;
        }
        Node node = (Node)collection.iterator().next();
        List<WaySegment> list = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node.eastNorth));
        HashMap hashMap = new HashMap();
        for (WaySegment object : list) {
            void var8_9;
            if (hashMap.containsKey(object.way)) {
                List list2 = (List)hashMap.get(object.way);
            } else {
                ArrayList arrayList = new ArrayList();
                hashMap.put(object.way, arrayList);
            }
            if (object.way.nodes.get(object.lowerIndex) == node || object.way.nodes.get(object.lowerIndex + 1) == node) continue;
            var8_9.add(object.lowerIndex);
        }
        LinkedList linkedList = new LinkedList();
        for (Map.Entry entry : hashMap.entrySet()) {
            Way way = (Way)entry.getKey();
            Way way2 = new Way(way);
            List list3 = (List)entry.getValue();
            JoinNodeWayAction.pruneSuccsAndReverse(list3);
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                way2.nodes.add(n + 1, node);
            }
            linkedList.add(new ChangeCommand(way, way2));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Join Node and Line"), linkedList));
        Main.map.repaint();
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }
}

