/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class JpegMetadataReader {
    public static Metadata readMetadata(InputStream inputStream) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(inputStream);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader);
    }

    public static Metadata readMetadata(File file) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader);
    }

    public static Metadata extractMetadataFromJpegSegmentReader(JpegSegmentReader jpegSegmentReader) {
        byte[] byArray;
        Metadata metadata = new Metadata();
        try {
            byArray = jpegSegmentReader.readSegment((byte)-31);
            new ExifReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-19);
            new IptcReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-64);
            new JpegReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-2);
            new JpegCommentReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        return metadata;
    }

    private JpegMetadataReader() {
    }

    public static void main(String[] stringArray) throws MetadataException, IOException {
        Directory directory;
        Metadata metadata = null;
        try {
            metadata = JpegMetadataReader.readMetadata(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
        Iterator iterator = metadata.getDirectoryIterator();
        while (iterator.hasNext()) {
            Object object;
            directory = (Directory)iterator.next();
            Iterator iterator2 = directory.getTagIterator();
            while (iterator2.hasNext()) {
                object = (Tag)iterator2.next();
                try {
                    System.out.println("[" + directory.getName() + "] " + ((Tag)object).getTagName() + " = " + ((Tag)object).getDescription());
                }
                catch (MetadataException metadataException) {
                    System.err.println(metadataException.getMessage());
                    System.err.println(((Tag)object).getDirectoryName() + " " + ((Tag)object).getTagName() + " (error)");
                }
            }
            if (!directory.hasErrors()) continue;
            object = directory.getErrors();
            while (object.hasNext()) {
                System.out.println("ERROR: " + object.next());
            }
        }
        if (stringArray.length > 1 && stringArray[1].trim().equals("/thumb")) {
            directory = (ExifDirectory)metadata.getDirectory(ExifDirectory.class);
            if (((ExifDirectory)directory).containsThumbnail()) {
                System.out.println("Writing thumbnail...");
                ((ExifDirectory)directory).writeThumbnail(stringArray[0].trim() + ".thumb.jpg");
            } else {
                System.out.println("No thumbnail data exists in this image");
            }
        }
    }
}

