/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class XmlWriter {
    protected final PrintWriter out;
    private static final HashMap<Character, String> encoding = new HashMap();

    protected XmlWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public static String encode(String string) {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = encoding.get(Character.valueOf(string.charAt(i)));
            if (string2 != null) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.substring(0, i));
                }
                stringBuilder.append(string2);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static void output(OutputStream outputStream, OsmWriterInterface osmWriterInterface) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        printWriter.println("<?xml version='1.0' encoding='UTF-8'?>");
        osmWriterInterface.header(printWriter);
        osmWriterInterface.write(printWriter);
        osmWriterInterface.footer(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    static {
        encoding.put(Character.valueOf('<'), "&lt;");
        encoding.put(Character.valueOf('>'), "&gt;");
        encoding.put(Character.valueOf('\"'), "&quot;");
        encoding.put(Character.valueOf('\''), "&apos;");
        encoding.put(Character.valueOf('&'), "&amp;");
        encoding.put(Character.valueOf('\n'), "&#xA;");
        encoding.put(Character.valueOf('\r'), "&#xD;");
        encoding.put(Character.valueOf('\t'), "&#x9;");
    }

    public static interface OsmWriterInterface {
        public void header(PrintWriter var1);

        public void write(PrintWriter var1);

        public void footer(PrintWriter var1);
    }
}

