/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader {
    public GpxData data;

    public GpxReader(InputStream inputStream, File file) throws SAXException, IOException {
        Parser parser = new Parser();
        InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.newSAXParser().parse(inputSource, (DefaultHandler)parser);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        private GpxData currentData;
        private GpxTrack currentTrack;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private state currentState = state.init;
        private GpxLink currentLink;
        private Stack<state> states;
        private StringBuffer accumulator = new StringBuffer();

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.states = new Stack();
            this.currentData = new GpxData();
        }

        private double parseCoord(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }

        private LatLon parseLatLon(Attributes attributes) {
            return new LatLon(this.parseCoord(attributes.getValue("lat")), this.parseCoord(attributes.getValue("lon")));
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.currentState) {
                case init: {
                    if (string2.equals("metadata")) {
                        this.states.push(this.currentState);
                        this.currentState = state.metadata;
                        break;
                    }
                    if (string2.equals("wpt")) {
                        this.states.push(this.currentState);
                        this.currentState = state.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (string2.equals("rte")) {
                        this.states.push(this.currentState);
                        this.currentState = state.rte;
                        this.currentRoute = new GpxRoute();
                        break;
                    }
                    if (string2.equals("trk")) {
                        this.states.push(this.currentState);
                        this.currentState = state.trk;
                        this.currentTrack = new GpxTrack();
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.ext;
                    break;
                }
                case author: {
                    if (!string2.equals("link")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.link;
                    this.currentLink = new GpxLink(attributes.getValue("href"));
                    break;
                }
                case trk: {
                    if (string2.equals("trkseg")) {
                        this.states.push(this.currentState);
                        this.currentState = state.trkseg;
                        this.currentTrackSeg = new ArrayList<WayPoint>();
                        break;
                    }
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = state.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.ext;
                    break;
                }
                case metadata: {
                    if (string2.equals("author")) {
                        this.states.push(this.currentState);
                        this.currentState = state.author;
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.ext;
                    break;
                }
                case trkseg: {
                    if (!string2.equals("trkpt")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.wpt;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                    break;
                }
                case wpt: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = state.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.ext;
                    break;
                }
                case rte: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = state.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (string2.equals("rtept")) {
                        this.states.push(this.currentState);
                        this.currentState = state.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = state.ext;
                    break;
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case rte: {
                    return this.currentRoute.attr;
                }
                case metadata: {
                    return this.currentData.attr;
                }
                case wpt: {
                    return this.currentWayPoint.attr;
                }
                case trk: {
                    return this.currentTrack.attr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            switch (this.currentState) {
                case metadata: {
                    if (string2.equals("name") || string2.equals("desc") || string2.equals("time") || string2.equals("keywords")) {
                        this.currentData.attr.put(string2, this.accumulator.toString());
                        break;
                    }
                    if (!string2.equals("metadata")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                case author: {
                    if (string2.equals("author")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string2.equals("name") || string2.equals("email")) {
                        this.currentData.attr.put("author" + string2, this.accumulator.toString());
                        break;
                    }
                    if (!string2.equals("link")) break;
                    this.currentData.attr.put("authorlink", this.currentLink);
                    break;
                }
                case link: {
                    if (string2.equals("text")) {
                        this.currentLink.text = this.accumulator.toString();
                    } else if (string2.equals("type")) {
                        this.currentLink.type = this.accumulator.toString();
                    } else if (string2.equals("link")) {
                        if (this.currentLink.uri == null) {
                            this.currentLink.uri = this.accumulator.toString();
                        }
                        this.currentState = this.states.pop();
                    }
                    if (this.currentState == state.author) {
                        this.currentData.attr.put("authorlink", this.currentLink);
                        break;
                    }
                    if (this.currentState == state.link) break;
                    Map<String, Object> map = this.getAttr();
                    if (!map.containsKey("link")) {
                        map.put("link", new LinkedList());
                    }
                    ((Collection)map.get("link")).add(this.currentLink);
                    break;
                }
                case wpt: {
                    if (string2.equals("ele") || string2.equals("magvar") || string2.equals("name") || string2.equals("geoidheight") || string2.equals("type") || string2.equals("sym")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("hdop")) {
                        try {
                            this.currentWayPoint.attr.put(string2, Float.valueOf(Float.parseFloat(this.accumulator.toString())));
                        }
                        catch (Exception exception) {
                            this.currentWayPoint.attr.put(string2, new Float(0.0f));
                        }
                        break;
                    }
                    if (string2.equals("time")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string2.equals("cmt") || string2.equals("desc")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        this.currentWayPoint.setGarminCommentTime(string2);
                        break;
                    }
                    if (string2.equals("rtept")) {
                        this.currentState = this.states.pop();
                        this.currentRoute.routePoints.add(this.currentWayPoint);
                        break;
                    }
                    if (string2.equals("trkpt")) {
                        this.currentState = this.states.pop();
                        this.currentTrackSeg.add(this.currentWayPoint);
                        break;
                    }
                    if (!string2.equals("wpt")) break;
                    this.currentState = this.states.pop();
                    this.currentData.waypoints.add(this.currentWayPoint);
                    break;
                }
                case trkseg: {
                    if (!string2.equals("trkseg")) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.trackSegs.add(this.currentTrackSeg);
                    break;
                }
                case trk: {
                    if (string2.equals("trk")) {
                        this.currentState = this.states.pop();
                        this.currentData.tracks.add(this.currentTrack);
                        break;
                    }
                    if (!string2.equals("name") && !string2.equals("cmt") && !string2.equals("desc") && !string2.equals("src") && !string2.equals("type") && !string2.equals("number")) break;
                    this.currentTrack.attr.put(string2, this.accumulator.toString());
                    break;
                }
                case ext: {
                    if (!string2.equals("extensions")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                default: {
                    if (string2.equals("wpt")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!string2.equals("rte")) break;
                    this.currentState = this.states.pop();
                    this.currentData.routes.add(this.currentRoute);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for gpx document"));
            }
            GpxReader.this.data = this.currentData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum state {
        init,
        metadata,
        wpt,
        rte,
        trk,
        ext,
        author,
        link,
        trkseg;

    }
}

