/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.download.SizeButton;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.SourceButton;

public class OsmMapControl
extends MouseAdapter
implements MouseMotionListener,
MouseListener {
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    private final SlippyMapChooser iSlippyMapChooser;
    private SizeButton iSizeButton = null;
    private SourceButton iSourceButton = null;

    public OsmMapControl(SlippyMapChooser slippyMapChooser, JPanel jPanel, SizeButton sizeButton, SourceButton sourceButton) {
        this.iSlippyMapChooser = slippyMapChooser;
        this.iSlippyMapChooser.addMouseListener(this);
        this.iSlippyMapChooser.addMouseMotionListener(this);
        String[] stringArray = new String[]{",", ".", "up", "right", "down", "left"};
        int[] nArray = new int[]{44, 46, 38, 39, 40, 37};
        if (jPanel != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(nArray[i], 128), "MapMover.Zoomer." + stringArray[i]);
            }
        }
        this.iSizeButton = sizeButton;
        this.iSourceButton = sourceButton;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && !this.iSizeButton.hit(mouseEvent.getPoint())) {
            this.iStartSelectionPoint = mouseEvent.getPoint();
            this.iEndSelectionPoint = mouseEvent.getPoint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x400) == 1024 && this.iStartSelectionPoint != null) {
            this.iEndSelectionPoint = mouseEvent.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, this.iEndSelectionPoint);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            int n = this.iSourceButton.hit(mouseEvent.getPoint());
            if (this.iSizeButton.hit(mouseEvent.getPoint())) {
                this.iSizeButton.toggle();
                this.iSlippyMapChooser.resizeSlippyMap();
            } else if (n == 1) {
                this.iSourceButton.toggle();
                this.iSlippyMapChooser.repaint();
            } else if (n == 2 || n == 3 || n == 4) {
                this.iSlippyMapChooser.toggleMapSource(n);
            } else if (mouseEvent.getClickCount() == 1) {
                this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, mouseEvent.getPoint());
                this.iEndSelectionPoint = null;
                this.iStartSelectionPoint = null;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

