/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelection
implements DownloadSelection {
    private JTextField[] latlon = new JTextField[]{new JTextField(11), new JTextField(11), new JTextField(11), new JTextField(11)};
    final JTextArea osmUrl = new JTextArea();
    final JTextArea showUrl = new JTextArea();

    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            double d = Double.parseDouble(BoundingBoxSelection.this.latlon[0].getText());
                            double d2 = Double.parseDouble(BoundingBoxSelection.this.latlon[1].getText());
                            double d3 = Double.parseDouble(BoundingBoxSelection.this.latlon[2].getText());
                            double d4 = Double.parseDouble(BoundingBoxSelection.this.latlon[3].getText());
                            if (d != downloadDialog.minlat || d2 != downloadDialog.minlon || d3 != downloadDialog.maxlat || d4 != downloadDialog.maxlon) {
                                downloadDialog.minlat = d;
                                downloadDialog.minlon = d2;
                                downloadDialog.maxlat = d3;
                                downloadDialog.maxlon = d4;
                                downloadDialog.boundingBoxChanged(BoundingBoxSelection.this);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        BoundingBoxSelection.this.updateUrl(downloadDialog);
                    }
                });
            }
        };
        for (JTextField jTextField : this.latlon) {
            jTextField.setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            jTextField.addFocusListener(focusAdapter);
        }
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && BoundingBoxSelection.this.parseURL(downloadDialog)) {
                    downloadDialog.closeDownloadDialog(true);
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.osmUrl.addKeyListener(keyListener);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OsmUrlRefresher
        implements DocumentListener {
            OsmUrlRefresher() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                BoundingBoxSelection.this.parseURL(downloadDialog);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                BoundingBoxSelection.this.parseURL(downloadDialog);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                BoundingBoxSelection.this.parseURL(downloadDialog);
            }
        }
        this.osmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.osmUrl.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BoundingBoxSelection.this.osmUrl.selectAll();
                    }
                });
            }
        });
        this.osmUrl.setLineWrap(true);
        this.osmUrl.setBorder(this.latlon[0].getBorder());
        jPanel.add((Component)new JLabel(I18n.tr("min lat")), GBC.std().insets(10, 20, 5, 0));
        jPanel.add((Component)this.latlon[0], GBC.std().insets(0, 20, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("min lon")), GBC.std().insets(10, 20, 5, 0));
        jPanel.add((Component)this.latlon[1], GBC.eol().insets(0, 20, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("max lat")), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.latlon[2], GBC.std());
        jPanel.add((Component)new JLabel(I18n.tr("max lon")), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.latlon[3], GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("URL from www.openstreetmap.org (you can paste an URL here to download the area)")), GBC.eol().insets(10, 20, 5, 0));
        jPanel.add((Component)this.osmUrl, GBC.eop().insets(10, 0, 5, 0).fill());
        jPanel.add((Component)this.showUrl, GBC.eop().insets(10, 0, 5, 5));
        this.showUrl.setEditable(false);
        this.showUrl.setBackground(jPanel.getBackground());
        this.showUrl.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BoundingBoxSelection.this.showUrl.selectAll();
            }
        });
        downloadDialog.tabpane.addTab(I18n.tr("Bounding Box"), jPanel);
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        this.updateBboxFields(downloadDialog);
        this.updateUrl(downloadDialog);
    }

    private boolean parseURL(DownloadDialog downloadDialog) {
        Bounds bounds = OsmUrlToBounds.parse(this.osmUrl.getText());
        if (bounds == null) {
            return false;
        }
        downloadDialog.minlon = bounds.min.lon();
        downloadDialog.minlat = bounds.min.lat();
        downloadDialog.maxlon = bounds.max.lon();
        downloadDialog.maxlat = bounds.max.lat();
        downloadDialog.boundingBoxChanged(this);
        this.updateBboxFields(downloadDialog);
        this.updateUrl(downloadDialog);
        return true;
    }

    private void updateBboxFields(DownloadDialog downloadDialog) {
        this.latlon[0].setText(Double.toString(downloadDialog.minlat));
        this.latlon[1].setText(Double.toString(downloadDialog.minlon));
        this.latlon[2].setText(Double.toString(downloadDialog.maxlat));
        this.latlon[3].setText(Double.toString(downloadDialog.maxlon));
        for (JTextField jTextField : this.latlon) {
            jTextField.setCaretPosition(0);
        }
    }

    private void updateUrl(DownloadDialog downloadDialog) {
        int n;
        double d = (downloadDialog.minlat + downloadDialog.maxlat) / 2.0;
        double d2 = (downloadDialog.minlon + downloadDialog.maxlon) / 2.0;
        double d3 = Math.log(Math.tan(0.7853981633974483 + downloadDialog.minlat / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d4 = Math.log(Math.tan(0.7853981633974483 + downloadDialog.maxlat / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d5 = Math.max(Math.abs(d4 - d3), Math.abs(downloadDialog.maxlon - downloadDialog.minlon));
        for (n = 0; n <= 20 && !(d5 >= 180.0); d5 *= 2.0, ++n) {
        }
        int n2 = (int)Math.pow(10.0, n / 3);
        d = Math.round(d * (double)n2);
        d2 = Math.round(d2 * (double)n2);
        this.showUrl.setText("http://www.openstreetmap.org/?lat=" + (d /= (double)n2) + "&lon=" + (d2 /= (double)n2) + "&zoom=" + n);
    }
}

