/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SplashScreen
extends JWindow {
    private JLabel status;
    private boolean visible;
    private Runnable closerRunner;
    private AWTEventListener awtListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getSource() != SplashScreen.this) {
                SplashScreen.this.closeSplash();
            }
        }
    };

    public SplashScreen(boolean bl) {
        this.visible = bl;
        if (!bl) {
            return;
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        EtchedBorder etchedBorder = new EtchedBorder(1, Color.white, Color.gray);
        jPanel.setBorder(etchedBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 2, 10));
        jPanel.add(jPanel2);
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ImageProvider.get("logo.png"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        jLabel2.setFont(new Font("Helvetica", 1, 20));
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(I18n.tr("Version {0}", AboutAction.getVersionString()));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 5, 0);
        jPanel2.add((Component)jSeparator, gridBagConstraints);
        this.status = new JLabel();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.status, gridBagConstraints);
        this.setStatus(I18n.tr("Initializing"));
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jPanel.getPreferredSize();
        this.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        this.closerRunner = new Runnable(){

            public void run() {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    SplashScreen.this.closerRunner.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 64L);
        this.setVisible(true);
    }

    public void setStatus(String string) {
        if (!this.visible) {
            return;
        }
        this.status.setText(string + "...");
    }

    public void closeSplash() {
        if (!this.visible) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        try {
            SwingUtilities.invokeLater(this.closerRunner);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

