/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Cursors currCursor = Cursors.crosshair;
    private static Node lastUsedNode = null;
    private double PHI = Math.toRadians(90.0);
    private boolean ctrl;
    private boolean alt;
    private boolean shift;
    private Node mouseOnExistingNode;
    private Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private boolean drawHelperLine;
    private boolean wayIsFinished = false;
    private boolean drawTargetHighlight;
    private boolean drawTargetCursor;
    private Point mousePos;
    private Point oldMousePos;
    private Color selectedColor;
    private Node currentBaseNode;
    private EastNorth currentMouseEastNorth;

    public DrawAction(MapFrame mapFrame) {
        super(I18n.tr("Draw"), "node/autonode", I18n.tr("Draw nodes"), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw")), 65, 3), mapFrame, DrawAction.getCursor());
        Main.contentPane.getInputMap(2).put(Shortcut.registerShortcut("mapmode:drawfocus", I18n.tr("Mode: Draw Focus"), 78, 3).getKeyStroke(), I18n.tr("Draw"));
        this.cursorCrosshair = DrawAction.getCursor();
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor("crosshair", null);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void setCursor(final Cursors cursors) {
        if (this.currCursor.equals((Object)cursors) || !this.drawTargetCursor && this.currCursor.equals((Object)Cursors.crosshair)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!(Main.map.mapMode instanceof DrawAction)) {
                        return;
                    }
                    switch (cursors) {
                        case way: {
                            Main.map.mapView.setCursor(DrawAction.this.cursorJoinWay);
                            break;
                        }
                        case node: {
                            Main.map.mapView.setCursor(DrawAction.this.cursorJoinNode);
                            break;
                        }
                        default: {
                            Main.map.mapView.setCursor(DrawAction.this.cursorCrosshair);
                        }
                    }
                }
            });
            this.currCursor = cursors;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void redrawIfRequired() {
        this.updateStatusLine();
        if (!(this.drawHelperLine && !this.wayIsFinished || this.drawTargetHighlight)) {
            return;
        }
        Main.map.mapView.repaint();
    }

    private void addHighlighting() {
        this.removeHighlighting();
        if (this.ctrl) {
            this.setCursor(Cursors.crosshair);
            return;
        }
        if (this.mouseOnExistingNode == null && Main.ds.getSelected().size() == 0 && this.mousePos != null && !this.shift) {
            this.mouseOnExistingNode = Main.map.mapView.getNearestNode(this.mousePos);
        }
        if (this.mouseOnExistingNode != null) {
            this.setCursor(Cursors.node);
            this.oldHighlights.add(this.mouseOnExistingNode);
            if (this.drawTargetHighlight) {
                this.mouseOnExistingNode.highlighted = true;
            }
            return;
        }
        if (this.mouseOnExistingWays.size() == 0) {
            this.setCursor(Cursors.crosshair);
            return;
        }
        this.setCursor(Cursors.way);
        this.oldHighlights.addAll(this.mouseOnExistingWays);
        if (!this.drawTargetHighlight) {
            return;
        }
        for (Way way : this.mouseOnExistingWays) {
            way.highlighted = true;
        }
    }

    private void removeHighlighting() {
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.highlighted = false;
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.currCursor = Cursors.crosshair;
        this.selectedColor = Main.pref.getColor(I18n.marktr("selected"), Color.red);
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.drawTargetCursor = Main.pref.getBoolean("draw.target-cursor", true);
        this.wayIsFinished = false;
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.selListeners.add(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.selListeners.remove(this);
        this.removeHighlighting();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)aWTEvent);
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.wayIsFinished = false;
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    private void tryAgain(MouseEvent mouseEvent) {
        Main.ds.setSelected(new OsmPrimitive[0]);
        this.mouseClicked(mouseEvent);
    }

    private void finishDrawing() {
        lastUsedNode = null;
        this.wayIsFinished = true;
        Main.map.selectSelectTool(true);
        this.computeHelperLine();
        this.removeHighlighting();
        this.redrawIfRequired();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Object object3;
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        if (mouseEvent.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        Node node = null;
        if (!this.ctrl && !this.shift) {
            node = Main.map.mapView.getNearestNode(this.mousePos);
        }
        if (node != null) {
            if (collection.isEmpty()) {
                Main.ds.setSelected(node);
                collection = Main.ds.getSelected();
                return;
            }
        } else {
            node = new Node(Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY()));
            if (node.coor.isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world."));
                return;
            }
            bl = true;
            linkedList.add(new AddCommand(node));
            if (!this.ctrl) {
                List<WaySegment> list = Main.map.mapView.getNearestWaySegments(mouseEvent.getPoint());
                HashMap hashMap = new HashMap();
                for (WaySegment iterator2 : list) {
                    void var12_22;
                    if (hashMap.containsKey(iterator2.way)) {
                        List list2 = (List)hashMap.get(iterator2.way);
                    } else {
                        ArrayList arrayList3 = new ArrayList();
                        hashMap.put(iterator2.way, arrayList3);
                    }
                    var12_22.add(iterator2.lowerIndex);
                }
                object3 = new HashSet();
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n;
                    Way way = (Way)entry.getKey();
                    List list3 = (List)entry.getValue();
                    object = new Way(way);
                    DrawAction.pruneSuccsAndReverse(list3);
                    Iterator iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        object3.add(Pair.sort(new Pair<Node, Node>(way.nodes.get(n), way.nodes.get(n + 1))));
                    }
                    Iterator iterator2 = list3.iterator();
                    while (iterator2.hasNext()) {
                        n = (Integer)iterator2.next();
                        ((Way)object).addNode(n + 1, node);
                    }
                    if (this.alt) {
                        ((Way)object).selected = false;
                    }
                    linkedList.add(new ChangeCommand((OsmPrimitive)entry.getKey(), (OsmPrimitive)object));
                    arrayList2.add(entry.getKey());
                    arrayList.add(object);
                }
                DrawAction.adjustNode((Collection<Pair<Node, Node>>)object3, node);
            }
        }
        boolean bl2 = false;
        boolean bl3 = this.wayIsFinished;
        this.wayIsFinished = false;
        if (collection.size() > 0) {
            void var11_16;
            object3 = null;
            Object var11_15 = null;
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive instanceof Node) {
                    if (object3 != null) {
                        this.tryAgain(mouseEvent);
                        return;
                    }
                    object3 = (Node)osmPrimitive;
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                if (var11_16 != null) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                Way way = (Way)osmPrimitive;
            }
            Node node2 = this.findNodeToContinueFrom((Node)object3, (Way)var11_16);
            if (node2 == null) {
                this.tryAgain(mouseEvent);
                return;
            }
            if (!bl3) {
                void var13_41;
                void var13_37;
                Way way;
                if (this.isSelfContainedWay((Way)var11_16, node2, node)) {
                    return;
                }
                if (node2 == node) {
                    this.finishDrawing();
                    return;
                }
                Object object2 = this.alt ? null : (way = var11_16 != null ? var11_16 : DrawAction.getWayForNode(node2));
                if (way != null) {
                    int n = 0;
                    for (Node node3 : way.nodes) {
                        if (!node3.equals(node2)) continue;
                        ++n;
                    }
                    if (n > 1) {
                        Object var13_36 = null;
                    }
                }
                if (var13_37 == null) {
                    Way way2 = new Way();
                    way2.addNode(node2);
                    linkedList.add(new AddCommand(way2));
                } else {
                    int n = arrayList2.indexOf(var13_37);
                    if (n != -1) {
                        Way way3 = (Way)arrayList.get(n);
                    } else {
                        object = new Way((Way)var13_37);
                        linkedList.add(new ChangeCommand((OsmPrimitive)var13_37, (OsmPrimitive)object));
                        Object object4 = object;
                    }
                }
                if (var13_41.nodes.contains(node)) {
                    this.wayIsFinished = true;
                    collection.clear();
                }
                if (var13_41.nodes.get(var13_41.nodes.size() - 1) == node2) {
                    var13_41.addNode(node);
                } else {
                    var13_41.addNode(0, node);
                }
                bl2 = true;
                Main.ds.setSelected(new OsmPrimitive[]{var13_41});
            }
        }
        if (!bl2) {
            if (!bl) {
                return;
            }
            if (arrayList.isEmpty()) {
                object3 = I18n.tr("Add node");
            } else {
                object3 = I18n.tr("Add node into way");
                for (Way way : arrayList) {
                    way.selected = false;
                }
            }
            Main.ds.setSelected(node);
        } else {
            object3 = !bl ? I18n.tr("Connect existing way to node") : (arrayList.isEmpty() ? I18n.tr("Add a new node to an existing way") : I18n.tr("Add node into way and connect"));
        }
        SequenceCommand sequenceCommand = new SequenceCommand((String)object3, linkedList);
        Main.main.undoRedo.add(sequenceCommand);
        if (!this.wayIsFinished) {
            lastUsedNode = node;
        }
        this.computeHelperLine();
        this.removeHighlighting();
        this.redrawIfRequired();
    }

    private boolean isSelfContainedWay(Way way, Node node, Node node2) {
        int n;
        if (way != null && way.nodes != null && ((n = way.nodes.indexOf(node)) != -1 && n >= 1 && node2.equals(way.nodes.get(n - 1)) || n < way.nodes.size() - 1 && node2.equals(way.nodes.get(n + 1)))) {
            Main.ds.setSelected(node2);
            lastUsedNode = node2;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node node, Way way) {
        if (node == null && way == null) {
            return null;
        }
        if (node == null) {
            if (way.isFirstLastNode(lastUsedNode)) {
                return lastUsedNode;
            }
            return null;
        }
        if (way == null) {
            return node;
        }
        if (way.isFirstLastNode(node)) {
            return node;
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    private void updateKeyModifiers(InputEvent inputEvent) {
        this.ctrl = (inputEvent.getModifiers() & 2) != 0;
        this.alt = (inputEvent.getModifiers() & 0x28) != 0;
        this.shift = (inputEvent.getModifiers() & 1) != 0;
    }

    private void updateKeyModifiers(MouseEvent mouseEvent) {
        this.ctrl = (mouseEvent.getModifiers() & 2) != 0;
        this.alt = (mouseEvent.getModifiers() & 0x28) != 0;
        this.shift = (mouseEvent.getModifiers() & 1) != 0;
    }

    private void computeHelperLine() {
        Object object2;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        double d = -1.0;
        double d2 = -1.0;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        Node node = null;
        Way way = null;
        Node node2 = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        Main.map.statusLine.setAngle(-1.0);
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setDist(-1.0);
        if (!this.ctrl && !this.shift && this.mousePos != null) {
            node2 = Main.map.mapView.getNearestNode(this.mousePos);
        }
        if (!this.ctrl && node2 == null) {
            object2 = Main.map.mapView.getNearestWaySegments(this.mousePos);
            Iterator<WaySegment> object3 = object2.iterator();
            while (object3.hasNext()) {
                WaySegment waySegment = object3.next();
                this.mouseOnExistingWays.add(waySegment.way);
            }
        }
        if (node2 != null) {
            if (collection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = node2.eastNorth;
            this.mouseOnExistingNode = node2;
        } else {
            this.currentMouseEastNorth = Main.map.mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                if (node != null) {
                    return;
                }
                node = (Node)osmPrimitive;
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            if (way != null) {
                return;
            }
            way = (Way)osmPrimitive;
        }
        this.currentBaseNode = null;
        object2 = null;
        if (node == null) {
            if (way == null) {
                return;
            }
            if (way.isFirstLastNode(lastUsedNode)) {
                this.currentBaseNode = lastUsedNode;
                if (lastUsedNode == way.nodes.get(way.nodes.size() - 1) && way.nodes.size() > 1) {
                    object2 = way.nodes.get(way.nodes.size() - 2);
                }
            }
        } else if (way == null) {
            this.currentBaseNode = node;
        } else if (node == way.nodes.get(0) || node == way.nodes.get(way.nodes.size() - 1)) {
            this.currentBaseNode = node;
        }
        if (this.currentBaseNode == null || this.currentBaseNode == node2) {
            return;
        }
        LatLon latLon = Main.proj.eastNorth2latlon(this.currentMouseEastNorth);
        d = this.currentBaseNode.coor.greatCircleDistance(latLon);
        double d3 = Math.toDegrees(this.currentBaseNode.coor.heading(latLon));
        if (object2 != null && (d2 = d3 - Math.toDegrees(((Node)object2).coor.heading(this.currentBaseNode.coor))) < 0.0) {
            d2 += 360.0;
        }
        Main.map.statusLine.setAngle(d2);
        Main.map.statusLine.setHeading(d3);
        Main.map.statusLine.setDist(d);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        Main.map.mapView.repaint();
    }

    public static Way getWayForNode(Node node) {
        Way way = null;
        for (Way way2 : Main.ds.ways) {
            if (way2.deleted || way2.incomplete || way2.nodes.size() < 1) continue;
            Node node2 = way2.nodes.get(0);
            Node node3 = way2.nodes.get(way2.nodes.size() - 1);
            if (node2 != node && node3 != node || node2 == node3) continue;
            if (way != null) {
                return null;
            }
            way = way2;
        }
        return way;
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> collection, Node node) {
        double d;
        EastNorth eastNorth;
        EastNorth eastNorth2;
        Pair<Node, Node> pair;
        switch (collection.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> iterator = collection.iterator();
                pair = iterator.next();
                eastNorth2 = ((Node)pair.a).eastNorth;
                eastNorth = ((Node)pair.b).eastNorth;
                pair = iterator.next();
                EastNorth eastNorth3 = ((Node)pair.a).eastNorth;
                EastNorth eastNorth4 = ((Node)pair.b).eastNorth;
                double d2 = DrawAction.det(eastNorth.east() - eastNorth2.east(), eastNorth.north() - eastNorth2.north(), eastNorth3.east() - eastNorth4.east(), eastNorth3.north() - eastNorth4.north());
                if (d2 == 0.0) {
                    return;
                }
                d = DrawAction.det(eastNorth.north() - eastNorth3.north(), eastNorth.east() - eastNorth3.east(), eastNorth4.north() - eastNorth3.north(), eastNorth4.east() - eastNorth3.east()) / d2;
                EastNorth eastNorth5 = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
                int n = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
                if (!(Main.map.mapView.getPoint(node.eastNorth).distance(Main.map.mapView.getPoint(eastNorth5)) < (double)n)) break;
                node.eastNorth = eastNorth5;
                return;
            }
        }
        EastNorth eastNorth6 = node.eastNorth;
        pair = collection.iterator().next();
        eastNorth2 = ((Node)pair.a).eastNorth;
        eastNorth = ((Node)pair.b).eastNorth;
        double d3 = eastNorth6.distanceSq(eastNorth);
        double d4 = eastNorth6.distanceSq(eastNorth2);
        double d5 = eastNorth2.distanceSq(eastNorth);
        d = (d3 - d4 + d5) / (2.0 * d5);
        node.eastNorth = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        if (!this.drawHelperLine || this.wayIsFinished) {
            return;
        }
        if (Main.map.mapView == null) {
            return;
        }
        if (this.mousePos == null) {
            return;
        }
        if (this.currentBaseNode == null || this.currentMouseEastNorth == null) {
            return;
        }
        if (!Main.map.mapView.getBounds().contains(this.mousePos)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.selectedColor);
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        GeneralPath generalPath = new GeneralPath();
        Point point = mapView.getPoint(this.currentBaseNode.eastNorth);
        Point point2 = mapView.getPoint(this.currentMouseEastNorth);
        double d = Math.atan2(point2.y - point.y, point2.x - point.x) + Math.PI;
        generalPath.moveTo(point.x, point.y);
        generalPath.lineTo(point2.x, point2.y);
        if (this.alt) {
            generalPath.moveTo((int)((double)point.x + 8.0 * Math.cos(d + this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d + this.PHI)));
            generalPath.lineTo((int)((double)point.x + 8.0 * Math.cos(d - this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d - this.PHI)));
        }
        graphics2D.draw(generalPath);
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    @Override
    public String getModeHelpText() {
        OsmPrimitive osmPrimitive;
        String string = "";
        string = this.ctrl || this.oldHighlights.isEmpty() ? I18n.tr("Create new node.") : (this.shift ? I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size()) : ((osmPrimitive = this.oldHighlights.iterator().next()) instanceof Node ? I18n.tr("Select node under cursor.") : I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size())));
        if (this.currentBaseNode != null && !this.wayIsFinished) {
            string = this.alt ? string + " " + I18n.tr("Start new way from last node.") : string + " " + I18n.tr("Continue way from last node.");
        }
        if ((osmPrimitive = this.mouseOnExistingNode) != null && Main.ds.getSelectedNodes().contains(osmPrimitive)) {
            string = this.wayIsFinished ? I18n.tr("Select node under cursor.") : I18n.tr("Finish drawing.");
        }
        if (Main.ds.getSelectedWays().size() > 0 && !this.wayIsFinished && !this.alt) {
            Way way = (Way)Main.ds.getSelectedWays().iterator().next();
            for (Node node : way.nodes) {
                if (!node.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(way)) continue;
                string = string + " " + I18n.tr("Finish drawing.");
                break;
            }
        }
        return string;
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Cursors {
        crosshair,
        node,
        way;

    }
}

