/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    private Layer layer;

    public SaveActionBase(String string, String string2, String string3, Shortcut shortcut, Layer layer) {
        super(string, string2, string3, shortcut);
        this.layer = layer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doSave();
    }

    public Boolean doSave() {
        Layer layer = this.layer;
        if (layer == null && Main.map != null && (Main.map.mapView.getActiveLayer() instanceof OsmDataLayer || Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            layer = Main.map.mapView.getActiveLayer();
        }
        if (layer == null) {
            layer = Main.main.editLayer();
        }
        if (!this.checkSaveConditions(layer)) {
            return false;
        }
        File file = this.getFile(layer);
        if (file == null) {
            return false;
        }
        SaveActionBase.save(file, layer);
        layer.name = file.getName();
        layer.associatedFile = file;
        Main.parent.repaint();
        return true;
    }

    protected abstract File getFile(Layer var1);

    public boolean checkSaveConditions(Layer layer) {
        int n;
        if (layer == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Internal Error: cannot check conditions for no layer. Please report this as a bug."));
            return false;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No document open so nothing to save."));
            return false;
        }
        if (layer instanceof OsmDataLayer && this.isDataSetEmpty((OsmDataLayer)layer) && 1 != new ExtendedDialog(Main.parent, I18n.tr("Empty document"), I18n.tr("The document contains no data."), new String[]{I18n.tr("Save anyway"), I18n.tr("Cancel")}, new String[]{"save.png", "cancel.png"}).getValue()) {
            return false;
        }
        if (layer instanceof GpxLayer && ((GpxLayer)layer).data == null) {
            return false;
        }
        return Main.map.conflictDialog.conflicts.isEmpty() || (n = new ExtendedDialog(Main.parent, I18n.tr("Conflicts"), I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?"), new String[]{I18n.tr("Reject Conflicts and Save"), I18n.tr("Cancel")}, new String[]{"save.png", "cancel.png"}).getValue()) == 1;
    }

    public static File openFileDialog(Layer layer) {
        JFileChooser jFileChooser = SaveActionBase.createAndOpenFileChooser(false, false, layer instanceof GpxLayer ? I18n.tr("Save GPX file") : I18n.tr("Save OSM file"));
        if (jFileChooser == null) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getPath();
        if (string.indexOf(46) == -1) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            string = fileFilter instanceof ExtensionFileFilter ? string + "." + ((ExtensionFileFilter)fileFilter).defaultExtension : (layer instanceof GpxLayer ? string + ".gpx" : string + ".osm");
            file = new File(string);
        }
        return file;
    }

    private static void copy(File file, File file2) throws IOException {
        int n;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not back up file.") + "\n" + fileNotFoundException.getMessage());
            return;
        }
        byte[] byArray = new byte[65536];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void save(File file, Layer layer) {
        if (layer instanceof GpxLayer) {
            SaveActionBase.save(file, (GpxLayer)layer);
            ((GpxLayer)layer).data.storageFile = file;
        } else if (layer instanceof OsmDataLayer) {
            SaveActionBase.save(file, (OsmDataLayer)layer);
        }
    }

    public static void save(File file, OsmDataLayer osmDataLayer) {
        File file2 = null;
        try {
            if (ExtensionFileFilter.filters[1].acceptName(file.getPath())) {
                GpxExportAction.exportGpx(file, osmDataLayer);
            } else if (ExtensionFileFilter.filters[0].acceptName(file.getPath())) {
                if (file.exists()) {
                    file2 = new File(file.getPath() + "~");
                    SaveActionBase.copy(file, file2);
                }
                OsmWriter.output(new FileOutputStream(file), new OsmWriter.All(osmDataLayer.data, false));
                if (!Main.pref.getBoolean("save.keepbackup") && file2 != null) {
                    file2.delete();
                }
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unknown file extension."));
                return;
            }
            osmDataLayer.cleanData(null, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while saving.") + "\n" + iOException.getMessage());
            try {
                if (file2 != null && file2.exists()) {
                    SaveActionBase.copy(file2, file);
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while restoring backup file.") + "\n" + iOException2.getMessage());
            }
        }
    }

    public static void save(File file, GpxLayer gpxLayer) {
        File file2;
        block8: {
            file2 = null;
            try {
                if (ExtensionFileFilter.filters[1].acceptName(file.getPath())) {
                    if (file.exists()) {
                        file2 = new File(file.getPath() + "~");
                        SaveActionBase.copy(file, file2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    new GpxWriter(fileOutputStream).write(gpxLayer.data);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    if (!Main.pref.getBoolean("save.keepbackup") && file2 != null) {
                        file2.delete();
                    }
                    break block8;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unknown file extension."));
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while saving.") + "\n" + iOException.getMessage());
            }
        }
        try {
            if (file2 != null && file2.exists()) {
                SaveActionBase.copy(file2, file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while restoring backup file.") + "\n" + iOException.getMessage());
        }
    }

    private boolean isDataSetEmpty(OsmDataLayer osmDataLayer) {
        for (OsmPrimitive osmPrimitive : osmDataLayer.data.allNonDeletedPrimitives()) {
            if (osmPrimitive.deleted && osmPrimitive.id <= 0L) continue;
            return false;
        }
        return true;
    }
}

