/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    public static final String[] modes = new String[]{I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download")};
    private final String mode;

    private static int getModeShortcut(String string) {
        int n = -1;
        if (string.equals("data")) {
            n = 49;
        }
        if (string.equals("layer")) {
            n = 50;
        }
        if (string.equals("selection")) {
            n = 51;
        }
        if (string.equals("conflict")) {
            n = 52;
        }
        if (string.equals("download")) {
            n = 53;
        }
        return n;
    }

    public AutoScaleAction(String string) {
        super(I18n.tr("Zoom to {0}", I18n.tr(string)), "dialogs/autoscale/" + string, I18n.tr("Zoom the view to {0}.", I18n.tr(string)), Shortcut.registerShortcut("view:zoom" + string, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(string))), AutoScaleAction.getModeShortcut(string), 3), true);
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.putValue("help", "Action/AutoScale/" + string2);
        this.mode = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        BoundingXYVisitor boundingXYVisitor;
        if (Main.map != null && (boundingXYVisitor = this.getBoundingBox()) != null) {
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }
        this.putValue("active", true);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor boundingXYVisitor;
        block6: {
            block8: {
                Collection<OsmPrimitive> collection;
                block7: {
                    block5: {
                        boundingXYVisitor = new BoundingXYVisitor();
                        if (!this.mode.equals("data")) break block5;
                        for (Layer layer : Main.map.mapView.getAllLayers()) {
                            layer.visitBoundingBox(boundingXYVisitor);
                        }
                        break block6;
                    }
                    if (!this.mode.equals("layer")) break block7;
                    Main.map.mapView.getActiveLayer().visitBoundingBox(boundingXYVisitor);
                    break block6;
                }
                if (!this.mode.equals("selection") && !this.mode.equals("conflict")) break block8;
                Collection<OsmPrimitive> collection2 = collection = this.mode.equals("selection") ? Main.ds.getSelected() : Main.map.conflictDialog.conflicts.keySet();
                if (collection.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, this.mode.equals("selection") ? I18n.tr("Nothing selected to zoom to.") : I18n.tr("No conflicts to zoom to"));
                    return null;
                }
                for (OsmPrimitive osmPrimitive : collection) {
                    osmPrimitive.visit(boundingXYVisitor);
                }
                boundingXYVisitor.enlargeBoundingBox();
                break block6;
            }
            if (!this.mode.equals("download") || !Main.pref.hasKey("osm-download.bounds")) break block6;
            try {
                String[] stringArray = Main.pref.get("osm-download.bounds").split(";");
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                double d3 = Double.parseDouble(stringArray[2]);
                double d4 = Double.parseDouble(stringArray[3]);
                boundingXYVisitor.visit(Main.proj.latlon2eastNorth(new LatLon(d, d2)));
                boundingXYVisitor.visit(Main.proj.latlon2eastNorth(new LatLon(d3, d4)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return boundingXYVisitor;
    }
}

