/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

public class OsmMercator {
    private static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;

    public static double radius(int n) {
        return (double)(TILE_SIZE * (1 << n)) / (Math.PI * 2);
    }

    public static int getMaxPixels(int n) {
        return TILE_SIZE * (1 << n);
    }

    public static int falseEasting(int n) {
        return OsmMercator.getMaxPixels(n) / 2;
    }

    public static int falseNorthing(int n) {
        return -1 * OsmMercator.getMaxPixels(n) / 2;
    }

    public static int LonToX(double d, int n) {
        double d2 = Math.toRadians(d);
        int n2 = (int)(OsmMercator.radius(n) * d2 + (double)OsmMercator.falseEasting(n));
        n2 = Math.min(n2, OsmMercator.getMaxPixels(n) - 1);
        return n2;
    }

    public static int LatToY(double d, int n) {
        if (d < -85.05112877980659) {
            d = -85.05112877980659;
        } else if (d > 85.05112877980659) {
            d = 85.05112877980659;
        }
        double d2 = Math.toRadians(d);
        int n2 = (int)(-1.0 * (OsmMercator.radius(n) / 2.0 * Math.log((1.0 + Math.sin(d2)) / (1.0 - Math.sin(d2)))) - (double)OsmMercator.falseNorthing(n));
        n2 = Math.min(n2, OsmMercator.getMaxPixels(n) - 1);
        return n2;
    }

    public static double XToLon(int n, int n2) {
        double d = (double)(n -= OsmMercator.falseEasting(n2)) / OsmMercator.radius(n2);
        double d2 = Math.toDegrees(d);
        return d2;
    }

    public static double YToLat(int n, int n2) {
        double d = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(n += OsmMercator.falseNorthing(n2)) / OsmMercator.radius(n2)));
        return -1.0 * Math.toDegrees(d);
    }
}

