/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;

public class GettingStarted
extends JPanel {
    private String content = "";
    private static String styles = "<style type=\"text/css\">\nbody { font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center;}\n</style>\n";

    public GettingStarted() {
        super(new BorderLayout());
        final LinkGeneral linkGeneral = new LinkGeneral("<html>" + styles + "<h1>" + "JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1><h2 align=\"center\">" + I18n.tr("Downloading \"Message of the day\"") + "</h2>");
        JScrollPane jScrollPane = new JScrollPane(linkGeneral);
        jScrollPane.setViewportBorder(new EmptyBorder(10, 100, 10, 100));
        this.add((Component)jScrollPane, "Center");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (GettingStarted.this.content.length() == 0 && Main.pref.getBoolean("help.displaymotd", true)) {
                    GettingStarted.this.content = new assignContent().updateIfRequiredString();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        linkGeneral.setText(GettingStarted.this.content);
                    }
                });
            }
        }, "MOTD-Loader");
        thread.setDaemon(true);
        thread.start();
        new FileDrop(jScrollPane);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class assignContent
    extends CacheCustomContent {
        private final int myVersion;

        public assignContent() {
            super("motd.html", 86400);
            this.myVersion = AboutAction.getVersionNumber();
        }

        @Override
        protected byte[] updateData() {
            int n;
            String string = "";
            String string2 = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
            WikiReader wikiReader = new WikiReader(string2);
            String string3 = "";
            try {
                string3 = wikiReader.read(string2 + "/wiki/MessageOfTheDay?format=txt");
            }
            catch (IOException iOException) {
                string3 = "<html>" + styles + "<body><h1>" + "JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1>\n<h2 align=\"center\">(" + I18n.tr("Message of the day not available") + ")</h2>";
            }
            String string4 = Main.getLanguageCodeU();
            Pattern pattern = Pattern.compile("\\[wiki:(?:[A-Z]+:)?MessageOfTheDay(\\>\\=|\\<\\=|\\<|\\>)([0-9]+)\\s*([A-Z]*)\\]", 2);
            Matcher matcher = pattern.matcher(string3);
            matcher.reset();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            String string5 = "";
            while (matcher.find()) {
                if (!(matcher.group(3) + ":").equals(string4) && !matcher.group(3).equals("")) continue;
                arrayList.add(new String[]{matcher.group(1), matcher.group(2), matcher.group(3)});
                string5 = string5 + matcher.group(1) + matcher.group(2) + matcher.group(3) + ": ";
            }
            ExecutorService executorService = Executors.newCachedThreadPool();
            ArrayList<Future<String>> arrayList2 = new ArrayList<Future<String>>();
            for (n = 0; n < arrayList.size(); ++n) {
                String[] stringArray = (String[])arrayList.get(n);
                int n2 = Integer.parseInt(stringArray[1]);
                String string6 = stringArray[0];
                Boolean bl = !stringArray[2].equals("");
                if (!bl.booleanValue() && string5.indexOf(string6 + stringArray[1] + string4 + " ") >= 0) continue;
                boolean bl2 = false;
                if (this.myVersion == 0) {
                    bl2 = true;
                } else if (string6.equals(">=")) {
                    bl2 = this.myVersion >= n2;
                } else if (string6.equals(">")) {
                    bl2 = this.myVersion > n2;
                } else if (string6.equals("<")) {
                    bl2 = this.myVersion < n2;
                } else {
                    boolean bl3 = bl2 = this.myVersion <= n2;
                }
                if (!bl2) continue;
                boolean bl4 = n2 == 1;
                String string7 = string2 + "/wiki/";
                String string8 = "MessageOfTheDay" + string6 + n2 + (bl4 ? "" : "?format=txt");
                String string9 = string7 + string4 + string8;
                String string10 = string7 + string8;
                arrayList2.add(executorService.submit(new readMOTD(bl, string2, string9, string10, bl4)));
            }
            arrayList2.add(executorService.submit(new readMOTD(false, string2, "", string2 + "/version?format=txt", true)));
            for (n = 0; n < arrayList2.size() - 1; ++n) {
                try {
                    string = string + (String)((Future)arrayList2.get(n)).get();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = "<html>" + styles + "<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1>" + string.replace("</html>", "") + this.getVersionNumber((Future)arrayList2.get(arrayList2.size() - 1)) + "</html>";
            arrayList2.clear();
            try {
                executorService.shutdown();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Main.pref.putInteger("cache.motd.html.version", this.myVersion);
            return string.getBytes();
        }

        @Override
        protected boolean isCacheValid() {
            return Main.pref.getInteger("cache.motd.html.version", this.myVersion) == this.myVersion;
        }

        private String getVersionNumber(Future<String> future) {
            try {
                String string = future.get();
                Matcher matcher = Pattern.compile(".*josm-tested\\.jar: *(\\d+).*", 32).matcher(string);
                matcher.matches();
                int n = Integer.parseInt(matcher.group(1));
                matcher = Pattern.compile(".*josm-latest\\.jar: *(\\d+).*", 32).matcher(string);
                matcher.matches();
                int n2 = Integer.parseInt(matcher.group(1));
                return "<div style=\"text-align:right;font-size:small;font-weight:normal;\"><b>" + (n > this.myVersion ? I18n.tr("Update available") + " &#151; " : "") + I18n.tr("Version Details:") + "</b> " + I18n.tr("Yours: {2}; Current: {0}; <font style=\"font-size:x-small\">(latest untested: {1} &#150; not recommended)</font>", n, n2, this.myVersion) + "</div>";
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class readMOTD
    implements Callable<String> {
        private boolean isLocalized;
        private boolean isHelp;
        private String urlLoc;
        private String urlIntl;
        private String urlBase;

        readMOTD(boolean bl, String string, String string2, String string3, boolean bl2) {
            this.isLocalized = bl;
            this.urlBase = string;
            this.urlLoc = string2;
            this.urlIntl = string3;
            this.isHelp = bl2;
        }

        @Override
        public String call() {
            WikiReader wikiReader = new WikiReader(this.urlBase);
            String string = "";
            try {
                String string2;
                String string3 = string2 = this.isLocalized ? wikiReader.read(this.urlLoc) : "";
                if (string2.equals("")) {
                    string2 = wikiReader.read(this.urlIntl);
                }
                if (!string2.equals("")) {
                    string = this.isHelp ? string + string2 : string + "<ul><li>" + string2.substring(8).replaceAll("\n *\\* +", "</li><li>") + "</li></ul>";
                }
            }
            catch (IOException iOException) {
                try {
                    string = this.isHelp ? string + wikiReader.read(this.urlIntl) : string + "<ul><li>" + wikiReader.read(this.urlIntl).substring(8).replaceAll("\n *\\* +", "</li><li>") + "</li></ul>";
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            return string;
        }
    }

    public class LinkGeneral
    extends JEditorPane
    implements HyperlinkListener {
        public LinkGeneral(String string) {
            this.setContentType("text/html");
            this.setText(string);
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(this);
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl(hyperlinkEvent.getDescription());
            }
        }
    }
}

