/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class WikiReader {
    public static final String JOSM_EXTERN = "http://josm-extern.";
    private final String baseurl;

    public WikiReader(String string) {
        this.baseurl = string;
    }

    public String read(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "utf-8"));
        if (string.startsWith(this.baseurl) && !string.endsWith("?format=txt")) {
            return this.readFromTrac(bufferedReader, string);
        }
        return this.readNormal(bufferedReader);
    }

    private String readNormal(BufferedReader bufferedReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        String string = bufferedReader.readLine();
        while (string != null) {
            string = this.adjustText(string);
            stringBuilder.append(string);
            stringBuilder.append("\n");
            string = bufferedReader.readLine();
        }
        return stringBuilder.toString();
    }

    private String readFromTrac(BufferedReader bufferedReader, String string) throws IOException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("<html>");
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.contains("<div id=\"searchable\">")) {
                bl = true;
            } else if (string2.contains("<div class=\"wikipage searchable\">")) {
                bl = true;
            } else if (string2.contains("<div class=\"buttons\">")) {
                bl = false;
            }
            if (bl) {
                string2 = string2.replaceAll("<img src=\"/", "<img src=\"" + this.baseurl + "/");
                if (!(string2 = string2.replaceAll("href=\"/", "href=\"" + this.baseurl + "/")).contains("$")) {
                    string2 = string2.replaceAll("<p>Describe \"([^\"]+)\" here</p>", "<p>Describe \"$1\" <a href=\"http://josm-extern." + string.substring(7) + "\">here</a></p>");
                }
                string2 = this.adjustText(string2);
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            string2 = bufferedReader.readLine();
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private String adjustText(String string) {
        string = string.replaceAll(" />", ">");
        return string;
    }
}

