/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OsmServerObjectReader
extends OsmServerReader {
    public static final String TYPE_WAY = "way";
    public static final String TYPE_REL = "relation";
    public static final String TYPE_NODE = "node";
    long id;
    String type;
    boolean full;

    public OsmServerObjectReader(long l, String string, boolean bl) {
        this.id = l;
        this.type = string;
        this.full = bl;
    }

    public DataSet parseOsm() throws SAXException, IOException {
        try {
            InputStream inputStream;
            Main.pleaseWaitDlg.progress.setValue(0);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contacting OSM Server..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.type);
            stringBuffer.append("/");
            stringBuffer.append(this.id);
            if (this.full) {
                stringBuffer.append("/full");
            }
            if ((inputStream = this.getInputStream(stringBuffer.toString(), Main.pleaseWaitDlg)) == null) {
                return null;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading OSM data..."));
            DataSet dataSet = OsmReader.parseDataSet(inputStream, null, Main.pleaseWaitDlg);
            inputStream.close();
            this.activeConnection = null;
            return dataSet;
        }
        catch (IOException iOException) {
            if (this.cancel) {
                return null;
            }
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                return null;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }
}

