/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetPreference
implements PreferenceSetting {
    public static Collection<TaggingPreset> taggingPresets;
    private JList taggingPresetSources;
    private JCheckBox sortMenu;
    private JCheckBox enableDefault;

    public void addGui(PreferenceDialog preferenceDialog) {
        this.taggingPresetSources = new JList(new DefaultListModel());
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu"), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        this.enableDefault = new JCheckBox(I18n.tr("Enable built-in defaults"), Main.pref.getBoolean("taggingpreset.enable-defaults", true));
        Collection<String> collection = Main.pref.getCollection("taggingpreset.sources", null);
        if (collection != null) {
            for (String object2 : collection) {
                ((DefaultListModel)this.taggingPresetSources.getModel()).addElement(object2);
            }
        }
        JButton jButton = new JButton(I18n.tr("Add"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr("Tagging preset source"));
                if (string != null) {
                    ((DefaultListModel)TaggingPresetPreference.this.taggingPresetSources.getModel()).addElement(string);
                }
            }
        });
        JButton jButton2 = new JButton(I18n.tr("Edit"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TaggingPresetPreference.this.taggingPresetSources.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit."));
                } else {
                    String string = JOptionPane.showInputDialog(Main.parent, I18n.tr("Tagging preset source"), TaggingPresetPreference.this.taggingPresetSources.getSelectedValue());
                    if (string != null) {
                        ((DefaultListModel)TaggingPresetPreference.this.taggingPresetSources.getModel()).setElementAt(string, TaggingPresetPreference.this.taggingPresetSources.getSelectedIndex());
                    }
                }
            }
        });
        JButton jButton3 = new JButton(I18n.tr("Delete"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TaggingPresetPreference.this.taggingPresetSources.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete."));
                } else {
                    ((DefaultListModel)TaggingPresetPreference.this.taggingPresetSources.getModel()).remove(TaggingPresetPreference.this.taggingPresetSources.getSelectedIndex());
                }
            }
        });
        this.taggingPresetSources.setVisibleRowCount(3);
        this.taggingPresetSources.setToolTipText(I18n.tr("The sources (URL or filename) of tagging preset definition files. See http://josm.openstreetmap.de/wiki/TaggingPresets for help."));
        jButton.setToolTipText(I18n.tr("Add a new tagging preset source to the list."));
        jButton3.setToolTipText(I18n.tr("Delete the selected source from the list."));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), I18n.tr("Tagging Presets")));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        jPanel.add((Component)this.enableDefault, GBC.eol().insets(5, 5, 5, 0));
        jPanel.add((Component)new JLabel(I18n.tr("Tagging preset sources")), GBC.eol().insets(5, 5, 5, 0));
        jPanel.add((Component)new JScrollPane(this.taggingPresetSources), GBC.eol().insets(5, 0, 5, 0).fill(1));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, GBC.eol().insets(5, 0, 5, 5).fill(2));
        jPanel2.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel2.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)jButton2, GBC.std().insets(5, 5, 5, 0));
        jPanel2.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
        preferenceDialog.map.add((Component)jPanel, GBC.eol().fill(1));
    }

    public boolean ok() {
        Main.pref.put("taggingpreset.enable-defaults", this.enableDefault.getSelectedObjects() != null);
        boolean bl = Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null);
        int n = this.taggingPresetSources.getModel().getSize();
        if (n > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                arrayList.add((String)this.taggingPresetSources.getModel().getElementAt(i));
            }
            if (Main.pref.putCollection("taggingpreset.sources", arrayList)) {
                bl = true;
            }
        } else if (Main.pref.putCollection("taggingpreset.sources", null)) {
            bl = true;
        }
        return bl;
    }

    public static void initialize() {
        taggingPresets = TaggingPreset.readFromPreferences();
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            HashMap<TaggingPresetMenu, JMenuItem> hashMap = new HashMap<TaggingPresetMenu, JMenuItem>();
            for (TaggingPreset taggingPreset : taggingPresets) {
                JMenuItem jMenuItem;
                JMenu jMenu;
                JMenu jMenu2 = jMenu = taggingPreset.group != null ? (JMenu)hashMap.get(taggingPreset.group) : Main.main.menu.presetsMenu;
                if (taggingPreset instanceof TaggingPresetSeparator) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetMenu) {
                    jMenuItem = new JMenu(taggingPreset);
                    ((TaggingPresetMenu)taggingPreset).menu = jMenuItem;
                    hashMap.put((TaggingPresetMenu)taggingPreset, jMenuItem);
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem(taggingPreset);
                jMenuItem.setText(I18n.tr(taggingPreset.name));
                jMenu.add(jMenuItem);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }
}

