/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.download.BookmarkSelection;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.PlaceSelection;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.TileSelection;
import org.openstreetmap.josm.gui.download.WorldChooser;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class DownloadDialog
extends JPanel {
    private JOptionPane optionPane;
    public final List<DownloadTask> downloadTasks = new ArrayList<DownloadTask>(5);
    public final List<DownloadSelection> downloadSelections = new ArrayList<DownloadSelection>();
    public final JTabbedPane tabpane = new JTabbedPane();
    public final JCheckBox newLayer;
    public final JLabel sizeCheck = new JLabel();
    public double minlon;
    public double minlat;
    public double maxlon;
    public double maxlat;

    public DownloadDialog() {
        Object object;
        this.setLayout(new GridBagLayout());
        this.downloadTasks.add(new DownloadOsmTask());
        this.downloadTasks.add(new DownloadGpsTask());
        this.add((Component)new JLabel(I18n.tr("Data Sources and Types")), GBC.eol().insets(0, 5, 0, 0));
        for (DownloadTask object2 : this.downloadTasks) {
            this.add((Component)object2.getCheckBox(), GBC.eol().insets(20, 0, 0, 0));
            if (!Main.pref.hasKey("download." + object2.getPreferencesSuffix())) continue;
            object2.getCheckBox().setSelected(Main.pref.getBoolean("download." + object2.getPreferencesSuffix()));
        }
        this.downloadSelections.add(new SlippyMapChooser());
        this.downloadSelections.add(new BookmarkSelection());
        this.downloadSelections.add(new BoundingBoxSelection());
        this.downloadSelections.add(new PlaceSelection());
        this.downloadSelections.add(new TileSelection());
        this.downloadSelections.add(new WorldChooser());
        PluginHandler.addDownloadSelection(this.downloadSelections);
        for (DownloadSelection downloadSelection : this.downloadSelections) {
            downloadSelection.addGui(this);
        }
        if (Main.map != null) {
            object = Main.map.mapView;
            this.minlon = ((NavigatableComponent)object).getLatLon(0, ((JComponent)object).getHeight()).lon();
            this.minlat = ((NavigatableComponent)object).getLatLon(0, ((JComponent)object).getHeight()).lat();
            this.maxlon = ((NavigatableComponent)object).getLatLon(((JComponent)object).getWidth(), 0).lon();
            this.maxlat = ((NavigatableComponent)object).getLatLon(((JComponent)object).getWidth(), 0).lat();
            this.boundingBoxChanged(null);
        } else if (Main.pref.hasKey("osm-download.bounds")) {
            try {
                object = Main.pref.get("osm-download.bounds").split(";");
                this.minlat = Double.parseDouble(object[0]);
                this.minlon = Double.parseDouble(object[1]);
                this.maxlat = Double.parseDouble(object[2]);
                this.maxlon = Double.parseDouble(object[3]);
                this.boundingBoxChanged(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.newLayer = new JCheckBox(I18n.tr("Download as new layer"), Main.pref.getBoolean("download.newlayer", false));
        this.add((Component)this.newLayer, GBC.eol().insets(0, 5, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Download Area")), GBC.eol().insets(0, 5, 0, 0));
        this.add((Component)this.tabpane, GBC.eol().fill());
        try {
            this.tabpane.setSelectedIndex(Main.pref.getInteger("download.tab", 0));
        }
        catch (Exception exception) {
            Main.pref.putInteger("download.tab", 0);
        }
        object = this.sizeCheck.getFont();
        this.sizeCheck.setFont(((Font)object).deriveFont(0, ((Font)object).getSize()));
        this.add((Component)this.sizeCheck, GBC.eop().insets(0, 5, 5, 10));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(86, 2), "checkClipboardContents");
        this.getActionMap().put("checkClipboardContents", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadDialog.this.checkClipboardContents();
            }
        });
    }

    private void checkClipboardContents() {
        String string = "";
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return;
        }
        Bounds bounds = OsmUrlToBounds.parse(string);
        if (bounds != null) {
            this.minlon = bounds.min.lon();
            this.minlat = bounds.min.lat();
            this.maxlon = bounds.max.lon();
            this.maxlat = bounds.max.lat();
            this.boundingBoxChanged(null);
        }
    }

    private void updateSizeCheck() {
        if ((this.maxlon - this.minlon) * (this.maxlat - this.minlat) > Main.pref.getDouble("osm-server.max-request-area", 0.25)) {
            this.sizeCheck.setText(I18n.tr("Download area too large; will probably be rejected by server"));
            this.sizeCheck.setForeground(Color.red);
        } else {
            this.sizeCheck.setText(I18n.tr("Download area ok, size probably acceptable to server"));
            this.sizeCheck.setForeground(Color.darkGray);
        }
    }

    public void boundingBoxChanged(DownloadSelection downloadSelection) {
        for (DownloadSelection downloadSelection2 : this.downloadSelections) {
            if (downloadSelection2 == downloadSelection) continue;
            downloadSelection2.boundingBoxChanged(this);
        }
        this.updateSizeCheck();
    }

    public int getSelectedTab() {
        return this.tabpane.getSelectedIndex();
    }

    public void closeDownloadDialog(boolean bl) {
        this.optionPane.setValue(bl ? 0 : 2);
    }

    public void setOptionPane(JOptionPane jOptionPane) {
        this.optionPane = jOptionPane;
    }

    public static interface DownloadTask {
        public void download(DownloadAction var1, double var2, double var4, double var6, double var8);

        public void loadUrl(boolean var1, String var2);

        public JCheckBox getCheckBox();

        public String getPreferencesSuffix();
    }
}

