/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.AutoCompleteComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener {
    private NameVisitor nameVisitor = new NameVisitor();
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private String objKey;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final DefaultTableModel membershipData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    public JComboBox taggingPresets = new JComboBox();
    private final SideButton btnAdd;
    private final SideButton btnEdit;
    private final SideButton btnDel;
    private final JMultilineLabel presets = new JMultilineLabel("");
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Please select the objects you want to change properties for.") + "</p></html>");

    void propertyEdit(int n) {
        String string;
        String string2;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (collection.isEmpty()) {
            return;
        }
        this.objKey = string2 = this.propertyData.getValueAt(n, 0).toString();
        String string3 = "<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>(" + I18n.tr("An empty value deletes the key.", string2) + ")</html>";
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string3), "North");
        TreeMap<String, TreeSet<String>> treeMap = this.createAutoCompletionInfo(true);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        AutoCompleteComboBox autoCompleteComboBox = new AutoCompleteComboBox();
        autoCompleteComboBox.setPossibleItems(treeMap.keySet());
        autoCompleteComboBox.setEditable(true);
        autoCompleteComboBox.setSelectedItem(string2);
        jPanel2.add((Component)new JLabel(I18n.tr("Key")), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompleteComboBox, GBC.eol().fill(2));
        final AutoCompleteComboBox autoCompleteComboBox2 = new AutoCompleteComboBox();
        autoCompleteComboBox2.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    Map map;
                    String string = null;
                    string = (String)object;
                    if (PropertiesDialog.this.valueCount.containsKey(PropertiesDialog.this.objKey) && (map = (Map)PropertiesDialog.this.valueCount.get(PropertiesDialog.this.objKey)).containsKey(string)) {
                        string = string + "(" + map.get(string) + ")";
                        component.setFont(component.getFont().deriveFont(3));
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        autoCompleteComboBox2.setEditable(true);
        this.updateListData(string2, treeMap, autoCompleteComboBox2);
        Map map = (Map)this.propertyData.getValueAt(n, 1);
        String string4 = map.size() != 1 ? I18n.tr("<different>") : (String)map.entrySet().iterator().next().getKey();
        autoCompleteComboBox2.setSelectedItem(string4);
        autoCompleteComboBox2.getEditor().setItem(string4);
        jPanel2.add((Component)new JLabel(I18n.tr("Value")), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompleteComboBox2, GBC.eol().fill(2));
        this.addFocusAdapter(n, treeMap, autoCompleteComboBox, autoCompleteComboBox2);
        final JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2){

            public void selectInitialValue() {
                autoCompleteComboBox2.requestFocusInWindow();
                autoCompleteComboBox2.getEditor().selectAll();
            }
        };
        final JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        autoCompleteComboBox2.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jOptionPane.setValue(0);
            }
        });
        String string5 = autoCompleteComboBox2.getEditor().getItem().toString();
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == null || object == JOptionPane.UNINITIALIZED_VALUE || object instanceof Integer && (Integer)object != 0) {
            autoCompleteComboBox2.getEditor().setItem(string5);
            return;
        }
        String string6 = autoCompleteComboBox2.getEditor().getItem().toString().trim();
        if (string6.equals("")) {
            string6 = null;
        }
        if ((string = autoCompleteComboBox.getEditor().getItem().toString().trim()).equals("")) {
            string = string2;
            string6 = null;
        }
        if (string.equals("created_by")) {
            return;
        }
        if (string2.equals(string) || string6 == null) {
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string6));
        } else {
            Vector<Command> vector = new Vector<Command>();
            vector.add(new ChangePropertyCommand(collection, string2, null));
            if (string6.equals(I18n.tr("<different>"))) {
                HashMap hashMap = new HashMap();
                for (OsmPrimitive object2 : collection) {
                    String string7;
                    if (object2.keys == null || (string7 = object2.keys.get(string2)) == null) continue;
                    if (hashMap.containsKey(string7)) {
                        ((Vector)hashMap.get(string7)).add(object2);
                        continue;
                    }
                    Vector<OsmPrimitive> vector2 = new Vector<OsmPrimitive>();
                    vector2.add(object2);
                    hashMap.put(string7, vector2);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    vector.add(new ChangePropertyCommand((Collection)entry.getValue(), string, (String)entry.getKey()));
                }
            } else {
                vector.add(new ChangePropertyCommand(collection, string, string6));
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", collection.size(), collection.size()), vector));
        }
        DataSet.fireSelectionChanged(collection);
        this.selectionChanged(collection);
        Main.parent.repaint();
        if (!string2.equals(string)) {
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                if (this.propertyData.getValueAt(i, 0).toString() != string) continue;
                n = i;
                break;
            }
        }
        this.propertyTable.changeSelection(n, 0, false, false);
    }

    private void updateListData(String string, TreeMap<String, TreeSet<String>> treeMap, AutoCompleteComboBox autoCompleteComboBox) {
        Collection<String> collection = treeMap.containsKey(string) ? (Collection)treeMap.get(string) : Collections.emptyList();
        autoCompleteComboBox.setPossibleItems(collection);
    }

    void membershipEdit(int n) {
        RelationEditor relationEditor = new RelationEditor((Relation)this.membershipData.getValueAt(n, 0), (Collection)this.membershipData.getValueAt(n, 1));
        relationEditor.setVisible(true);
    }

    void add() {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (collection.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>" + I18n.tr("Please select a key")), "North");
        TreeMap<String, TreeSet<String>> treeMap = this.createAutoCompletionInfo(false);
        final AutoCompleteComboBox autoCompleteComboBox = new AutoCompleteComboBox();
        autoCompleteComboBox.setPossibleItems(treeMap.keySet());
        autoCompleteComboBox.setEditable(true);
        jPanel.add((Component)autoCompleteComboBox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add((Component)new JLabel(I18n.tr("Please select a value")), "North");
        AutoCompleteComboBox autoCompleteComboBox2 = new AutoCompleteComboBox();
        autoCompleteComboBox2.setEditable(true);
        jPanel2.add((Component)autoCompleteComboBox2, "Center");
        this.addFocusAdapter(-1, treeMap, autoCompleteComboBox, autoCompleteComboBox2);
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2){

            public void selectInitialValue() {
                autoCompleteComboBox.requestFocusInWindow();
                autoCompleteComboBox.getEditor().selectAll();
            }
        };
        jOptionPane.createDialog(Main.parent, I18n.tr("Change values?")).setVisible(true);
        if (!Integer.valueOf(0).equals(jOptionPane.getValue())) {
            return;
        }
        String string = autoCompleteComboBox.getEditor().getItem().toString().trim();
        String string2 = autoCompleteComboBox2.getEditor().getItem().toString().trim();
        if (string2.equals("")) {
            return;
        }
        if (string.equals("created_by")) {
            return;
        }
        Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string2));
        DataSet.fireSelectionChanged(collection);
        this.selectionChanged(collection);
        Main.parent.repaint();
    }

    private void addFocusAdapter(int n, final TreeMap<String, TreeSet<String>> treeMap, final AutoCompleteComboBox autoCompleteComboBox, final AutoCompleteComboBox autoCompleteComboBox2) {
        JTextComponent jTextComponent = (JTextComponent)autoCompleteComboBox2.getEditor().getEditorComponent();
        jTextComponent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                String string = autoCompleteComboBox.getEditor().getItem().toString();
                PropertiesDialog.this.updateListData(string, treeMap, autoCompleteComboBox2);
                PropertiesDialog.this.objKey = string;
            }
        });
    }

    private TreeMap<String, TreeSet<String>> createAutoCompletionInfo(boolean bl) {
        TreeMap<String, TreeSet<String>> treeMap = new TreeMap<String, TreeSet<String>>();
        for (OsmPrimitive osmPrimitive : Main.ds.allNonDeletedPrimitives()) {
            for (String string : osmPrimitive.keySet()) {
                TreeSet<Object> treeSet = null;
                if (treeMap.containsKey(string)) {
                    treeSet = treeMap.get(string);
                } else {
                    treeSet = new TreeSet();
                    treeMap.put(string, treeSet);
                }
                treeSet.add(osmPrimitive.get(string));
            }
        }
        if (!bl) {
            for (int i = 0; i < this.propertyData.getRowCount(); ++i) {
                treeMap.remove(this.propertyData.getValueAt(i, 0));
            }
        }
        return treeMap;
    }

    private void delete(int n) {
        String string = this.propertyData.getValueAt(n, 0).toString();
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, null));
        DataSet.fireSelectionChanged(collection);
        this.selectionChanged(collection);
        int n2 = this.propertyTable.getRowCount();
        this.propertyTable.changeSelection(n < n2 ? n : n2 - 1, 0, false, false);
    }

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships"), "propertiesdialog", I18n.tr("Properties for selected objects."), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships")), 80, 4, 1), 150);
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key"), I18n.tr("Value")});
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (component instanceof JLabel) {
                    String string = null;
                    switch (n2) {
                        case 0: {
                            string = (String)object;
                            break;
                        }
                        case 1: {
                            Map map = (Map)object;
                            if (map.size() != 1) {
                                string = I18n.tr("<different>");
                                component.setFont(component.getFont().deriveFont(2));
                                break;
                            }
                            string = (String)map.entrySet().iterator().next().getKey();
                        }
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of"), I18n.tr("Role")});
        this.membershipTable.setSelectionMode(0);
        this.membershipTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (component instanceof JLabel) {
                    PropertiesDialog.this.nameVisitor.visit((Relation)object);
                    ((JLabel)component).setText(((PropertiesDialog)PropertiesDialog.this).nameVisitor.name);
                }
                return component;
            }
        });
        this.membershipTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (component instanceof JLabel) {
                    Collection collection = (Collection)object;
                    String string = null;
                    for (RelationMember relationMember : collection) {
                        if (string == null) {
                            string = relationMember.role;
                            continue;
                        }
                        if (string.equals(relationMember.role)) continue;
                        string = I18n.tr("<different>");
                        break;
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        jPanel.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.membershipTable, GBC.eol().fill(1));
        jPanel.add((Component)this.presets, GBC.eol().fill().insets(5, 2, 5, 2));
        DblClickWatch dblClickWatch = new DblClickWatch();
        this.propertyTable.addMouseListener(dblClickWatch);
        this.membershipTable.addMouseListener(dblClickWatch);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.addMouseListener(dblClickWatch);
        this.add((Component)jScrollPane, "Center");
        this.selectSth.setPreferredSize(jScrollPane.getSize());
        this.presets.setPreferredSize(jScrollPane.getSize());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                if (actionEvent.getActionCommand().equals("Add")) {
                    PropertiesDialog.this.add();
                } else if (n >= 0) {
                    if (actionEvent.getActionCommand().equals("Edit")) {
                        PropertiesDialog.this.membershipEdit(n);
                    } else if (actionEvent.getActionCommand().equals("Delete")) {
                        Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
                        NameVisitor nameVisitor = new NameVisitor();
                        relation.visit(nameVisitor);
                        int n2 = new ExtendedDialog(Main.parent, I18n.tr("Change relation"), I18n.tr("Really delete selection from relation {0}?", nameVisitor.name), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")}, new String[]{"dialogs/delete.png", "cancel.png"}).getValue();
                        if (n2 == 1) {
                            Relation relation2 = new Relation(relation);
                            Collection<OsmPrimitive> collection = Main.ds.getSelected();
                            block0: for (RelationMember relationMember : relation.members) {
                                for (OsmPrimitive osmPrimitive : collection) {
                                    if (relationMember.member != osmPrimitive) continue;
                                    RelationMember relationMember2 = new RelationMember();
                                    relationMember2.role = relationMember.role;
                                    relationMember2.member = relationMember.member;
                                    relation2.members.remove(relationMember2);
                                    continue block0;
                                }
                            }
                            Main.main.undoRedo.add(new ChangeCommand(relation, relation2));
                            DataSet.fireSelectionChanged(collection);
                            PropertiesDialog.this.selectionChanged(collection);
                        }
                    }
                } else {
                    int n3 = PropertiesDialog.this.propertyTable.getSelectedRow();
                    if (actionEvent.getActionCommand().equals("Edit")) {
                        PropertiesDialog.this.propertyEdit(n3 >= 0 ? n3 : 0);
                    } else if (actionEvent.getActionCommand().equals("Delete")) {
                        PropertiesDialog.this.delete(n3 >= 0 ? n3 : 0);
                    }
                }
            }
        };
        Shortcut shortcut = Shortcut.registerShortcut("properties:add", I18n.tr("Add Properties"), 66, 6);
        this.btnAdd = new SideButton(I18n.marktr("Add"), "add", "Properties", I18n.tr("Add a new key/value pair to all objects"), shortcut, actionListener);
        jPanel2.add(this.btnAdd);
        shortcut = Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Properties"), 73, 6);
        this.btnEdit = new SideButton(I18n.marktr("Edit"), "edit", "Properties", I18n.tr("Edit the value of the selected key for all objects"), shortcut, actionListener);
        jPanel2.add(this.btnEdit);
        shortcut = Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties"), 81, 6);
        this.btnDel = new SideButton(I18n.marktr("Delete"), "delete", "Properties", I18n.tr("Delete the selected key in all objects"), shortcut, actionListener);
        jPanel2.add(this.btnDel);
        this.add((Component)jPanel2, "South");
        DataSet.selListeners.add(this);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.selectionChanged(Main.ds.getSelected());
        }
    }

    private void checkPresets(int n, int n2, int n3, int n4) {
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        int n5 = n + n2 + n3 + n4;
        if (n5 != 0) {
            for (TaggingPreset object : TaggingPresetPreference.taggingPresets) {
                if (object.types != null && n3 > 0 && !object.types.contains("relation") && n > 0 && !object.types.contains("node") && n2 + n4 > 0 && !object.types.contains("way") && n4 > 0 && !object.types.contains("closedway")) continue;
                int n6 = 0;
                for (TaggingPreset.Item item : object.data) {
                    Map<String, Integer> map;
                    if (!(item instanceof TaggingPreset.Key)) continue;
                    String string = ((TaggingPreset.Key)item).value;
                    String string2 = ((TaggingPreset.Key)item).key;
                    n6 -= 100;
                    if (!this.valueCount.containsKey(string2) || (map = this.valueCount.get(string2)).size() != 1 || !map.containsKey(string) || map.get(string) != n5) continue;
                    n6 += 101;
                }
                if (n6 <= 0) continue;
                linkedList.add(object);
            }
        }
        Object object = "";
        for (TaggingPreset taggingPreset : linkedList) {
            if (((String)object).length() > 0) {
                object = (String)object + "\n";
            }
            object = (String)object + taggingPreset.getName();
        }
        this.presets.setText((String)object);
        this.presets.setVisible(((String)object).length() > 0);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        this.propertyData.setRowCount(0);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.valueCount.clear();
        for (OsmPrimitive object : collection) {
            if (object instanceof Node) {
                ++n;
            } else if (object instanceof Relation) {
                ++n3;
            } else if (((Way)object).isClosed().booleanValue()) {
                ++n4;
            } else {
                ++n2;
            }
            for (Map.Entry<String, String> entry : object.entrySet()) {
                hashMap.put(entry.getKey(), hashMap.containsKey(entry.getKey()) ? (Integer)hashMap.get(entry.getKey()) + 1 : 1);
                if (this.valueCount.containsKey(entry.getKey())) {
                    Map<String, Integer> map = this.valueCount.get(entry.getKey());
                    map.put(entry.getValue(), map.containsKey(entry.getValue()) ? map.get(entry.getValue()) + 1 : 1);
                    continue;
                }
                TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                treeMap.put(entry.getValue(), 1);
                this.valueCount.put(entry.getKey(), treeMap);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            int n5 = 0;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                n5 += ((Integer)entry2.getValue()).intValue();
            }
            if (n5 < collection.size()) {
                ((Map)entry.getValue()).put("", collection.size() - n5);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        boolean bl = !collection.isEmpty() && this.propertyData.getRowCount() > 0;
        boolean bl2 = !collection.isEmpty();
        this.btnAdd.setEnabled(bl2);
        this.btnEdit.setEnabled(bl);
        this.btnDel.setEnabled(bl);
        this.propertyTable.setVisible(bl2);
        this.propertyTable.getTableHeader().setVisible(bl2);
        this.selectSth.setVisible(!bl2);
        if (bl) {
            this.propertyTable.changeSelection(0, 0, false, false);
        }
        this.checkPresets(n, n2, n3, n4);
        this.membershipData.setRowCount(0);
        HashMap<Relation, HashSet<RelationMember>> hashMap2 = new HashMap<Relation, HashSet<RelationMember>>();
        for (Relation relation : Main.ds.relations) {
            if (relation.deleted || relation.incomplete) continue;
            for (RelationMember relationMember : relation.members) {
                if (!collection.contains(relationMember.member)) continue;
                HashSet<RelationMember> hashSet = (HashSet<RelationMember>)hashMap2.get(relation);
                if (hashSet == null) {
                    hashSet = new HashSet<RelationMember>();
                    hashMap2.put(relation, hashSet);
                }
                hashSet.add(relationMember);
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.membershipData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()), true);
        } else {
            this.setTitle(I18n.tr("Properties / Memberships"), false);
        }
    }

    public class DblClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.propertyEdit(n);
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.membershipEdit(n);
                }
            } else {
                PropertiesDialog.this.add();
            }
        }
    }
}

