/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryDialog
extends ToggleDialog
implements SelectionChangedListener {
    private final DefaultTableModel data = new DefaultTableModel(){

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    private JTable history = new JTable(this.data);
    private JScrollPane historyPane = new JScrollPane(this.history);
    private Map<OsmPrimitive, List<HistoryItem>> cache = new HashMap<OsmPrimitive, List<HistoryItem>>();
    private JLabel notLoaded = new JLabel("<html><i>" + I18n.tr("Click Reload to refresh list") + "</i></html>");

    public static final Date unifyDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public HistoryDialog() {
        super(I18n.tr("History"), "history", I18n.tr("Display the history of all selected items."), Shortcut.registerShortcut("subwindow:history", I18n.tr("Toggle: {0}", I18n.tr("History")), 72, 4, 1), 150);
        this.historyPane.setVisible(false);
        this.notLoaded.setVisible(true);
        this.notLoaded.setHorizontalAlignment(0);
        this.history.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.data.setColumnIdentifiers(new Object[]{I18n.tr("Object"), I18n.tr("Date"), ""});
        this.history.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.history.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.history.getColumnModel().getColumn(2).setPreferredWidth(20);
        final TableCellRenderer tableCellRenderer = this.history.getTableHeader().getDefaultRenderer();
        this.history.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!object.equals("")) {
                    return jComponent;
                }
                JLabel jLabel = new JLabel(ImageProvider.get("misc", "showhide"));
                jLabel.setForeground(jComponent.getForeground());
                jLabel.setBackground(jComponent.getBackground());
                jLabel.setFont(jComponent.getFont());
                jLabel.setBorder(jComponent.getBorder());
                jLabel.setOpaque(true);
                return jLabel;
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.notLoaded, GBC.eol().fill(1));
        jPanel.add((Component)this.historyPane, GBC.eol().fill(1));
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(new SideButton(I18n.marktr("Reload"), "refresh", "History", I18n.tr("Reload all currently selected objects and refresh the list."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistoryDialog.this.reload();
            }
        }));
        jPanel2.add(new SideButton(I18n.marktr("Revert"), "revert", "History", I18n.tr("Revert the state of all currently selected objects to the version selected in the history list."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Not implemented yet."));
            }
        }));
        this.add((Component)jPanel2, "South");
        DataSet.selListeners.add(this);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (this.isVisible()) {
            this.update();
        }
    }

    private void update() {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (!this.cache.keySet().containsAll(collection)) {
            this.historyPane.setVisible(false);
            this.notLoaded.setVisible(true);
        } else {
            TreeSet treeSet = new TreeSet();
            for (Comparable<OsmPrimitive> comparable : collection) {
                treeSet.addAll(this.cache.get(comparable));
            }
            this.data.setRowCount(0);
            for (Comparable<OsmPrimitive> comparable : treeSet) {
                this.data.addRow(new Object[]{((HistoryItem)comparable).osm, ((HistoryItem)comparable).osm.timestamp, ((HistoryItem)comparable).visible});
            }
            this.historyPane.setVisible(true);
            this.notLoaded.setVisible(false);
        }
    }

    void reload() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Not implemented yet."));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoryItem
    implements Comparable<HistoryItem> {
        OsmPrimitive osm;
        boolean visible;

        private HistoryItem() {
        }

        @Override
        public int compareTo(HistoryItem historyItem) {
            return HistoryDialog.unifyDate(this.osm.getTimestamp()).compareTo(HistoryDialog.unifyDate(historyItem.osm.getTimestamp()));
        }
    }
}

