/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.actions.AddNodeAction;
import org.openstreetmap.josm.actions.AlignInCircleAction;
import org.openstreetmap.josm.actions.AlignInLineAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.CopyAction;
import org.openstreetmap.josm.actions.CreateCircleAction;
import org.openstreetmap.josm.actions.DeleteAction;
import org.openstreetmap.josm.actions.DistributeAction;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.actions.DuplicateAction;
import org.openstreetmap.josm.actions.ExitAction;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.actions.HistoryInfoAction;
import org.openstreetmap.josm.actions.JoinNodeWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.NewAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.actions.OrthogonalizeAction;
import org.openstreetmap.josm.actions.PasteAction;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.actions.RedoAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.actions.SelectAllAction;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.actions.ToggleGPXLinesAction;
import org.openstreetmap.josm.actions.UnGlueAction;
import org.openstreetmap.josm.actions.UndoAction;
import org.openstreetmap.josm.actions.UnselectAllAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.ZoomInAction;
import org.openstreetmap.josm.actions.ZoomOutAction;
import org.openstreetmap.josm.actions.audio.AudioBackAction;
import org.openstreetmap.josm.actions.audio.AudioFasterAction;
import org.openstreetmap.josm.actions.audio.AudioFwdAction;
import org.openstreetmap.josm.actions.audio.AudioNextAction;
import org.openstreetmap.josm.actions.audio.AudioPlayPauseAction;
import org.openstreetmap.josm.actions.audio.AudioPrevAction;
import org.openstreetmap.josm.actions.audio.AudioSlowerAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MainMenu
extends JMenuBar {
    public final NewAction newAction = new NewAction();
    public final OpenFileAction openFile = new OpenFileAction();
    public final OpenLocationAction openLocation = new OpenLocationAction();
    public final JosmAction save = new SaveAction(null);
    public final JosmAction saveAs = new SaveAsAction(null);
    public final JosmAction gpxExport = new GpxExportAction(null);
    public final DownloadAction download = new DownloadAction();
    public final JosmAction update = new UpdateDataAction();
    public final JosmAction upload = new UploadAction();
    public final JosmAction exit = new ExitAction();
    public final UndoAction undo = new UndoAction();
    public final RedoAction redo = new RedoAction();
    public final JosmAction copy = new CopyAction();
    public final JosmAction paste = new PasteAction();
    public final JosmAction pasteTags = new PasteTagsAction(this.copy);
    public final JosmAction duplicate = new DuplicateAction();
    public final JosmAction delete = new DeleteAction();
    public final JosmAction selectAll = new SelectAllAction();
    public final JosmAction unselectAll = new UnselectAllAction();
    public final JosmAction search = new SearchAction();
    public final JosmAction preferences = new PreferencesAction();
    public final JosmAction toggleGPXLines = new ToggleGPXLinesAction();
    public final JosmAction splitWay = new SplitWayAction();
    public final JosmAction combineWay = new CombineWayAction();
    public final JosmAction reverseWay = new ReverseWayAction();
    public final JosmAction alignInCircle = new AlignInCircleAction();
    public final JosmAction alignInLine = new AlignInLineAction();
    public final JosmAction distribute = new DistributeAction();
    public final JosmAction ortho = new OrthogonalizeAction();
    public final AddNodeAction addnode = new AddNodeAction();
    public final JosmAction createCircle = new CreateCircleAction();
    public final JosmAction mergeNodes = new MergeNodesAction();
    public final JosmAction joinNodeWay = new JoinNodeWayAction();
    public final JosmAction unglueNodes = new UnGlueAction();
    public final HistoryInfoAction historyinfo = new HistoryInfoAction();
    public final JosmAction audioPlayPause = new AudioPlayPauseAction();
    public final JosmAction audioNext = new AudioNextAction();
    public final JosmAction audioPrev = new AudioPrevAction();
    public final JosmAction audioFwd = new AudioFwdAction();
    public final JosmAction audioBack = new AudioBackAction();
    public final JosmAction audioFaster = new AudioFasterAction();
    public final JosmAction audioSlower = new AudioSlowerAction();
    public final HelpAction help = new HelpAction();
    public final JosmAction about = new AboutAction();
    public final JosmAction statusreport = new ShowStatusReportAction();
    public final JMenu fileMenu = new JMenu(I18n.tr("File"));
    public final JMenu editMenu = new JMenu(I18n.tr("Edit"));
    public final JMenu viewMenu = new JMenu(I18n.tr("View"));
    public final JMenu toolsMenu = new JMenu(I18n.tr("Tools"));
    public final JMenu audioMenu = new JMenu(I18n.tr("Audio"));
    public final JMenu presetsMenu = new JMenu(I18n.tr("Presets"));
    public final JMenu helpMenu = new JMenu(I18n.tr("Help"));

    public static JMenuItem add(JMenu jMenu, JosmAction josmAction) {
        JMenuItem jMenuItem = null;
        if (!josmAction.getShortcut().getAutomatic()) {
            jMenuItem = jMenu.add(josmAction);
            KeyStroke keyStroke = josmAction.getShortcut().getKeyStroke();
            if (keyStroke != null) {
                jMenuItem.setAccelerator(keyStroke);
            }
        }
        return jMenuItem;
    }

    public void add(JMenu jMenu, int n, String string) {
        Shortcut.registerShortcut("menu:" + string, I18n.tr("Menu: {0}", jMenu.getText()), n, 6).setMnemonic(jMenu);
        this.add(jMenu);
    }

    public MainMenu() {
        MainMenu.add(this.fileMenu, this.newAction);
        MainMenu.add(this.fileMenu, this.openFile);
        MainMenu.add(this.fileMenu, this.openLocation);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.save);
        MainMenu.add(this.fileMenu, this.saveAs);
        MainMenu.add(this.fileMenu, this.gpxExport);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.download);
        MainMenu.add(this.fileMenu, this.upload);
        MainMenu.add(this.fileMenu, this.update);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.exit);
        this.add(this.fileMenu, 70, "file");
        MainMenu.add(this.editMenu, this.undo);
        MainMenu.add(this.editMenu, this.redo);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.copy);
        MainMenu.add(this.editMenu, this.paste);
        MainMenu.add(this.editMenu, this.pasteTags);
        MainMenu.add(this.editMenu, this.duplicate);
        MainMenu.add(this.editMenu, this.delete);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.selectAll);
        MainMenu.add(this.editMenu, this.unselectAll);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.search);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.preferences);
        this.add(this.editMenu, 69, "edit");
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18n.tr("Wireframe View"));
        jCheckBoxMenuItem.setSelected(Main.pref.getBoolean("draw.wireframe", false));
        jCheckBoxMenuItem.setAccelerator(Shortcut.registerShortcut("menu:view:wireframe", I18n.tr("Toggle Wireframe view"), 87, 2).getKeyStroke());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.pref.put("draw.wireframe", jCheckBoxMenuItem.isSelected());
                if (Main.map != null) {
                    Main.map.mapView.repaint();
                }
            }
        });
        this.viewMenu.add(jCheckBoxMenuItem);
        this.viewMenu.addSeparator();
        MainMenu.add(this.viewMenu, new ZoomInAction());
        MainMenu.add(this.viewMenu, new ZoomOutAction());
        this.viewMenu.addSeparator();
        for (String string : AutoScaleAction.modes) {
            AutoScaleAction autoScaleAction = new AutoScaleAction(string);
            MainMenu.add(this.viewMenu, autoScaleAction);
        }
        this.add(this.viewMenu, 86, "view");
        MainMenu.add(this.toolsMenu, this.splitWay);
        MainMenu.add(this.toolsMenu, this.combineWay);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.reverseWay);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.alignInCircle);
        MainMenu.add(this.toolsMenu, this.alignInLine);
        MainMenu.add(this.toolsMenu, this.distribute);
        MainMenu.add(this.toolsMenu, this.ortho);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.addnode);
        MainMenu.add(this.toolsMenu, this.createCircle);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.mergeNodes);
        MainMenu.add(this.toolsMenu, this.joinNodeWay);
        MainMenu.add(this.toolsMenu, this.unglueNodes);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.historyinfo);
        this.add(this.toolsMenu, 84, "tools");
        this.add(this.presetsMenu, 80, "presets");
        if (!Main.pref.getBoolean("audio.menuinvisible", false)) {
            MainMenu.add(this.audioMenu, this.audioPlayPause);
            MainMenu.add(this.audioMenu, this.audioNext);
            MainMenu.add(this.audioMenu, this.audioPrev);
            MainMenu.add(this.audioMenu, this.audioFwd);
            MainMenu.add(this.audioMenu, this.audioBack);
            MainMenu.add(this.audioMenu, this.audioSlower);
            MainMenu.add(this.audioMenu, this.audioFaster);
            this.add(this.audioMenu, 65, "audio");
        }
        this.helpMenu.add(this.statusreport);
        JMenuItem jMenuItem = this.helpMenu.add(this.help);
        jMenuItem.setAccelerator(Shortcut.registerShortcut("system:help", I18n.tr("Help"), 112, 5).getKeyStroke());
        MainMenu.add(this.helpMenu, this.about);
        this.add(this.helpMenu, 72, "help");
    }
}

