/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.data.conflict.ConflictItem;
import org.openstreetmap.josm.data.conflict.DeleteConflict;
import org.openstreetmap.josm.data.conflict.PositionConflict;
import org.openstreetmap.josm.data.conflict.PropertyConflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolver
extends JPanel {
    public final List<ConflictItem> conflicts = new ArrayList<ConflictItem>();
    private final ConflictTableModel my = new ConflictTableModel(Resolution.MY);
    private final JTable myTable;
    private final ConflictTableModel their = new ConflictTableModel(Resolution.THEIR);
    private final JTable theirTable;
    private final ConflictTableModel resolve = new ConflictTableModel(null);
    private final JTable resolveTable;

    public ConflictResolver(Map<OsmPrimitive, OsmPrimitive> map) {
        super(new GridBagLayout());
        Object object;
        ArrayList<ConflictItem> arrayList = new ArrayList<ConflictItem>();
        arrayList.add(new DeleteConflict());
        arrayList.add(new PositionConflict());
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<OsmPrimitive, OsmPrimitive> object22 : map.entrySet()) {
            treeSet.addAll(object22.getKey().keySet());
            treeSet.addAll(object22.getValue().keySet());
        }
        for (String string : treeSet) {
            arrayList.add(new PropertyConflict(string));
        }
        for (Map.Entry<OsmPrimitive, OsmPrimitive> entry : map.entrySet()) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ConflictItem conflictItem = (ConflictItem)object.next();
                if (!conflictItem.hasConflict(entry.getKey(), entry.getValue())) continue;
                conflictItem.initialize(map);
                this.conflicts.add(conflictItem);
                object.remove();
            }
        }
        this.myTable = new JTable(this.my);
        this.theirTable = new JTable(this.their);
        this.resolveTable = new JTable(this.resolve);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, 70));
        this.theirTable.setPreferredScrollableViewportSize(new Dimension(250, 70));
        this.resolveTable.setPreferredScrollableViewportSize(new Dimension(250, 70));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            final Font defFont = new JLabel().getFont();

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setIcon(null);
                jLabel.setFont(this.defFont);
                if (object instanceof JLabel) {
                    JLabel jLabel2 = (JLabel)object;
                    String string = jLabel2.getText();
                    jLabel.setText(string);
                    jLabel.setFont(jLabel2.getFont());
                    if (string.startsWith("<html>") && jLabel2.getFont().isBold()) {
                        jLabel.setText("<html><b>" + string.substring(6, string.length() - 12));
                    }
                } else {
                    String string = object.toString();
                    int n3 = string.indexOf(124);
                    if (n3 != -1) {
                        jLabel.setIcon(ImageProvider.get("data", string.substring(0, n3)));
                        jLabel.setText(string.substring(n3 + 1));
                    }
                }
                return jLabel;
            }
        };
        this.myTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
        this.theirTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
        this.resolveTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
        this.myTable.setSelectionMode(0);
        this.theirTable.setSelectionMode(0);
        this.resolveTable.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                    ConflictResolver.this.myTable.clearSelection();
                    ConflictResolver.this.theirTable.clearSelection();
                    ConflictResolver.this.resolveTable.clearSelection();
                } else {
                    int n = ((ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex();
                    ConflictResolver.this.myTable.scrollRectToVisible(ConflictResolver.this.myTable.getCellRect(n, 0, true));
                    ConflictResolver.this.myTable.getSelectionModel().setSelectionInterval(n, n);
                    ConflictResolver.this.theirTable.scrollRectToVisible(ConflictResolver.this.theirTable.getCellRect(n, 0, true));
                    ConflictResolver.this.theirTable.getSelectionModel().setSelectionInterval(n, n);
                    ConflictResolver.this.resolveTable.scrollRectToVisible(ConflictResolver.this.resolveTable.getCellRect(n, 0, true));
                    ConflictResolver.this.resolveTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.theirTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.resolveTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.addMouseListener(new DblClickListener(Resolution.MY));
        this.theirTable.addMouseListener(new DblClickListener(Resolution.THEIR));
        this.resolveTable.addMouseListener(new DblClickListener(null));
        this.add((Component)new JLabel(I18n.trn("{0} object has conflicts:", "{0} objects have conflicts:", map.size(), map.size())), GBC.eol().insets(0, 0, 0, 10));
        object = new JPanel(new GridBagLayout());
        ((Container)object).add((Component)new JLabel(I18n.tr("my version:")), GBC.eol());
        ((Container)object).add((Component)new JScrollPane(this.myTable), GBC.eol().fill(1));
        ((Container)object).add((Component)new JButton(new ResolveAction("down", Resolution.MY)), GBC.eol().anchor(10).insets(0, 5, 0, 0));
        this.add((Component)object, GBC.std().insets(0, 0, 5, 0));
        object = new JPanel(new GridBagLayout());
        ((Container)object).add((Component)new JLabel(I18n.tr("their version:")), GBC.eol());
        ((Container)object).add((Component)new JScrollPane(this.theirTable), GBC.eol().fill(1));
        ((Container)object).add((Component)new JButton(new ResolveAction("down", Resolution.THEIR)), GBC.eol().anchor(10).insets(0, 5, 0, 0));
        this.add((Component)object, GBC.eop().insets(5, 0, 0, 0));
        this.add((Component)new JButton(new ResolveAction("up", null)), GBC.eol().anchor(10));
        this.add((Component)new JLabel(I18n.tr("resolved version:")), GBC.eol().insets(0, 5, 0, 0));
        this.add((Component)new JScrollPane(this.resolveTable), GBC.eol().anchor(10).fill(1));
    }

    private final class ResolveAction
    extends AbstractAction {
        private final Resolution resolution;

        public ResolveAction(String string, Resolution resolution) {
            super(null, ImageProvider.get("dialogs", string));
            this.resolution = resolution;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ConflictResolver.this.myTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            ConflictResolver.this.conflicts.get((int)n).resolution = this.resolution;
            if (n == ConflictResolver.this.myTable.getRowCount() - 1) {
                ConflictResolver.this.myTable.clearSelection();
            } else {
                ConflictResolver.this.myTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
            ConflictResolver.this.repaint();
        }
    }

    private final class DblClickListener
    extends MouseAdapter {
        private final Resolution resolution;

        public DblClickListener(Resolution resolution) {
            this.resolution = resolution;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                int n = ((JTable)mouseEvent.getSource()).getSelectedRow();
                if (n == -1) {
                    return;
                }
                ConflictResolver.this.conflicts.get((int)n).resolution = this.resolution;
                ConflictResolver.this.repaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflictTableModel
    implements TableModel {
        private final Resolution resolution;

        public ConflictTableModel(Resolution resolution) {
            this.resolution = resolution;
        }

        @Override
        public int getRowCount() {
            return ConflictResolver.this.conflicts.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Resolution resolution;
            ConflictItem conflictItem = ConflictResolver.this.conflicts.get(n);
            if (n2 == 0) {
                return conflictItem.key();
            }
            Resolution resolution2 = resolution = this.resolution == null ? conflictItem.resolution : this.resolution;
            if (resolution == null) {
                return "<html><i>???</i></html>";
            }
            JLabel jLabel = new JLabel(resolution == Resolution.MY ? conflictItem.my : conflictItem.their);
            if (conflictItem.resolution == this.resolution && this.resolution != null) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            return jLabel;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? I18n.tr("Key") : I18n.tr("Value");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Object.class;
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resolution {
        MY,
        THEIR;

    }
}

