/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.RoleCorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrectionTable;
import org.openstreetmap.josm.corrector.TagCorrectionTableModel;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagCorrector<P extends OsmPrimitive> {
    private String[] applicationOptions = new String[]{I18n.tr("Apply selected changes"), I18n.tr("Don't apply changes"), I18n.tr("Cancel")};

    public abstract Collection<Command> execute(P var1) throws UserCancelException;

    protected Collection<Command> applyCorrections(Map<OsmPrimitive, List<TagCorrection>> map, Map<OsmPrimitive, List<RoleCorrection>> map2, String string) throws UserCancelException {
        boolean bl = false;
        for (List<TagCorrection> list3 : map.values()) {
            if (list3.isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (List list : map2.values()) {
                if (list.isEmpty()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            JScrollPane jScrollPane;
            Object object;
            Object object2;
            List<RoleCorrection> list;
            ArrayList arrayList = new ArrayList();
            HashMap<OsmPrimitive, Serializable> hashMap = new HashMap<OsmPrimitive, Serializable>();
            HashMap<OsmPrimitive, Object> hashMap2 = new HashMap<OsmPrimitive, Object>();
            NameVisitor nameVisitor = new NameVisitor();
            JPanel jPanel = new JPanel(new GridBagLayout());
            JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
            jMultilineLabel.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel, GBC.eop().anchor(10));
            JMultilineLabel jMultilineLabel2 = new JMultilineLabel(I18n.tr("Please select which property changes you want to apply."));
            jMultilineLabel2.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel2, GBC.eop().anchor(10));
            for (OsmPrimitive osmPrimitive : map.keySet()) {
                List<TagCorrection> list2 = map.get(osmPrimitive);
                if (list2.isEmpty()) continue;
                osmPrimitive.visit(nameVisitor);
                list = new JLabel(I18n.tr("Properties of "));
                jPanel.add((Component)((Object)list), GBC.std());
                object2 = new JLabel(nameVisitor.name + ":", nameVisitor.icon, 2);
                jPanel.add((Component)object2, GBC.eol());
                object = new TagCorrectionTable(list2);
                jScrollPane = new JScrollPane((Component)object);
                jPanel.add((Component)jScrollPane, GBC.eop().fill(2));
                hashMap.put(osmPrimitive, (Serializable)object);
            }
            for (OsmPrimitive osmPrimitive : map2.keySet()) {
                List<RoleCorrection> list3 = map2.get(osmPrimitive);
                if (list3.isEmpty()) continue;
                osmPrimitive.visit(nameVisitor);
                list = new JLabel(I18n.tr("Roles in relations referring to"));
                jPanel.add((Component)((Object)list), GBC.std());
                object2 = new JLabel(nameVisitor.name + ":", nameVisitor.icon, 2);
                jPanel.add((Component)object2, GBC.eol());
                object = new RoleCorrectionTable(list3);
                jScrollPane = new JScrollPane((Component)object);
                jPanel.add((Component)jScrollPane, GBC.eop().fill(2));
                hashMap2.put(osmPrimitive, object);
            }
            int n = JOptionPane.showOptionDialog(Main.parent, jPanel, I18n.tr("Automatic tag correction"), 1, -1, null, this.applicationOptions, this.applicationOptions[0]);
            if (n == 0) {
                for (OsmPrimitive osmPrimitive : map.keySet()) {
                    list = map.get(osmPrimitive);
                    object2 = null;
                    if (osmPrimitive instanceof Way) {
                        object2 = new Way((Way)osmPrimitive);
                    } else if (osmPrimitive instanceof Node) {
                        object2 = new Node((Node)osmPrimitive);
                    } else if (osmPrimitive instanceof Relation) {
                        object2 = new Relation((Relation)osmPrimitive);
                    }
                    object = new HashSet();
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((TagCorrectionTableModel)((TagCorrectionTable)hashMap.get(osmPrimitive)).getCorrectionTableModel()).getApply(i)) continue;
                        TagCorrection tagCorrection = (TagCorrection)((Object)list.get(i));
                        if (tagCorrection.isKeyChanged() && !object.contains(tagCorrection.oldKey)) {
                            ((OsmPrimitive)object2).remove(tagCorrection.oldKey);
                        }
                        ((OsmPrimitive)object2).put(tagCorrection.newKey, tagCorrection.newValue);
                        object.add(tagCorrection.newKey);
                    }
                    if (object.isEmpty()) continue;
                    arrayList.add(new ChangeCommand(osmPrimitive, (OsmPrimitive)object2));
                }
                for (OsmPrimitive osmPrimitive : map2.keySet()) {
                    list = map2.get(osmPrimitive);
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((RoleCorrectionTableModel)((RoleCorrectionTable)hashMap2.get(osmPrimitive)).getCorrectionTableModel()).getApply(i)) continue;
                        object = list.get(i);
                        Relation relation = new Relation(((RoleCorrection)object).relation);
                        for (RelationMember relationMember : relation.members) {
                            if (!relationMember.equals(((RoleCorrection)object).member)) continue;
                            relationMember.role = ((RoleCorrection)object).newRole;
                        }
                        arrayList.add(new ChangeCommand(((RoleCorrection)object).relation, relation));
                    }
                }
            } else if (n != 1) {
                throw new UserCancelException();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

