/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class MapMode
extends JosmAction
implements MouseListener,
MouseMotionListener {
    private final Cursor cursor;
    private Cursor oldCursor;

    public MapMode(String string, String string2, String string3, Shortcut shortcut, MapFrame mapFrame, Cursor cursor) {
        super(string, "mapmode/" + string2, string3, shortcut, false);
        this.cursor = cursor;
        this.putValue("active", false);
    }

    public MapMode(String string, String string2, String string3, MapFrame mapFrame, Cursor cursor) {
        this.putValue("Name", string);
        this.putValue("SmallIcon", ImageProvider.get("mapmode", string2));
        this.putValue("ShortDescription", string3);
        this.cursor = cursor;
    }

    public void enterMode() {
        this.putValue("active", true);
        this.oldCursor = Main.map.mapView.getCursor();
        Main.map.mapView.setCursor(this.cursor);
        this.updateStatusLine();
    }

    public void exitMode() {
        this.putValue("active", false);
        Main.map.mapView.setCursor(this.oldCursor);
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.getModeHelpText());
        Main.map.statusLine.repaint();
    }

    public String getModeHelpText() {
        return "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.map != null) {
            Main.map.selectMapMode(this);
        }
    }

    public boolean layerIsSupported(Layer layer) {
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

