/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpAction
extends AbstractAction {
    private String languageCode = Main.getLanguageCodeU();
    private JFrame helpBrowser = new JFrame(I18n.tr("JOSM Online Help"));
    private String baseurl = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
    private JEditorPane help = new JEditorPane();
    private WikiReader reader = new WikiReader(this.baseurl);
    private String url;

    public HelpAction() {
        super(I18n.tr("Help"), ImageProvider.get("help"));
        this.help.setEditable(false);
        this.help.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (hyperlinkEvent.getURL() == null) {
                    HelpAction.this.help.setText("<html>404 not found</html>");
                } else if (hyperlinkEvent.getURL().toString().startsWith("http://josm-extern.")) {
                    OpenBrowser.displayUrl("http://" + hyperlinkEvent.getURL().toString().substring("http://josm-extern.".length()) + "?action=edit");
                } else {
                    HelpAction.this.setHelpUrl(hyperlinkEvent.getURL().toString());
                }
            }
        });
        this.help.setContentType("text/html");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.helpBrowser.setContentPane(jPanel);
        jPanel.add((Component)new JScrollPane(this.help), "Center");
        String[] stringArray = Main.pref.get("help.window.bounds", "0,0,800,600").split(",");
        this.helpBrowser.setBounds(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        this.createButton(jPanel2, I18n.tr("Open in Browser"));
        this.createButton(jPanel2, I18n.tr("Edit"));
        this.createButton(jPanel2, I18n.tr("Reload"));
        this.helpBrowser.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpAction.this.closeHelp();
            }
        });
        this.help.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.help.getActionMap().put("Close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpAction.this.closeHelp();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (I18n.tr("Open in Browser").equals(actionEvent.getActionCommand())) {
            OpenBrowser.displayUrl(this.url);
        } else if (I18n.tr("Edit").equals(actionEvent.getActionCommand())) {
            if (!this.url.startsWith(this.baseurl)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Can only edit help pages from JOSM Online Help"));
                return;
            }
            OpenBrowser.displayUrl(this.url + "?action=edit");
        } else if (I18n.tr("Reload").equals(actionEvent.getActionCommand())) {
            this.setHelpUrl(this.url);
        } else if (actionEvent.getActionCommand() == null) {
            String string = null;
            Point point = Main.parent.getMousePosition();
            if (point != null) {
                string = this.contextSensitiveHelp(SwingUtilities.getDeepestComponentAt(Main.parent, point.x, point.y));
            }
            if (string == null) {
                this.helpBrowser.setVisible(false);
                this.setHelpUrl(this.baseurl + "/wiki/Help");
            } else {
                this.help(string);
            }
        } else {
            this.helpBrowser.setVisible(false);
            this.setHelpUrl(this.baseurl + "/wiki/Help");
        }
    }

    private String contextSensitiveHelp(Object object) {
        if (object instanceof Helpful) {
            return ((Helpful)object).helpTopic();
        }
        if (object instanceof JMenu) {
            return "Menu/" + ((JMenu)object).getText();
        }
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.getClientProperty("help") != null) {
                return (String)abstractButton.getClientProperty("help");
            }
            return this.contextSensitiveHelp(((AbstractButton)object).getAction());
        }
        if (object instanceof Action) {
            return (String)((Action)object).getValue("help");
        }
        if (object instanceof Component) {
            return this.contextSensitiveHelp(((Component)object).getParent());
        }
        return null;
    }

    public void help(String string) {
        this.helpBrowser.setVisible(false);
        this.setHelpUrl(this.baseurl + "/wiki/Help/" + string);
    }

    public void setHelpUrl(String string) {
        String string2;
        int n = string.lastIndexOf("/") + 1;
        String string3 = string.substring(n);
        if (!string3.startsWith(this.languageCode)) {
            string3 = this.languageCode + string3;
        }
        if ((string2 = string.substring(0, n) + string3).equals(this.url) || string2.equals(string)) {
            this.url = string;
            try {
                this.help.read(new StringReader(this.reader.read(string)), (Object)this.help.getEditorKit().createDefaultDocument());
            }
            catch (IOException iOException) {
                this.help.setText(I18n.tr("Error while loading page {0}", string));
            }
        } else {
            try {
                this.help.read(new StringReader(this.reader.read(string2)), (Object)this.help.getEditorKit().createDefaultDocument());
                String string4 = this.help.getText();
                String string5 = "http://josm-extern." + string2.substring(7);
                if (string4.indexOf("Describe &quot;") >= 0 && string4.indexOf(string5) >= 0) {
                    throw new IOException();
                }
                this.url = string2;
            }
            catch (IOException iOException) {
                this.url = string;
                try {
                    this.help.read(new StringReader(this.reader.read(string)), (Object)this.help.getEditorKit().createDefaultDocument());
                }
                catch (IOException iOException2) {
                    this.help.setText(I18n.tr("Error while loading page {0}", string));
                }
            }
        }
        this.helpBrowser.setVisible(true);
    }

    public void closeHelp() {
        String string = this.helpBrowser.getX() + "," + this.helpBrowser.getY() + "," + this.helpBrowser.getWidth() + "," + this.helpBrowser.getHeight();
        Main.pref.put("help.window.bounds", string);
        this.helpBrowser.setVisible(false);
    }

    private void createButton(JPanel jPanel, String string) {
        JButton jButton = new JButton(I18n.tr(string));
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        jPanel.add(jButton);
    }

    public static interface Helpful {
        public String helpTopic();
    }
}

