/*
 * Decompiled with CFR 0.152.
 */
package jomp.runtime;

import jomp.runtime.OMP;

public class NestLock {
    private volatile int nestLevel = 0;
    private volatile int owner = 0;

    public synchronized void set() {
        int n = OMP.getAbsoluteID();
        if (this.owner != n) {
            while (this.nestLevel != 0) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.owner = n;
        }
        ++this.nestLevel;
    }

    public synchronized void unset() {
        --this.nestLevel;
        if (this.nestLevel == 0) {
            this.notify();
        }
    }

    public synchronized boolean test() {
        int n = OMP.getAbsoluteID();
        if (this.nestLevel != 0 && this.owner != n) {
            return false;
        }
        this.owner = n;
        ++this.nestLevel;
        return true;
    }
}

