/*
 * Decompiled with CFR 0.152.
 */
package jomp.compiler;

import jomp.compiler.JavaParser;
import jomp.compiler.JavaParserTreeConstants;
import jomp.compiler.JavaParserVisitor;
import jomp.compiler.Node;
import jomp.compiler.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    protected Token first;
    protected Token last;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JavaParser javaParser, int n) {
        this(n);
        this.parser = javaParser;
    }

    public static Node jjtCreate(JavaParser javaParser, int n) {
        return new SimpleNode(javaParser, n);
    }

    public void jjtOpen() {
        this.first = this.parser.getToken(1);
    }

    public void jjtClose() {
        this.last = this.parser.getToken(0);
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(JavaParserVisitor javaParserVisitor, Object object) {
        return javaParserVisitor.visit(this, object);
    }

    public Object acceptChildren(JavaParserVisitor javaParserVisitor, Object object) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(javaParserVisitor, object);
                ++n;
            }
        }
        return object;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }
}

