/*
 * Decompiled with CFR 0.152.
 */
package jomp.compiler;

public class ReductionType {
    public static final int PLUS = 0;
    public static final int MULT = 1;
    public static final int MINUS = 2;
    public static final int AND = 3;
    public static final int OR = 4;
    public static final int BOR = 5;
    public static final int BXOR = 6;
    public static final int BAND = 7;
    public static final int COUNT = 8;

    public static int getTypeByToken(int n) {
        switch (n) {
            case 118: {
                return 0;
            }
            case 120: {
                return 1;
            }
            case 119: {
                return 0;
            }
            case 115: {
                return 3;
            }
            case 114: {
                return 4;
            }
            case 123: {
                return 5;
            }
            case 124: {
                return 6;
            }
            case 122: {
                return 7;
            }
        }
        System.err.println("Unsupported reduction operation");
        return -1;
    }

    public static String reducerName(int n, String string) {
        switch (n) {
            case 0: {
                return "jomp.runtime.OMP.doPlusReduce(__omp_me, " + string + ")";
            }
            case 1: {
                return "jomp.runtime.OMP.doMultReduce(__omp_me, " + string + ")";
            }
            case 3: {
                return "jomp.runtime.OMP.doAndReduce(__omp_me, " + string + ")";
            }
            case 4: {
                return "jomp.runtime.OMP.doOrReduce(__omp_me, " + string + ")";
            }
            case 5: {
                return "jomp.runtime.OMP.doBitOrReduce(__omp_me, " + string + ")";
            }
            case 6: {
                return "jomp.runtime.OMP.doBitXorReduce(__omp_me, " + string + ")";
            }
            case 7: {
                return "jomp.runtime.OMP.doBitAndReduce(__omp_me, " + string + ")";
            }
        }
        System.err.println("Unsupported reduction operation");
        return "";
    }

    public static String opName(int n) {
        switch (n) {
            case 0: {
                return "+";
            }
            case 1: {
                return "*";
            }
            case 3: {
                return "&&";
            }
            case 4: {
                return "||";
            }
            case 5: {
                return "|";
            }
            case 6: {
                return "^";
            }
            case 7: {
                return "&";
            }
        }
        System.err.println("Unsupported reduction operation");
        return "";
    }

    public static String opDefault(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "false";
            }
            case 5: {
                return "0";
            }
            case 6: {
                return "0";
            }
            case 7: {
                return "~0";
            }
        }
        System.err.println("Unsupported reduction operation");
        return "";
    }
}

