/*
 * Decompiled with CFR 0.152.
 */
package jomp.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.Stack;
import jomp.compiler.ASTAssignmentOperator;
import jomp.compiler.ASTBlock;
import jomp.compiler.ASTClassBody;
import jomp.compiler.ASTExpression;
import jomp.compiler.ASTForStatement;
import jomp.compiler.ASTFormalParameter;
import jomp.compiler.ASTLocalVariableDeclaration;
import jomp.compiler.ASTMethodDeclaration;
import jomp.compiler.ASTOMPBarrierDirective;
import jomp.compiler.ASTOMPClauseList;
import jomp.compiler.ASTOMPCriticalDirective;
import jomp.compiler.ASTOMPForDirective;
import jomp.compiler.ASTOMPForStatement;
import jomp.compiler.ASTOMPMasterDirective;
import jomp.compiler.ASTOMPOnlyDirective;
import jomp.compiler.ASTOMPOrderedDirective;
import jomp.compiler.ASTOMPParallelDirective;
import jomp.compiler.ASTOMPReductionClause;
import jomp.compiler.ASTOMPScheduleClause;
import jomp.compiler.ASTOMPSectionsBlock;
import jomp.compiler.ASTOMPSectionsDirective;
import jomp.compiler.ASTOMPSingleDirective;
import jomp.compiler.ASTPrimaryExpression;
import jomp.compiler.ASTStatement;
import jomp.compiler.ASTType;
import jomp.compiler.ASTVarNameList;
import jomp.compiler.ASTVariableDeclaratorId;
import jomp.compiler.ASTVariableInitializer;
import jomp.compiler.Jomp;
import jomp.compiler.ReductionType;
import jomp.compiler.SimpleNode;
import jomp.compiler.SymbolTable;
import jomp.compiler.Token;
import jomp.compiler.UnparseVisitor;
import jomp.compiler.VarItem;
import jomp.compiler.VarTable;

public class OMPVisitor
extends UnparseVisitor {
    SymbolTable table = new SymbolTable();
    Stack classStack = new Stack();
    Stack outerStack = new Stack();
    boolean isStatic = false;
    boolean isMeDefined = false;
    boolean isInOrderedLoop = false;
    String loopVarName = null;
    String loopWholeDataName = null;
    VarTable pvt = null;
    private int uniqueNumber = 0;

    public OMPVisitor(PrintWriter printWriter) {
        super(printWriter);
    }

    public String getUniqueName() {
        return "__ompName_" + Integer.toString(this.uniqueNumber++);
    }

    public String getUniqueName(String string) {
        return "__omp_" + string + Integer.toString(this.uniqueNumber++);
    }

    public String getSameName(String string) {
        return "__omp_" + string + Integer.toString(this.uniqueNumber - 1);
    }

    public Object visit(ASTVariableInitializer aSTVariableInitializer, Object object) {
        ASTVariableDeclaratorId aSTVariableDeclaratorId;
        SymbolTable.Symbol symbol;
        if (((SimpleNode)aSTVariableInitializer.jjtGetParent()).id == 15 && (symbol = this.table.findSymbol((aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTVariableInitializer.jjtGetParent().jjtGetChild(0)).getFirstToken().toString())) != null) {
            symbol.isInitialized = true;
        }
        return this.print(aSTVariableInitializer, object);
    }

    public Object visit(ASTAssignmentOperator aSTAssignmentOperator, Object object) {
        SimpleNode simpleNode = (SimpleNode)aSTAssignmentOperator.jjtGetParent();
        try {
            do {
                simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
            } while (simpleNode.id != 52);
            ASTPrimaryExpression aSTPrimaryExpression = (ASTPrimaryExpression)simpleNode;
            SymbolTable.Symbol symbol = this.table.findSymbol(aSTPrimaryExpression.getFirstToken().toString());
            if (symbol != null) {
                symbol.isInitialized = true;
            }
        }
        catch (Exception exception) {
            System.err.println("Hey, guy, why you use so nasty expressions like this?");
            aSTAssignmentOperator.dump("==>");
        }
        return this.print(aSTAssignmentOperator, object);
    }

    public Object visit(ASTStatement aSTStatement, Object object) {
        if (aSTStatement.getFirstToken().toString() == "//omp") {
            return this.print((SimpleNode)aSTStatement.jjtGetChild(0), object);
        }
        return this.print(aSTStatement, object);
    }

    public Object visit(ASTMethodDeclaration aSTMethodDeclaration, Object object) {
        boolean bl = this.isStatic;
        this.isStatic = false;
        Token token = aSTMethodDeclaration.getFirstToken();
        while (token != ((SimpleNode)aSTMethodDeclaration.jjtGetChild(0)).getFirstToken()) {
            if (token.kind == 50) {
                this.isStatic = true;
            }
            token = token.next;
        }
        this.table.addScope();
        object = super.visit(aSTMethodDeclaration, object);
        this.table.killScope();
        this.isStatic = bl;
        return object;
    }

    public Object visit(ASTBlock aSTBlock, Object object) {
        this.table.addScope();
        object = super.visit(aSTBlock, object);
        this.table.killScope();
        return object;
    }

    public Object visit(ASTForStatement aSTForStatement, Object object) {
        this.table.addScope();
        object = super.visit(aSTForStatement, object);
        this.table.killScope();
        return object;
    }

    public Object visit(ASTFormalParameter aSTFormalParameter, Object object) {
        ASTType aSTType = (ASTType)aSTFormalParameter.jjtGetChild(0);
        ASTVariableDeclaratorId aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTFormalParameter.jjtGetChild(1);
        String string = ((SimpleNode)aSTFormalParameter.jjtGetChild(1)).getFirstToken().toString();
        String string2 = "";
        Token token = aSTType.getFirstToken();
        while (true) {
            string2 = string2 + " " + token.toString();
            if (token == aSTType.getLastToken()) break;
            token = token.next;
        }
        token = aSTVariableDeclaratorId.getFirstToken();
        while (token != aSTVariableDeclaratorId.getLastToken()) {
            token = token.next;
            string2 = string2 + " " + token.toString();
        }
        SymbolTable.Symbol symbol = this.table.addSymbol(string);
        symbol.sig = string2.trim();
        symbol.isInitialized = true;
        return super.visit(aSTFormalParameter, object);
    }

    public Object visit(ASTLocalVariableDeclaration aSTLocalVariableDeclaration, Object object) {
        ASTType aSTType = (ASTType)aSTLocalVariableDeclaration.jjtGetChild(0);
        int n = 1;
        while (n < aSTLocalVariableDeclaration.jjtGetNumChildren()) {
            String string = ((SimpleNode)aSTLocalVariableDeclaration.jjtGetChild(n).jjtGetChild(0)).getFirstToken().toString();
            ASTVariableDeclaratorId aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTLocalVariableDeclaration.jjtGetChild(n).jjtGetChild(0);
            String string2 = "";
            Token token = aSTType.getFirstToken();
            while (true) {
                string2 = string2 + " " + token.toString();
                if (token == aSTType.getLastToken()) break;
                token = token.next;
            }
            token = aSTVariableDeclaratorId.getFirstToken();
            while (token != aSTVariableDeclaratorId.getLastToken()) {
                token = token.next;
                string2 = string2 + " " + token.toString();
            }
            SymbolTable.Symbol symbol = this.table.addSymbol(string);
            symbol.sig = string2.trim();
            ++n;
        }
        return super.visit(aSTLocalVariableDeclaration, object);
    }

    public Object visit(ASTClassBody aSTClassBody, Object object) {
        this.out.println(" {");
        int n = 0;
        while (n < aSTClassBody.jjtGetNumChildren()) {
            object = this.print((SimpleNode)aSTClassBody.jjtGetChild(n), object);
            ++n;
        }
        try {
            while (true) {
                StringWriter stringWriter = (StringWriter)this.classStack.pop();
                this.out.println(stringWriter.toString());
            }
        }
        catch (EmptyStackException emptyStackException) {
            this.out.println("}");
            try {
                while (true) {
                    StringWriter stringWriter = (StringWriter)this.outerStack.pop();
                    this.out.println(stringWriter.toString());
                }
            }
            catch (EmptyStackException emptyStackException2) {
                return object;
            }
        }
    }

    public Object visit(ASTOMPParallelDirective aSTOMPParallelDirective, Object object) {
        String string;
        VarItem varItem;
        Object object2;
        VarTable varTable = new VarTable();
        ASTExpression aSTExpression = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        SimpleNode simpleNode = null;
        switch (((SimpleNode)aSTOMPParallelDirective.jjtGetChild((int)0)).id) {
            case 90: {
                System.err.println("Parallel For Directive Encountered");
                bl2 = true;
                simpleNode = (ASTOMPClauseList)aSTOMPParallelDirective.jjtGetChild(0).jjtGetChild(0);
                break;
            }
            case 95: {
                System.err.println("Parallel Sections Directive Encountered");
                bl3 = true;
                simpleNode = (ASTOMPClauseList)aSTOMPParallelDirective.jjtGetChild(0).jjtGetChild(0);
                break;
            }
            case 100: {
                System.err.println("Parallel Directive Encountered");
                simpleNode = (ASTOMPClauseList)aSTOMPParallelDirective.jjtGetChild(0);
            }
        }
        int n = 0;
        while (n < simpleNode.jjtGetNumChildren()) {
            switch (((SimpleNode)simpleNode.jjtGetChild((int)n).jjtGetChild((int)0)).id) {
                case 107: {
                    System.err.println("Warning: Can't use nowait clause with parallel directive");
                    break;
                }
                case 106: {
                    if (((SimpleNode)simpleNode.jjtGetChild((int)n).jjtGetChild((int)0)).getFirstToken().next.next.kind != 69) break;
                    bl4 = true;
                    break;
                }
                case 105: {
                    varTable.addNameList((ASTVarNameList)simpleNode.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0), 16, 0, this.table);
                    break;
                }
                case 102: {
                    varTable.addNameList((ASTVarNameList)simpleNode.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0), 1, 0, this.table);
                    break;
                }
                case 103: {
                    varTable.addNameList((ASTVarNameList)simpleNode.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0), 2, 0, this.table);
                    break;
                }
                case 104: {
                    if (!bl2 && !bl3) {
                        System.err.println("Warning: lastprivate clause has no meaning with parallel directive");
                        break;
                    }
                    varTable.addNameList((ASTVarNameList)simpleNode.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0), 16, 0, this.table);
                    break;
                }
                case 108: {
                    aSTExpression = (ASTExpression)simpleNode.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0);
                    break;
                }
                case 111: {
                    object2 = (ASTOMPReductionClause)simpleNode.jjtGetChild(n).jjtGetChild(0);
                    if (!bl2 && !bl3) {
                        int n2 = ReductionType.getTypeByToken(((SimpleNode)((SimpleNode)object2).jjtGetChild((int)0)).getFirstToken().kind);
                        varTable.addNameList((ASTVarNameList)((SimpleNode)object2).jjtGetChild(1), 8, n2, this.table);
                        break;
                    }
                    varTable.addNameList((ASTVarNameList)((SimpleNode)object2).jjtGetChild(1), 16, 0, this.table);
                    break;
                }
                default: {
                    if (bl2 || bl3) break;
                    System.err.println("Warning: meaningless clause " + ((SimpleNode)simpleNode.jjtGetChild((int)n)).id + " with master - ignored");
                }
            }
            ++n;
        }
        if (!bl4) {
            varTable.addShared(this.table);
        }
        object2 = this.getUniqueName("Class");
        String string2 = this.getSameName("Object");
        this.out.println("\n");
        this.out.println("// OMP PARALLEL BLOCK BEGINS");
        this.out.println("{");
        this.out.println("  " + (String)object2 + " " + string2 + " = new " + (String)object2 + "();");
        this.out.println("  // shared variables");
        varTable.getInit(16);
        while ((varItem = varTable.getNext()) != null) {
            if ((varItem.flag & 1) != 1) continue;
            this.out.println("  " + string2 + "." + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println("  // firstprivate variables");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println("  " + string2 + "._fp_" + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println("  try {");
        if (aSTExpression != null) {
            this.out.print("    if(");
            object = this.print(aSTExpression, object);
            this.out.println(") {");
            this.out.println("        jomp.runtime.OMP.doParallel(" + string2 + ");");
            this.out.println("    } else {");
            this.out.println("        " + string2 + ".go(0);");
            this.out.println("    }");
        } else {
            this.out.println("    jomp.runtime.OMP.doParallel(" + string2 + ");");
        }
        this.out.println("  } catch(Throwable __omp_exception) {");
        this.out.println("    System.err.println(\"OMP Warning: Illegal thread exception ignored!\");");
        this.out.println("    System.err.println(__omp_exception);");
        this.out.println("  }");
        this.out.println("  // reduction variables");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println("  " + varItem.name + "  " + ReductionType.opName(varItem.red) + "= " + string2 + "._rd_" + varItem.name + ";");
        }
        this.out.println("  // shared variables");
        varTable.getInit(16);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println("  " + varItem.name + " = " + string2 + "." + varItem.name + ";");
        }
        this.out.println("}");
        this.out.println("// OMP PARALLEL BLOCK ENDS");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("\n");
        if (!bl4) {
            this.classStack.push(stringWriter);
            printWriter.println("// OMP PARALLEL REGION INNER CLASS DEFINITION BEGINS");
            printWriter.print("private");
            if (this.isStatic) {
                printWriter.print(" static");
            }
            string = "// OMP PARALLEL REGION INNER CLASS DEFINITION ENDS";
        } else {
            this.outerStack.push(stringWriter);
            printWriter.println("// OMP PARALLEL REGION OUTER CLASS DEFINITION BEGINS");
            string = "// OMP PARALLEL REGION OUTER CLASS DEFINITION ENDS";
        }
        printWriter.println(" class " + (String)object2 + " extends jomp.runtime.BusyTask {");
        StringBuffer stringBuffer = new StringBuffer("  ");
        printWriter.println(stringBuffer + "// shared variables");
        varTable.getInit(16);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.println(stringBuffer + varItem.type + " " + varItem.name + ";");
        }
        printWriter.println(stringBuffer + "// firstprivate variables");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.println(stringBuffer + varItem.type + " _fp_" + varItem.name + ";");
        }
        printWriter.println(stringBuffer + "// variables to hold results of reduction");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.println(stringBuffer + varItem.type + " _rd_" + varItem.name + ";");
        }
        printWriter.println("");
        printWriter.println(stringBuffer + "public void go(int __omp_me) throws Throwable {");
        boolean bl5 = this.isMeDefined;
        this.isMeDefined = true;
        printWriter.println(stringBuffer + "// firstprivate variables + init");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.print(stringBuffer + varItem.type + " " + varItem.name + " = ");
            printWriter.print("(" + varItem.type + ")" + " _fp_" + varItem.name);
            if (!this.isPrimitiveType(varItem.type)) {
                printWriter.print(".clone()");
            }
            printWriter.println(";");
        }
        printWriter.println(stringBuffer + "// private variables");
        varTable.getInit(1);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.print(stringBuffer + varItem.type + " " + varItem.name);
            if (!this.isPrimitiveType(varItem.type) && !this.isArray(varItem.type)) {
                printWriter.print(" = new " + varItem.type + "()");
            }
            printWriter.println(";");
        }
        printWriter.println(stringBuffer + "// reduction variables, init to default");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.println(stringBuffer + varItem.type + " " + varItem.name + " = " + ReductionType.opDefault(varItem.red) + ";");
        }
        stringBuffer.append("  ");
        printWriter.println(stringBuffer + "// OMP USER CODE BEGINS");
        PrintWriter printWriter2 = this.swapOut(printWriter);
        VarTable varTable2 = this.pvt;
        this.pvt = varTable;
        this.table.addScope();
        object = bl2 ? this.visit((ASTOMPForDirective)aSTOMPParallelDirective.jjtGetChild(0), object, true) : (bl3 ? this.visit((ASTOMPSectionsDirective)aSTOMPParallelDirective.jjtGetChild(0), object, true) : this.visit((SimpleNode)aSTOMPParallelDirective.jjtGetChild(1), object));
        this.table.killScope();
        this.pvt = varTable2;
        printWriter2 = this.swapOut(printWriter2);
        printWriter.println("");
        printWriter.println(stringBuffer + "// OMP USER CODE ENDS");
        stringBuffer.setLength(stringBuffer.length() - 2);
        printWriter.println(stringBuffer + "// call reducer");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.println(stringBuffer + varItem.name + " = (" + varItem.type + ") " + ReductionType.reducerName(varItem.red, varItem.name) + ";");
        }
        printWriter.println(stringBuffer + "// output to _rd_ copy");
        printWriter.println(stringBuffer + "if (jomp.runtime.OMP.getThreadNum(__omp_me) == 0) {");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            printWriter.println(stringBuffer + "  _rd_" + varItem.name + " = " + varItem.name + ";");
        }
        printWriter.println(stringBuffer + "}");
        printWriter.println("  }");
        printWriter.println("}");
        this.isMeDefined = bl5;
        printWriter.println(string);
        return object;
    }

    public Object visit(ASTOMPMasterDirective aSTOMPMasterDirective, Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 6;
        while (n < aSTOMPMasterDirective.getFirstToken().beginColumn) {
            stringBuffer.append(" ");
            ++n;
        }
        this.out.println("");
        this.out.println(stringBuffer + "// OMP MASTER BLOCK BEGINS");
        boolean bl = this.isMeDefined;
        if (!this.isMeDefined) {
            this.out.println(stringBuffer + "int __omp_me = jomp.runtime.OMP.getAbsoluteID();");
            this.isMeDefined = true;
        }
        this.out.println(stringBuffer + "if(jomp.runtime.OMP.getThreadNum(__omp_me) == 0)");
        this.out.println(stringBuffer + "// OMP USER CODE BEGINS");
        object = this.print((SimpleNode)aSTOMPMasterDirective.jjtGetChild(aSTOMPMasterDirective.jjtGetNumChildren() - 1), object);
        this.out.println("");
        this.out.println(stringBuffer + "// OMP USER CODE ENDS");
        this.isMeDefined = bl;
        this.out.println(stringBuffer + "// OMP MASTER BLOCK ENDS");
        return object;
    }

    public Object visit(ASTOMPSingleDirective aSTOMPSingleDirective, Object object) {
        VarItem varItem;
        boolean bl = false;
        VarTable varTable = new VarTable();
        ASTOMPClauseList aSTOMPClauseList = (ASTOMPClauseList)aSTOMPSingleDirective.jjtGetChild(0);
        int n = 0;
        while (n < aSTOMPClauseList.jjtGetNumChildren()) {
            switch (((SimpleNode)aSTOMPClauseList.jjtGetChild((int)n).jjtGetChild((int)0)).id) {
                case 107: {
                    bl = true;
                    break;
                }
                case 102: {
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0), 1, 0, this.table);
                    break;
                }
                case 103: {
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0), 2, 0, this.table);
                    break;
                }
                default: {
                    System.err.println("Warning: meaningless clause " + ((SimpleNode)aSTOMPClauseList.jjtGetChild((int)n)).id + " with master - ignored");
                }
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 6;
        while (n2 < aSTOMPSingleDirective.getFirstToken().beginColumn) {
            stringBuffer.append(" ");
            ++n2;
        }
        this.out.println("");
        boolean bl2 = this.isMeDefined;
        if (!this.isMeDefined) {
            this.out.println(stringBuffer + "int __omp_me = jomp.runtime.OMP.getAbsoluteID();");
            this.isMeDefined = true;
        }
        this.out.println(stringBuffer + "{ // OMP SINGLE BLOCK BEGINS");
        this.out.println(stringBuffer + "if(jomp.runtime.OMP.getTicket(__omp_me) == 0) {");
        this.out.println(stringBuffer + "// copy of firstprivate variables, initialized");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(stringBuffer + varItem.type + " _cp_" + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println(stringBuffer + "{");
        stringBuffer = stringBuffer.append("  ");
        this.out.println(stringBuffer + "// firstprivate variables + init");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(stringBuffer + varItem.type + "  " + varItem.name + " = ");
            this.out.print("(" + varItem.type + ")" + " _cp_" + varItem.name);
            if (!this.isPrimitiveType(varItem.type)) {
                this.out.print(".clone()");
            }
            this.out.println(";");
        }
        this.out.println(stringBuffer + "// private variables");
        varTable.getInit(1);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(stringBuffer + varItem.type + " " + varItem.name);
            if (!this.isPrimitiveType(varItem.type) && !this.isArray(varItem.type)) {
                this.out.print(" = new " + varItem.type + "()");
            }
            this.out.println(";");
        }
        this.out.println(stringBuffer + " // OMP USER CODE BEGINS");
        object = this.print((SimpleNode)aSTOMPSingleDirective.jjtGetChild(aSTOMPSingleDirective.jjtGetNumChildren() - 1), object);
        this.out.println("");
        this.out.println(stringBuffer + " // OMP USER CODE ENDS");
        stringBuffer.setLength(stringBuffer.length() - 2);
        this.out.println(stringBuffer + "}");
        this.out.println(stringBuffer + "}");
        this.out.println(stringBuffer + "jomp.runtime.OMP.resetTicket(__omp_me);");
        if (!bl) {
            this.out.println(stringBuffer + "jomp.runtime.OMP.doBarrier(__omp_me);");
        }
        this.out.println(stringBuffer + "} // OMP SINGLE BLOCK ENDS");
        this.isMeDefined = bl2;
        return object;
    }

    public Object visit(ASTOMPForDirective aSTOMPForDirective, Object object) {
        return this.visit(aSTOMPForDirective, object, false);
    }

    public Object visit(ASTOMPForDirective aSTOMPForDirective, Object object, boolean bl) {
        int n;
        String string;
        String string2;
        String string3;
        VarItem varItem;
        int n2;
        Object object2;
        SimpleNode simpleNode;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        VarTable varTable = new VarTable();
        ASTExpression aSTExpression = null;
        int n3 = Jomp.Options.schedMode;
        ASTOMPClauseList aSTOMPClauseList = (ASTOMPClauseList)aSTOMPForDirective.jjtGetChild(0);
        int n4 = 0;
        while (n4 < aSTOMPClauseList.jjtGetNumChildren()) {
            switch (((SimpleNode)aSTOMPClauseList.jjtGetChild((int)n4).jjtGetChild((int)0)).id) {
                case 107: {
                    if (bl) {
                        System.err.println("Warning - can't use nowait clause with parallel for!");
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case 110: {
                    bl3 = true;
                    break;
                }
                case 109: {
                    simpleNode = (ASTOMPScheduleClause)aSTOMPClauseList.jjtGetChild(n4).jjtGetChild(0);
                    n3 = simpleNode.getFirstToken().next.next.kind;
                    if (simpleNode.jjtGetNumChildren() <= 0) break;
                    bl4 = true;
                    aSTExpression = (ASTExpression)simpleNode.jjtGetChild(0);
                    break;
                }
                case 111: {
                    object2 = (ASTOMPReductionClause)aSTOMPClauseList.jjtGetChild(n4).jjtGetChild(0);
                    n2 = ReductionType.getTypeByToken(((SimpleNode)((SimpleNode)object2).jjtGetChild((int)0)).getFirstToken().kind);
                    varTable.addNameList((ASTVarNameList)((SimpleNode)object2).jjtGetChild(1), 8, n2, this.table);
                    break;
                }
                case 102: {
                    if (bl) break;
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n4).jjtGetChild(0).jjtGetChild(0), 1, 0, this.table);
                    break;
                }
                case 103: {
                    if (bl) break;
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n4).jjtGetChild(0).jjtGetChild(0), 2, 0, this.table);
                    break;
                }
                case 104: {
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n4).jjtGetChild(0).jjtGetChild(0), 4, 0, this.table);
                    break;
                }
                case 105: {
                    if (bl) break;
                    Jomp.message(2, "Warning: shared clause has no meaning with for directive!");
                    break;
                }
                case 108: {
                    if (bl) break;
                    Jomp.message(2, "Warning: if clause has no meaning with for directive!");
                    break;
                }
                case 106: {
                    if (bl) break;
                    Jomp.message(2, "Warning: default clause has no meaning with for directive!");
                    break;
                }
                default: {
                    Jomp.message(6, "Warning: meaningless clause " + ((SimpleNode)aSTOMPClauseList.jjtGetChild((int)n4)).id + " with master - ignored");
                }
            }
            ++n4;
        }
        simpleNode = (ASTOMPForStatement)aSTOMPForDirective.jjtGetChild(1);
        object2 = new StringBuffer("");
        n2 = 6;
        while (n2 < aSTOMPForDirective.getFirstToken().beginColumn) {
            ((StringBuffer)object2).append(" ");
            ++n2;
        }
        String string4 = this.getUniqueName("ChunkData");
        String string5 = this.getUniqueName("WholeData");
        this.out.println("");
        this.out.println(object2 + "{ // OMP FOR BLOCK BEGINS");
        this.out.println(object2 + "// copy of firstprivate variables, initialized");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + varItem.type + " _cp_" + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println(object2 + "// copy of lastprivate variables");
        varTable.getInit(4);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(object2 + varItem.type + " _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "// variables to hold result of reduction");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + varItem.type + " _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "boolean amLast=false;");
        boolean bl5 = this.isMeDefined;
        if (!this.isMeDefined) {
            this.out.println(object2 + "int __omp_me = jomp.runtime.OMP.getAbsoluteID();");
            this.isMeDefined = true;
        }
        this.out.println(object2 + "{");
        object2 = ((StringBuffer)object2).append("  ");
        this.out.println(object2 + "// firstprivate variables + init");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(object2 + varItem.type + "  " + varItem.name + " = ");
            this.out.print("(" + varItem.type + ")" + " _cp_" + varItem.name);
            if (!this.isPrimitiveType(varItem.type)) {
                this.out.print(".clone()");
            }
            this.out.println(";");
        }
        this.out.println(object2 + "// [last]private variables");
        varTable.getInit(5);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(object2 + varItem.type + " " + varItem.name);
            if (!this.isPrimitiveType(varItem.type) && !this.isArray(varItem.type)) {
                this.out.print(" = new " + varItem.type + "()");
            }
            this.out.println(";");
        }
        this.out.println(object2 + "// reduction variables + init to default");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + varItem.type + "  " + varItem.name + " = " + ReductionType.opDefault(varItem.red) + ";");
        }
        this.out.println(object2 + "// -------------------------------------");
        this.out.println(object2 + "jomp.runtime.LoopData " + string5 + " = new jomp.runtime.LoopData();");
        this.out.println(object2 + "jomp.runtime.LoopData " + string4 + " = new jomp.runtime.LoopData();");
        boolean bl6 = true;
        this.out.print(object2 + string5 + ".start = (long)(");
        object = this.print((SimpleNode)simpleNode.jjtGetChild(1), object);
        this.out.println(");");
        this.out.print(object2 + string5 + ".stop = (long)(");
        object = this.print((SimpleNode)simpleNode.jjtGetChild(4), object);
        this.out.print(")");
        switch (((SimpleNode)simpleNode.jjtGetChild((int)3)).getFirstToken().kind) {
            case 111: {
                bl6 = true;
                this.out.print("+1");
                break;
            }
            case 112: {
                bl6 = false;
                this.out.print("-1");
                break;
            }
            case 105: {
                bl6 = true;
                break;
            }
            case 104: {
                bl6 = false;
            }
        }
        this.out.println(";");
        this.out.print(object2 + string5 + ".step = (long)(");
        block18 : switch (((SimpleNode)simpleNode.jjtGetChild((int)5)).getFirstToken().kind) {
            case 116: {
                this.out.print("1");
                break;
            }
            case 117: {
                this.out.print("-1");
                break;
            }
            default: {
                switch (((SimpleNode)simpleNode.jjtGetChild((int)5)).getFirstToken().next.kind) {
                    case 116: {
                        this.out.print("1");
                        break block18;
                    }
                    case 117: {
                        this.out.print("-1");
                        break block18;
                    }
                    case 129: {
                        this.print((SimpleNode)simpleNode.jjtGetChild(5).jjtGetChild(1), object);
                        break block18;
                    }
                    case 130: {
                        this.out.print("-(");
                        this.print((SimpleNode)simpleNode.jjtGetChild(5).jjtGetChild(1), object);
                        this.out.print(")");
                        break block18;
                    }
                    case 103: {
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(5).jjtGetChild(1);
                        SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(1);
                        String string6 = ((SimpleNode)simpleNode2.jjtGetChild(0)).getFirstToken().toString();
                        if (!string6.equals(((SimpleNode)simpleNode.jjtGetChild(5).jjtGetChild(0)).getFirstToken().toString())) {
                            System.err.println("In FOR - update - used variables do not match!");
                        }
                        switch (simpleNode2.getFirstToken().next.kind) {
                            case 118: {
                                this.print(simpleNode3, object);
                                break block18;
                            }
                            case 119: {
                                this.out.print("-(");
                                this.print(simpleNode3, object);
                                this.out.print(")");
                                break block18;
                            }
                        }
                        System.err.println("Panic parsing FOR - 1!");
                        break block18;
                    }
                }
                System.err.println("Panic parsing FOR - 2 !");
            }
        }
        this.out.println(");");
        if (aSTExpression == null) {
            switch (n3) {
                case 50: {
                    this.out.println(object2 + "jomp.runtime.OMP.setChunkStatic(" + string5 + ");");
                    break;
                }
                case 79: 
                case 80: {
                    this.out.println(object2 + string5 + ".chunkSize = 1;");
                    break;
                }
                case 81: {
                    this.out.println(object2 + "jomp.runtime.OMP.setChunkRuntime(" + string5 + ");");
                    break;
                }
                default: {
                    System.err.println("Unknown scheduling policy!");
                    break;
                }
            }
        } else {
            this.out.print(object2 + string5 + ".chunkSize = (long)(");
            object = this.print(aSTExpression, object);
            this.out.println(");");
        }
        this.table.addScope();
        switch (simpleNode.getFirstToken().next.next.kind) {
            case 16: 
            case 38: 
            case 40: 
            case 49: {
                string3 = simpleNode.getFirstToken().next.next.toString();
                string2 = simpleNode.getFirstToken().next.next.next.toString();
                SymbolTable.Symbol symbol = this.table.addSymbol(string2);
                symbol.sig = string3;
                string = string3;
                break;
            }
            default: {
                string2 = simpleNode.getFirstToken().next.next.toString();
                SymbolTable.Symbol symbol = this.table.findSymbol(string2);
                if (symbol == null) {
                    System.err.println("Variable in For statement must be local!");
                }
                string3 = symbol.sig;
                string = "";
                if (this.pvt == null || (n = this.pvt.search(string2)) == -1) break;
                VarItem varItem2 = (VarItem)this.pvt.get(n);
                if (varItem2.kind != 16) break;
                string = string3;
            }
        }
        n = 0;
        String string7 = null;
        String string8 = null;
        if (bl3) {
            this.out.println(object2 + "jomp.runtime.OMP.resetOrderer(__omp_me, " + string5 + ".start);");
            n = this.isInOrderedLoop ? 1 : 0;
            string7 = this.loopVarName;
            string8 = string5;
            this.isInOrderedLoop = true;
            this.loopVarName = string2;
            this.loopWholeDataName = string5;
        }
        String string9 = bl6 ? "<" : ">";
        switch (n3) {
            case 50: {
                this.out.print(object2 + "while(!" + string4 + ".isLast && ");
                this.out.println("jomp.runtime.OMP.getLoopStatic(__omp_me, " + string5 + ", " + string4 + ")) {");
                break;
            }
            case 79: {
                this.out.println(object2 + "jomp.runtime.OMP.initTicket(__omp_me, " + string5 + ");");
                this.out.print(object2 + "while(!" + string4 + ".isLast && ");
                this.out.println("jomp.runtime.OMP.getLoopDynamic(__omp_me, " + string5 + ", " + string4 + ")) {");
                break;
            }
            case 80: {
                this.out.print(object2 + "while(!" + string4 + ".isLast && ");
                this.out.println("jomp.runtime.OMP.getLoopGuided(__omp_me, " + string5 + ", " + string4 + ")) {");
                break;
            }
            case 81: {
                this.out.println(object2 + "if (jomp.runtime.OMP.isDynamic())");
                this.out.println(object2 + "  jomp.runtime.OMP.initTicket(__omp_me, " + string5 + ");");
                this.out.print(object2 + "while(!" + string4 + ".isLast && ");
                this.out.println("jomp.runtime.OMP.getLoopRuntime(__omp_me, " + string5 + ", " + string4 + ")) {");
                break;
            }
            default: {
                System.err.println("Scheduling option not currently supported!");
            }
        }
        String string10 = this.getUniqueName();
        if (n3 == 50 || n3 == 81) {
            this.out.println(object2 + "for(;;) {");
            this.out.println(object2 + "  if(" + string5 + ".step > 0) {");
            this.out.println(object2 + "     if(" + string4 + ".stop > " + string5 + ".stop) " + string4 + ".stop = " + string5 + ".stop;");
            this.out.println(object2 + "     if(" + string4 + ".start >= " + string5 + ".stop) break;");
            this.out.println(object2 + "  } else {");
            this.out.println(object2 + "     if(" + string4 + ".stop < " + string5 + ".stop) " + string4 + ".stop = " + string5 + ".stop;");
            this.out.println(object2 + "     if(" + string4 + ".start > " + string5 + ".stop) break;");
            this.out.println(object2 + "  }");
        }
        if (Jomp.Options.debugLoops) {
            this.out.println(object2 + "System.err.println(\"Process \" + jomp.runtime.OMP.getThreadNum() + \" executing iterations \" + " + string4 + ".start + \" to \" + (" + string4 + ".stop - 1) + \" with step \" + " + string4 + ".step);");
        }
        this.out.println(object2 + "  for(" + string + " " + string2 + " = (" + string3 + ")" + string4 + ".start; " + string2 + " " + string9 + " " + string4 + ".stop; " + string2 + " += " + string4 + ".step) {");
        this.out.println(object2 + "    // OMP USER CODE BEGINS");
        object = this.print((SimpleNode)aSTOMPForDirective.jjtGetChild(1).jjtGetChild(6), object);
        this.out.println("");
        this.out.println(object2 + "    // OMP USER CODE ENDS");
        this.out.println(object2 + "    if (" + string2 + " == (" + string5 + ".stop-1)) amLast = true;");
        this.out.println(object2 + "  } // of for ");
        if (n3 == 50 || n3 == 81) {
            this.out.println(object2 + "  if(" + string4 + ".startStep == 0)");
            this.out.println(object2 + "    break;");
            this.out.println(object2 + "  " + string4 + ".start += " + string4 + ".startStep;");
            this.out.println(object2 + "  " + string4 + ".stop += " + string4 + ".startStep;");
            this.out.println(object2 + "} // of for(;;)");
        }
        this.out.println(object2 + "} // of while");
        this.out.println(object2 + "// call reducer");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "_cp_" + varItem.name + " = (" + varItem.type + ") " + ReductionType.reducerName(varItem.red, varItem.name) + ";");
        }
        if (n3 != 50) {
            this.out.println(object2 + "jomp.runtime.OMP.resetTicket(__omp_me);");
        }
        if (!bl2) {
            this.out.println(object2 + "jomp.runtime.OMP.doBarrier(__omp_me);");
        }
        this.isMeDefined = bl5;
        this.out.println(object2 + "// copy lastprivate variables out");
        this.out.println(object2 + "if (amLast) {");
        varTable.getInit(4);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "  _cp_" + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println(object2 + "}");
        ((StringBuffer)object2).setLength(((StringBuffer)object2).length() - 2);
        this.out.println(object2 + "}");
        this.out.println(object2 + "// set global from lastprivate variables");
        this.out.println(object2 + "if (amLast) {");
        varTable.getInit(4);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "  " + varItem.name + " = _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "}");
        this.out.println(object2 + "// set global from reduction variables");
        this.out.println(object2 + "if (jomp.runtime.OMP.getThreadNum(__omp_me) == 0) {");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "  " + varItem.name + ReductionType.opName(varItem.red) + "= _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "}");
        if (bl3) {
            this.isInOrderedLoop = n;
            this.loopVarName = string7;
            this.loopWholeDataName = string8;
        }
        this.table.killScope();
        this.out.println(object2 + "} // OMP FOR BLOCK ENDS");
        return object;
    }

    public Object visit(ASTOMPSectionsDirective aSTOMPSectionsDirective, Object object) {
        return this.visit(aSTOMPSectionsDirective, object, false);
    }

    public Object visit(ASTOMPSectionsDirective aSTOMPSectionsDirective, Object object, boolean bl) {
        VarItem varItem;
        int n;
        Object object2;
        boolean bl2 = false;
        VarTable varTable = new VarTable();
        ASTOMPClauseList aSTOMPClauseList = (ASTOMPClauseList)aSTOMPSectionsDirective.jjtGetChild(0);
        int n2 = 0;
        while (n2 < aSTOMPClauseList.jjtGetNumChildren()) {
            switch (((SimpleNode)aSTOMPClauseList.jjtGetChild((int)n2).jjtGetChild((int)0)).id) {
                case 107: {
                    if (bl) {
                        System.err.println("Warning - can't use nowait clause with parallel sections!");
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case 111: {
                    object2 = (ASTOMPReductionClause)aSTOMPClauseList.jjtGetChild(n2).jjtGetChild(0);
                    n = ReductionType.getTypeByToken(((SimpleNode)((SimpleNode)object2).jjtGetChild((int)0)).getFirstToken().kind);
                    varTable.addNameList((ASTVarNameList)((SimpleNode)object2).jjtGetChild(1), 8, n, this.table);
                    break;
                }
                case 102: {
                    if (bl) break;
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n2).jjtGetChild(0).jjtGetChild(0), 1, 0, this.table);
                    break;
                }
                case 103: {
                    if (bl) break;
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n2).jjtGetChild(0).jjtGetChild(0), 2, 0, this.table);
                    break;
                }
                case 104: {
                    varTable.addNameList((ASTVarNameList)aSTOMPClauseList.jjtGetChild(n2).jjtGetChild(0).jjtGetChild(0), 4, 0, this.table);
                    break;
                }
                case 105: {
                    if (bl) break;
                    Jomp.message(2, "Warning: shared clause has no meaning with sections directive!");
                    break;
                }
                case 108: {
                    if (bl) break;
                    Jomp.message(2, "Warning: if clause has no meaning with sections directive!");
                    break;
                }
                case 106: {
                    if (bl) break;
                    Jomp.message(2, "Warning: default clause has no meaning with sections directive!");
                    break;
                }
                default: {
                    Jomp.message(6, "Warning: meaningless clause " + ((SimpleNode)aSTOMPClauseList.jjtGetChild((int)n2)).id + " with master - ignored");
                }
            }
            ++n2;
        }
        object2 = new StringBuffer("");
        n = 6;
        while (n < aSTOMPSectionsDirective.getFirstToken().beginColumn) {
            ((StringBuffer)object2).append(" ");
            ++n;
        }
        String string = this.getUniqueName();
        this.out.println("");
        this.out.println(object2 + "{ // OMP SECTIONS BLOCK BEGINS");
        this.out.println(object2 + "// copy of firstprivate variables, initialized");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + varItem.type + " _cp_" + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println(object2 + "// copy of lastprivate variables");
        varTable.getInit(4);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(object2 + varItem.type + " _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "// variables to hold result of reduction");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + varItem.type + " _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "boolean amLast=false;");
        boolean bl3 = this.isMeDefined;
        if (!this.isMeDefined) {
            this.out.println(object2 + "int __omp_me = jomp.runtime.OMP.getAbsoluteID();");
            this.isMeDefined = true;
        }
        this.out.println(object2 + "{");
        object2 = ((StringBuffer)object2).append("  ");
        this.out.println(object2 + "// firstprivate variables + init");
        varTable.getInit(2);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(object2 + varItem.type + "  " + varItem.name + " = ");
            this.out.print("(" + varItem.type + ")" + " _cp_" + varItem.name);
            if (!this.isPrimitiveType(varItem.type)) {
                this.out.print(".clone()");
            }
            this.out.println(";");
        }
        this.out.println(object2 + "// [last]private variables");
        varTable.getInit(5);
        while ((varItem = varTable.getNext()) != null) {
            this.out.print(object2 + varItem.type + " " + varItem.name);
            if (!this.isPrimitiveType(varItem.type) && !this.isArray(varItem.type)) {
                this.out.print(" = new " + varItem.type + "()");
            }
            this.out.println(";");
        }
        this.out.println(object2 + "// reduction variables + init to default");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + varItem.type + "  " + varItem.name + " = " + ReductionType.opDefault(varItem.red) + ";");
        }
        this.out.println(object2 + "// -------------------------------------");
        this.out.println(object2 + string + ": while(true) {");
        this.out.println(object2 + "switch((int)jomp.runtime.OMP.getTicket(__omp_me)) {");
        ASTOMPSectionsBlock aSTOMPSectionsBlock = (ASTOMPSectionsBlock)aSTOMPSectionsDirective.jjtGetChild(aSTOMPSectionsDirective.jjtGetNumChildren() - 1);
        int n3 = 0;
        while (n3 < aSTOMPSectionsBlock.jjtGetNumChildren()) {
            this.out.println(object2 + "// OMP SECTION BLOCK " + n3 + " BEGINS");
            this.out.println(object2 + "  case " + n3 + ": {");
            this.out.println(object2 + "// OMP USER CODE BEGINS");
            object = this.print((SimpleNode)aSTOMPSectionsBlock.jjtGetChild(n3).jjtGetChild(0), object);
            this.out.println("");
            this.out.println(object2 + "// OMP USER CODE ENDS");
            if (n3 + 1 == aSTOMPSectionsBlock.jjtGetNumChildren()) {
                this.out.println(object2 + "amLast = true;");
                varTable.getInit(4);
                while ((varItem = varTable.getNext()) != null) {
                    this.out.println(object2 + "_cp_" + varItem.name + " = " + varItem.name + ";");
                }
            }
            this.out.println(object2 + "  };  break;");
            this.out.println(object2 + "// OMP SECTION BLOCK " + n3 + " ENDS");
            ++n3;
        }
        this.out.println("");
        this.out.println(object2 + "  default: break " + string + ";");
        this.out.println(object2 + "} // of switch");
        this.out.println(object2 + "} // of while");
        this.out.println(object2 + "// call reducer");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "_cp_" + varItem.name + " = (" + varItem.type + ") " + ReductionType.reducerName(varItem.red, varItem.name) + ";");
        }
        this.out.println(object2 + "jomp.runtime.OMP.resetTicket(__omp_me);");
        if (!bl2) {
            this.out.println(object2 + "jomp.runtime.OMP.doBarrier(__omp_me);");
        }
        this.isMeDefined = bl3;
        this.out.println(object2 + "// copy lastprivate variables out");
        this.out.println(object2 + "if (amLast) {");
        varTable.getInit(4);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "  _cp_" + varItem.name + " = " + varItem.name + ";");
        }
        this.out.println(object2 + "}");
        ((StringBuffer)object2).setLength(((StringBuffer)object2).length() - 2);
        this.out.println(object2 + "}");
        this.out.println(object2 + "// update lastprivate variables");
        this.out.println(object2 + "if (amLast) {");
        varTable.getInit(4);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "  " + varItem.name + " = _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "}");
        this.out.println(object2 + "// update reduction variables");
        this.out.println(object2 + "if (jomp.runtime.OMP.getThreadNum(__omp_me) == 0) {");
        varTable.getInit(8);
        while ((varItem = varTable.getNext()) != null) {
            this.out.println(object2 + "  " + varItem.name + ReductionType.opName(varItem.red) + "= _cp_" + varItem.name + ";");
        }
        this.out.println(object2 + "}");
        this.out.println(object2 + "} // OMP SECTIONS BLOCK ENDS");
        return object;
    }

    public Object visit(ASTOMPOrderedDirective aSTOMPOrderedDirective, Object object) {
        if (!this.isInOrderedLoop) {
            Jomp.message(2, "Error: ordered directive not in ordered loop!");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 6;
        while (n < aSTOMPOrderedDirective.getFirstToken().beginColumn) {
            stringBuffer.append(" ");
            ++n;
        }
        this.out.println("");
        this.out.println(stringBuffer + "// OMP ORDERED BLOCK BEGINS");
        this.out.println(stringBuffer + "jomp.runtime.OMP.startOrdered(__omp_me, (long)" + this.loopVarName + ");");
        this.out.println(stringBuffer + "// OMP USER CODE BEGINS");
        object = this.print((SimpleNode)aSTOMPOrderedDirective.jjtGetChild(aSTOMPOrderedDirective.jjtGetNumChildren() - 1), object);
        this.out.println("");
        this.out.println(stringBuffer + "// OMP USER CODE ENDS");
        this.out.println(stringBuffer + "jomp.runtime.OMP.stopOrdered(__omp_me, (long)(" + this.loopVarName + " + " + this.loopWholeDataName + ".step));");
        this.out.println(stringBuffer + "// OMP ORDERED BLOCK ENDS");
        return object;
    }

    public Object visit(ASTOMPBarrierDirective aSTOMPBarrierDirective, Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 6;
        while (n < aSTOMPBarrierDirective.getFirstToken().beginColumn) {
            stringBuffer.append(" ");
            ++n;
        }
        this.out.println("");
        this.out.println(stringBuffer + "// OMP BARRIER BLOCK BEGINS");
        if (this.isMeDefined) {
            this.out.println(stringBuffer + "jomp.runtime.OMP.doBarrier(__omp_me);");
        } else {
            this.out.println(stringBuffer + "jomp.runtime.OMP.doBarrier();");
        }
        this.out.println(stringBuffer + "// OMP BARRIER BLOCK ENDS");
        return object;
    }

    public Object visit(ASTOMPCriticalDirective aSTOMPCriticalDirective, Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 6;
        while (n < aSTOMPCriticalDirective.getFirstToken().beginColumn) {
            stringBuffer.append(" ");
            ++n;
        }
        String string = aSTOMPCriticalDirective.jjtGetNumChildren() == 2 ? ((SimpleNode)aSTOMPCriticalDirective.jjtGetChild(0)).getFirstToken().toString() : "";
        this.out.println("");
        this.out.println(stringBuffer + "// OMP CRITICAL BLOCK BEGINS");
        this.out.println(stringBuffer + "synchronized (jomp.runtime.OMP.getLockByName(\"" + string + "\")) {");
        this.out.println(stringBuffer + "// OMP USER CODE BEGINS");
        object = this.print((SimpleNode)aSTOMPCriticalDirective.jjtGetChild(aSTOMPCriticalDirective.jjtGetNumChildren() - 1), object);
        this.out.println("");
        this.out.println(stringBuffer + "// OMP USER CODE ENDS");
        this.out.println(stringBuffer + "}");
        this.out.println(stringBuffer + "// OMP CRITICAL BLOCK ENDS");
        return object;
    }

    public Object visit(ASTOMPOnlyDirective aSTOMPOnlyDirective, Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 6;
        while (n < aSTOMPOnlyDirective.getFirstToken().beginColumn) {
            stringBuffer.append(" ");
            ++n;
        }
        this.out.println("");
        this.out.println(stringBuffer + "// OMP ONLY BLOCK BEGINS");
        this.out.println(stringBuffer + "// OMP USER CODE BEGINS");
        object = this.print((SimpleNode)aSTOMPOnlyDirective.jjtGetChild(aSTOMPOnlyDirective.jjtGetNumChildren() - 1), object);
        this.out.println(stringBuffer + "// OMP USER CODE ENDS");
        this.out.println(stringBuffer + "// OMP ONLY BLOCK ENDS");
        return object;
    }

    private boolean isPrimitiveType(String string) {
        if (string.equals("byte")) {
            return true;
        }
        if (string.equals("short")) {
            return true;
        }
        if (string.equals("int")) {
            return true;
        }
        if (string.equals("long")) {
            return true;
        }
        if (string.equals("float")) {
            return true;
        }
        if (string.equals("double")) {
            return true;
        }
        if (string.equals("boolean")) {
            return true;
        }
        return string.equals("char");
    }

    private boolean isArray(String string) {
        return string.endsWith("]");
    }
}

