/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.types;

import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.test.optimization.LocalSnapshotOptimizer;
import com.cenqua.clover.test.optimization.OptimizationSession;
import com.cenqua.clover.test.optimization.Optimizer;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.types.BaseCloverOptimizedType;
import com.cenqua.clover.types.TestFile;
import java.io.File;
import org.apache.tools.ant.BuildException;

public abstract class BaseCloverOptimizedTestSelector
extends BaseCloverOptimizedType {
    protected Optimizer optimizer;
    protected OptimizationSession session;
    protected int totalFilesSeen = 0;
    protected int totalFilesIncluded = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        Logger originalLogger = this.takeOverLogging(this.getProject());
        try {
            this.maybeInitialise();
            ++this.totalFilesSeen;
            if (this.options.isEnabled() && this.optimizer.canOptimize()) {
                boolean include = this.optimizer.include(new TestFile(file), this.session);
                this.incrementalLog(file, include);
                boolean bl = include;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.revertLogger(originalLogger);
        }
    }

    private void incrementalLog(File file, boolean include) {
        if (this.options.isDebug()) {
            if (include) {
                ++this.totalFilesIncluded;
                Logger.getInstance().debug("Including " + file.getAbsolutePath() + " in optimized test run");
            } else {
                Logger.getInstance().debug("Excluding " + file.getAbsolutePath() + " from optimized test run");
            }
            Logger.getInstance().debug("Total files included: " + this.totalFilesIncluded + " from total files seen: " + this.totalFilesSeen);
        }
    }

    protected abstract AntInstrumentationConfig getInstrConfig();

    protected void onSucessfulInitialisation() {
    }

    protected void maybeInitialise() {
        if (this.options.isEnabled() && this.optimizer == null) {
            this.optimizer = new LocalSnapshotOptimizer(this.options.withDefaultInitString(this.getInstrConfig()).withSnapshotAt(this.snapshotFile == null ? Snapshot.fileForInitString(this.getInstrConfig().resolveInitString()) : this.snapshotFile));
            this.session = new OptimizationSession(this.options, false);
            this.onSucessfulInitialisation();
        }
    }
}

