/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import com.cenqua.clover.Logger;
import com.cenqua.clover.remote.Config;
import com.cenqua.clover.remote.RecorderListener;
import com.cenqua.clover.remote.RecorderService;
import com.cenqua.clover.remote.RemoteFactory;
import com.cenqua.clover.remote.RpcMessage;
import com.cenqua.clover.util.Color;
import java.util.Arrays;

public class DistributedClover {
    private RecorderService SERVICE = null;
    private RecorderListener CLIENT = null;

    public void initClientServer(char[] serverChars) {
        try {
            String instrServerChars = serverChars != null ? new String(serverChars) : null;
            String distributedConfigString = DistributedClover.getStringProp("clover.distributed.coverage", instrServerChars);
            if (distributedConfigString == null) {
                Logger.getInstance().verbose("Distributed coverage is disabled.'");
                return;
            }
            Config config = RemoteFactory.getInstance().createConfig(distributedConfigString);
            if (!config.isEnabled()) {
                Logger.getInstance().verbose("Distributed coverage is disabled via config: " + distributedConfigString);
                return;
            }
            Logger.getInstance().info("Distributed coverage is enabled with: " + config);
            if (this.SERVICE != null && DistributedClover.isServerMode()) {
                Logger.getInstance().verbose("Service already created for: " + config);
                return;
            }
            if (DistributedClover.isServerMode()) {
                this.initServer(config);
            } else {
                this.initClient(config);
            }
        }
        catch (Exception e) {
            Logger.getInstance().error("Could not initialise Distributed Coverage collection in Clover: " + e.getMessage(), e);
        }
    }

    public void remoteFlush(RpcMessage message) {
        if (DistributedClover.isServerMode() && this.SERVICE != null) {
            if (Logger.isDebug()) {
                Logger.getInstance().debug(message.getName() + "( " + Arrays.asList(message.getMethodArgs()) + ")");
            }
            long remstart = System.currentTimeMillis();
            this.SERVICE.sendMessage(message);
            if (Logger.isDebug()) {
                Logger.getInstance().debug(message.getName() + " remote flush took: " + (System.currentTimeMillis() - remstart) + " ms");
            }
        }
    }

    private void initServer(Config config) {
        Logger.getInstance().info(Color.make("Starting distributed coverage service.").blue().toString());
        this.SERVICE = RemoteFactory.getInstance().createService(config);
        this.SERVICE.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DistributedClover distributedClover = this;
        synchronized (distributedClover) {
            if (this.CLIENT != null) {
                this.CLIENT.disconnect();
            }
            if (this.SERVICE != null) {
                this.SERVICE.stop();
            }
        }
    }

    public boolean hasService() {
        return this.SERVICE != null;
    }

    private void initClient(Config config) {
        if (this.CLIENT == null) {
            this.CLIENT = RemoteFactory.getInstance().createListener(config);
            Logger.getInstance().info(Color.make("Starting distributed coverage client: " + config).blue().toString());
            this.CLIENT.connect();
        }
    }

    private static boolean isServerMode() {
        return DistributedClover.getBooleanProp("clover.server", true);
    }

    private static boolean getBooleanProp(String name, boolean defaultValue) {
        try {
            return Boolean.getBoolean(name);
        }
        catch (SecurityException e) {
            Logger.getInstance().warn("Distributed coverage disabled due to security exception: " + e.getMessage() + "  Please ensure Clover has read access to System properties in this JVM.");
            Logger.getInstance().debug(e.getMessage(), e);
            return defaultValue;
        }
    }

    private static String getStringProp(String name, String defaultVal) {
        try {
            return System.getProperty(name, defaultVal);
        }
        catch (SecurityException e) {
            Logger.getInstance().debug("Distributed coverage disabled due to security exception: " + e.getMessage() + "  Please ensure Clover has read access to System properties in this JVM.");
            Logger.getInstance().debug(e.getMessage(), e);
            return defaultVal;
        }
    }
}

