/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.SourceRegion;
import java.io.Serializable;

public class BranchInfo
extends ElementInfo
implements Serializable {
    private static final long serialVersionUID = -3342667594220678217L;
    private MethodInfo containingMethod;
    private boolean instrumented;

    public BranchInfo(MethodInfo containingMethod, int relativeDataIndex, ContextSet context, SourceRegion region, int complexity, boolean instrumented) {
        super(containingMethod.getContainingFile(), relativeDataIndex, context, region, complexity);
        this.instrumented = instrumented;
        this.containingMethod = containingMethod;
        this.setDataLength(2);
    }

    public int getTrueHitCount() {
        return super.getHitCount();
    }

    public int getFalseHitCount() {
        CoverageDataProvider data = this.getDataProvider();
        if (data == null) {
            return 0;
        }
        return data.getHitCount(this.getDataIndex() + 1);
    }

    public boolean isInstrumented() {
        return this.instrumented;
    }

    public BranchInfo copy(MethodInfo method) {
        return new BranchInfo(method, this.getRelativeDataIndex(), this.getContext(), this, this.getComplexity(), this.isInstrumented());
    }

    public void setDataProvider(CoverageDataProvider data) {
        throw new UnsupportedOperationException("setDataProvider not supported on BranchInfo");
    }

    public CoverageDataProvider getDataProvider() {
        return this.containingMethod.getDataProvider();
    }
}

