/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodEntryInstrEmitter;
import java.lang.reflect.Modifier;

public class MethodExitInstrEmitter
extends Emitter {
    private MethodEntryInstrEmitter entry;

    public MethodExitInstrEmitter(MethodEntryInstrEmitter entryEmitter, int endline, int endcol) {
        super(endline, endcol);
        this.entry = entryEmitter;
    }

    public void init(InstrumentationState state) {
        state.getRegistry().exitMethod(this.getLine(), this.getColumn());
        StringBuffer instr = new StringBuffer();
        if (this.entry.needsFinally()) {
            instr.append("}finally{");
            if (state.isInstrEnabled()) {
                switch (state.getCfg().getFlushPolicy()) {
                    case 1: {
                        instr.append(state.getRecorderPrefix()).append(".maybeFlush();");
                        break;
                    }
                    case 2: {
                        instr.append(state.getRecorderPrefix()).append(".flushNeeded();");
                    }
                }
                if (this.entry.isAddTestInstr()) {
                    instr.append(state.getRecorderPrefix());
                    String typeInstr = "getClass().getName()";
                    if (Modifier.isStatic(this.entry.getSignature().getModifiers())) {
                        typeInstr = this.entry.getMethod().getContainingClass().getName() + ".class";
                    }
                    instr.append(".globalSliceEnd(").append(typeInstr).append(",\"").append(this.entry.getMethod().getQualifiedName()).append("\",").append(this.entry.getMethod().getDataIndex()).append(");");
                }
            }
            instr.append("}");
        }
        this.setInstr(instr.toString());
    }
}

