/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.DefaultTestDetector;
import com.cenqua.clover.instr.FileMappedTestDetector;
import com.cenqua.clover.instr.InstrumentationLevel;
import com.cenqua.clover.instr.TestDetector;
import com.cenqua.clover.remote.DistributedConfig;
import com.cenqua.clover.util.JavaEnvUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class InstrumentationConfig {
    public static final int DIRECTED_FLUSHING = 0;
    public static final int INTERVAL_FLUSHING = 1;
    public static final int THREADED_FLUSHING = 2;
    public static final String DIRECTED_FLUSH_POLICY = "directed";
    public static final String INTERVAL_FLUSH_POLICY = "interval";
    public static final String THREADED_FLUSH_POLICY = "threaded";
    public static final String INSTR_FIELD = "field";
    public static final String INSTR_CLASS = "class";
    public static final String[] FLUSH_VALUES = new String[]{"directed", "interval", "threaded"};
    public static final String[] INSTR_VALUES = new String[]{"field", "class"};
    public static final int DEFAULT_FLUSHING = 0;
    public static final String DEFAULT_DB_DIR = ".clover";
    public static final String DEFAULT_DB_FILE = "clover" + "2.5.1".replace('.', '_') + ".db";
    public static final String JAVA_LANG_PREFIX = "java.lang.";
    private boolean enabled = true;
    private int flushPolicy = 0;
    private boolean java14 = false;
    private boolean java15 = false;
    private boolean java16 = false;
    private boolean sourceLevelSet = false;
    private boolean sliceRecording = true;
    private int flushInterval = 0;
    private boolean classInstrStrategy = true;
    private boolean reportInitErrors = true;
    private boolean testRewriting = true;
    private boolean fullyQualifiedJavaNames = true;
    private int instrLevel = InstrumentationLevel.STATEMENT.ordinal();
    private String initString;
    private String projectName = "";
    private File registryFile;
    private boolean relative;
    private String encoding;
    private File defaultBaseDir;
    private TestDetector testDetector;
    private String instrFileExtension = "java";
    private File tmpDir;
    private FileMappedTestDetector fileMappedTestDetector;
    private List methodContexts;
    private List statementContexts;
    private DistributedConfig distributedConfig;

    protected String determineSourceLevel() {
        return JavaEnvUtils.getJavaVersion();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInstrFileExtension(String extension) {
        this.instrFileExtension = extension;
    }

    public String getInstrFileExtension() {
        return this.instrFileExtension;
    }

    private void ensureSourceLevelSet() {
        if (!this.sourceLevelSet) {
            this.setSourceLevel(this.determineSourceLevel());
        }
    }

    public String getSourceLevel() {
        this.ensureSourceLevelSet();
        return this.java16 ? "1.6" : (this.java15 ? "1.5" : (this.java14 ? "1.4" : "1.3"));
    }

    public void setSourceLevel(String source) {
        if (source != null) {
            this.java16 = source.equals("1.6") || source.equals("6");
            this.java15 = source.equals("1.5") || source.equals("5") || this.java16;
            this.java14 = source.equals("1.4") || this.java15;
            this.sourceLevelSet = true;
        }
    }

    public boolean isJava14() {
        this.ensureSourceLevelSet();
        return this.java14;
    }

    public boolean isJava15() {
        this.ensureSourceLevelSet();
        return this.java15;
    }

    public boolean isReportInitErrors() {
        return this.reportInitErrors;
    }

    public void setReportInitErrors(boolean reportInitErrors) {
        this.reportInitErrors = reportInitErrors;
    }

    public TestDetector getTestDetector() {
        if (this.testDetector == null) {
            this.testDetector = new DefaultTestDetector();
        }
        return this.testDetector;
    }

    public void setTestDetector(TestDetector detector) {
        this.testDetector = detector;
    }

    public String getInitString() {
        return this.initString;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public int getFlushPolicy() {
        return this.flushPolicy;
    }

    public void setFlushPolicy(int flushPolicy) {
        this.flushPolicy = flushPolicy;
    }

    public void setFlushPolicyFromString(String fp) throws CloverException {
        for (int i = 0; i < FLUSH_VALUES.length; ++i) {
            if (!FLUSH_VALUES[i].equalsIgnoreCase(fp)) continue;
            this.flushPolicy = i;
            return;
        }
        throw new CloverException("Unknown flush policy \"" + fp + "\"");
    }

    public String getFlushPolicyString() {
        return FLUSH_VALUES[this.flushPolicy];
    }

    public boolean isClassInstrStrategy() {
        return this.classInstrStrategy;
    }

    public void setClassInstrStragegy(boolean useClass) {
        this.classInstrStrategy = useClass;
    }

    public void setInstrStrategy(String value) {
        if (value != null) {
            this.classInstrStrategy = value.equals(INSTR_CLASS);
        }
    }

    public File getRegistryFile() throws CloverException {
        return this.registryFile == null ? new File(this.getRuntimeInitString()) : this.registryFile;
    }

    public void setRegistryFile(File registryFile) {
        this.registryFile = registryFile;
    }

    public void setInitstring(String initstring) {
        this.initString = initstring;
    }

    public String getRuntimeInitString() throws CloverException {
        if (this.getInitString() == null) {
            this.createDefaultInitStringDir();
        }
        if (this.isRelative()) {
            return this.getInitString();
        }
        return this.resolveInitString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        if (projectName != null) {
            this.projectName = projectName;
        } else {
            Logger.getInstance().debug("Attempt to set the project name to null. Defaulting to '" + this.projectName + "'");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isIntervalBasedFlushing() {
        return this.flushPolicy == 1 || this.flushPolicy == 2;
    }

    public boolean isSliceRecording() {
        return this.sliceRecording;
    }

    public void setSliceRecording(boolean sliceRecording) {
        this.sliceRecording = sliceRecording;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    public File getDefaultBaseDir() {
        return this.defaultBaseDir == null ? new File("." + File.separator) : this.defaultBaseDir;
    }

    public void setDefaultBaseDir(File defaultBaseDir) {
        this.defaultBaseDir = defaultBaseDir;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public int getInstrLevel() {
        return this.instrLevel;
    }

    public void setInstrLevel(int instrLevel) {
        this.instrLevel = instrLevel;
    }

    public boolean isStatementInstrEnabled() {
        return this.instrLevel == InstrumentationLevel.STATEMENT.ordinal();
    }

    public void setInstrLevelStrategy(String value) {
        if (InstrumentationLevel.STATEMENT.name().equals(value.toUpperCase())) {
            this.setInstrLevel(InstrumentationLevel.STATEMENT.ordinal());
        } else if (InstrumentationLevel.METHOD.name().equals(value.toUpperCase())) {
            this.setInstrLevel(InstrumentationLevel.METHOD.ordinal());
        }
    }

    public String resolveInitString() {
        String resolvedInitString = this.getInitString();
        File initStringFile = new File(this.getDefaultBaseDir(), resolvedInitString);
        File initParent = initStringFile.getParentFile();
        if (initParent != null && initParent.exists()) {
            resolvedInitString = initStringFile.getAbsolutePath();
        }
        return resolvedInitString;
    }

    public String createDefaultInitStringDir() throws CloverException {
        File cloverDir = new File(this.getDefaultBaseDir(), DEFAULT_DB_DIR);
        if (cloverDir.exists() && !cloverDir.isDirectory() || !cloverDir.exists() && !cloverDir.mkdirs()) {
            throw new CloverException("Failed to create default Clover database '" + cloverDir + "'.");
        }
        this.setInitstring((this.isRelative() ? cloverDir.getName() : cloverDir.getAbsolutePath()) + File.separatorChar + DEFAULT_DB_FILE);
        return this.getInitString();
    }

    public void setTestRewriting(boolean testRewriting) {
        this.testRewriting = testRewriting;
    }

    public boolean isTestRewriting() {
        return this.testRewriting;
    }

    public String getJavaLangPrefix() {
        return this.fullyQualifiedJavaNames ? JAVA_LANG_PREFIX : "";
    }

    public void setFullyQualifyJavaLang(boolean fullyQualifiedJavaNames) {
        this.fullyQualifiedJavaNames = fullyQualifiedJavaNames;
    }

    public List getMethodContexts() {
        return this.methodContexts;
    }

    public void addMethodContext(MethodContextDef context) {
        if (this.methodContexts == null) {
            this.methodContexts = new LinkedList();
        }
        this.methodContexts.add(context);
    }

    public List getStatementContexts() {
        return this.statementContexts;
    }

    public void addStatementContext(StatementContextDef context) {
        if (this.statementContexts == null) {
            this.statementContexts = new LinkedList();
        }
        this.statementContexts.add(context);
    }

    public boolean hasCustomContexts() {
        return this.getMethodContexts() != null || this.getStatementContexts() != null;
    }

    public void setDistributedConfig(DistributedConfig distributedConfig) {
        this.distributedConfig = distributedConfig;
    }

    public String getDistributedConfigString() {
        return this.distributedConfig != null ? this.distributedConfig.toString() : null;
    }

    public static class MethodContextDef
    extends StatementContextDef {
        private int maxComplexity = Integer.MAX_VALUE;

        public int getMaxComplexity() {
            return this.maxComplexity;
        }

        public void setMaxComplexity(int maxComplexity) {
            this.maxComplexity = maxComplexity;
        }

        public void validate() throws CloverException {
            if (this.maxComplexity < 0) {
                throw new CloverException("maxComplexity must be greater than 0");
            }
            if (this.maxComplexity == 0) {
                throw new CloverException("maxComplexity must be greater than 0 because methods have a minimum complexity of 1");
            }
            if (this.getRegexp() == null || this.getRegexp().trim().length() == 0) {
                this.setRegexp(".*");
            }
            super.validate();
        }
    }

    public static class StatementContextDef {
        private String name;
        private String regexp;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }

        public void validate() throws CloverException {
            if (this.name == null || this.name.trim().length() == 0) {
                throw new CloverException("Context definition requires a name");
            }
            if (this.regexp == null || this.regexp.trim().length() == 0) {
                throw new CloverException("Context definition requires a regular expression");
            }
        }
    }
}

