/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverDatabaseSpec;
import com.cenqua.clover.CloverInstr;
import com.cenqua.clover.Logger;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.cfg.Interval;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class CloverMerge {
    private static String initString;
    private static HashMap mergingDbs;
    private static boolean update;
    private static Interval updateSpan;
    static /* synthetic */ Class class$com$cenqua$clover$CloverInstr;

    public static void main(String[] args) {
        System.exit(CloverMerge.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        if (!CloverMerge.processArgs(args)) {
            return 1;
        }
        LinkedList<CloverDatabaseSpec> databases = new LinkedList<CloverDatabaseSpec>();
        Iterator dbs = mergingDbs.keySet().iterator();
        while (dbs.hasNext()) {
            String db = (String)dbs.next();
            databases.add(new CloverDatabaseSpec(db, (Interval)mergingDbs.get(db)));
        }
        try {
            CloverDatabase.merge(databases, initString, update, updateSpan, new ProgressListener(){

                public void handleProgress(String desc, float pc) {
                    System.out.println(desc);
                }
            });
        }
        catch (Exception e) {
            Logger.getInstance().error("Error writing new clover db '" + initString, e);
            return 1;
        }
        return 0;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$CloverInstr;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$CloverInstr = new CloverInstr[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS [DBFILES...]").toString());
        System.err.println();
        System.err.println("  PARAMS:");
        System.err.println("    -i, --initstring <file>\t Clover initstring. This is the path where the new merged");
        System.err.println("\t\t\t\t database will be written.");
        System.err.println();
        System.err.println();
        System.err.println("  OPTIONS:");
        System.err.println("    -u, --update [interval]\t if specified, any existing database specified by -i will be included in the");
        System.err.println("\t\t\t\t merge. If interval is specified, it is used as the span when reading the existing database.");
        System.err.println("    -s, --span <interval>\t Specifies the span to use when reading subsequent databases to be ");
        System.err.println("\t\t\t\t merged. This option can be specified more than once and applies to all databases ");
        System.err.println("\t\t\t\t specified after the option, or until another span in specified.");
        System.err.println("    -v, --verbose\t\t Enable verbose logging.");
        System.err.println("    -d, --debug\t\t Enable debug logging.");
    }

    private static boolean processArgs(String[] args) {
        try {
            mergingDbs = new HashMap();
            Interval interval = Interval.ZERO_SECONDS;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    initString = args[++i];
                    continue;
                }
                if (args[i].equals("-u") || args[i].equals("--update")) {
                    update = true;
                    if (i >= args.length - 1) continue;
                    try {
                        updateSpan = new Interval(args[++i]);
                    }
                    catch (NumberFormatException e) {
                        --i;
                    }
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        interval = new Interval(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        CloverMerge.usage("Bad interval format '" + args[i] + "'");
                        return false;
                    }
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                mergingDbs.put(args[i], interval);
            }
            if (initString == null) {
                CloverMerge.usage("Need to specify an initstring for the merged database.");
                return false;
            }
            if (mergingDbs.size() == 0 && !update) {
                CloverMerge.usage("No databases to merge.");
                return false;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CloverMerge.usage("Missing a parameter.");
            return false;
        }
    }

    static {
        update = false;
        updateSpan = Interval.DEFAULT_SPAN;
    }
}

