/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.com.cenqua.license.CenquaLicense;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class CloverLicense
extends CenquaLicense
implements Serializable {
    private static final String GENERIC_ERROR = "Invalid license data";
    public static final long PERMS_ALL = -1L;
    public static final long PERMS_HIST_PDF = 32L;
    public static final long PERMS_HIST_HTML = 16L;
    public static final long PERMS_CURR_PDF = 8L;
    public static final long PERMS_CURR_HTML = 4L;
    public static final long PERMS_CURR_XML = 2L;
    public static final long PERMS_JFC = 1L;
    public static final long PERMS_HIST = 48L;
    public static final long PERMS_CURR = 14L;
    private final String ownerStatement;
    private final String preExpiryStatement;
    private final String postExpiryStatement;
    private final String contactInfoStatement;
    private final String terminationStatement;
    private HashSet allowedPkgPrefixes;
    private long supportedFeatures;
    private boolean verbose;

    public CloverLicense(CenquaLicense license) throws IOException {
        super(license);
        if (!this.getProductName().equalsIgnoreCase("clover")) {
            throw new IOException(" Not a Clover license.");
        }
        try {
            this.ownerStatement = this.getProperty("owner");
            this.preExpiryStatement = this.getProperty("preexpiry");
            this.postExpiryStatement = this.getProperty("postexpiry");
            this.terminationStatement = this.getProperty("termination");
            this.contactInfoStatement = this.getProperty("contact");
            String allowedPkgPrefixesStr = this.getProperty("allowedpkgprefixes");
            if (allowedPkgPrefixesStr != null && allowedPkgPrefixesStr.trim().length() > 0) {
                this.allowedPkgPrefixes = new HashSet();
                StringTokenizer prefixes = new StringTokenizer(allowedPkgPrefixesStr, ", ");
                while (prefixes.hasMoreTokens()) {
                    this.allowedPkgPrefixes.add(prefixes.nextToken());
                }
            }
            this.verbose = Boolean.valueOf(this.getProperty("verbose"));
            boolean jfcPerm = Boolean.valueOf(this.getProperty("jfc"));
            boolean xmlPerm = Boolean.valueOf(this.getProperty("xml"));
            boolean htmlPerm = Boolean.valueOf(this.getProperty("html"));
            boolean pdfPerm = Boolean.valueOf(this.getProperty("pdf"));
            boolean histHtmlPerm = Boolean.valueOf(this.getProperty("histhtml"));
            boolean histPdfPerm = Boolean.valueOf(this.getProperty("histpdf"));
            if (jfcPerm) {
                this.supportedFeatures |= 1L;
            }
            if (xmlPerm) {
                this.supportedFeatures |= 2L;
            }
            if (htmlPerm) {
                this.supportedFeatures |= 4L;
            }
            if (pdfPerm) {
                this.supportedFeatures |= 8L;
            }
            if (histHtmlPerm) {
                this.supportedFeatures |= 0x10L;
            }
            if (histPdfPerm) {
                this.supportedFeatures |= 0x20L;
            }
        }
        catch (NullPointerException e) {
            throw new IOException("Invalid license data [E1300].");
        }
    }

    public CloverLicense(String name, String owner, String preExpiry, String postExpiry, String termination, String contactInfo, String supportedVersions, long softExpiryDate, long hardExpiryDate, long supportedFeatures, boolean verbose) {
        super("Clover", name, supportedVersions, softExpiryDate, hardExpiryDate, new Properties());
        this.ownerStatement = "Clover Evaluation License registered to " + owner + ".";
        this.preExpiryStatement = preExpiry;
        this.postExpiryStatement = postExpiry;
        this.terminationStatement = termination;
        this.contactInfoStatement = contactInfo;
        this.supportedFeatures = supportedFeatures;
        this.verbose = verbose;
        this.allowedPkgPrefixes = null;
    }

    public String getOwnerStatement() {
        return this.ownerStatement;
    }

    public String getPreExpiryStatement() {
        return this.preExpiryStatement;
    }

    public String getPostExpiryStatement() {
        return this.postExpiryStatement;
    }

    public String getContactInfoStatement() {
        return this.contactInfoStatement;
    }

    public String getTerminationStatement() {
        return this.terminationStatement;
    }

    public boolean isFeatureSupported(long feature) {
        return (this.supportedFeatures & feature) != 0L;
    }

    public long getFeaturesSupported() {
        return this.supportedFeatures;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public HashSet getAllowedPkgPrefixes() {
        return this.allowedPkgPrefixes;
    }
}

