/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CloverDatabaseSpec;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.CoverageDataCollator;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.InMemPerTestCoverage;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestCoverage;
import com.cenqua.clover.PerTestCoverageStrategy;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataRange;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.NoSuchRegistryException;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ReadOnlyRegistryException;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.Formatting;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverDatabase {
    private String initstring;
    private Clover2Registry registry;
    private CoverageDataCollator collator;
    private CoverageData data;
    private ProjectInfo testOnlyModel;
    private ProjectInfo appOnlyModel;

    public CloverDatabase(String initstring) throws CloverException {
        this(initstring, null, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name) throws CloverException {
        this(initstring, includeFilter, name, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name, String filterSpec) throws CloverException {
        this(initstring, includeFilter, name, filterSpec, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name, String filterSpec, ProgressListener progressListener) throws CloverException {
        this.initstring = initstring;
        this.registry = Clover2Registry.fromFile(new File(initstring), includeFilter, progressListener);
        if (this.registry == null) {
            throw new NoSuchRegistryException(initstring);
        }
        if (this.registry.isReadOnly()) {
            this.data = this.registry.getCoverageData();
        }
        if (this.data == null) {
            this.data = new CoverageData(this.registry);
        }
        this.collator = new CoverageDataCollator(this.registry);
        this.registry.getModel().setDataProvider(this.data);
        ContextSet filter = this.getContextSet(filterSpec);
        this.registry.getModel().setContextFilter(filter);
        if (name == null) {
            name = new StringBuffer().append("Clover database ").append(Formatting.formatDate(new Date(this.registry.getVersion()))).toString();
        }
        this.registry.getModel().setName(name);
    }

    public CoverageData loadCoverageData() throws CloverException {
        return this.loadCoverageData(new CoverageDataSpec());
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec) throws CloverException {
        return this.loadCoverageData(spec, null);
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        if (!this.registry.isReadOnly()) {
            this.data = this.collator.loadCoverageData(spec, progressListener);
        }
        if (spec.isResolve()) {
            this.data.resolve(this.registry);
        }
        if (!spec.isPreserveTestCaseCache()) {
            TestCaseInfo.Factory.reset();
        }
        this.registry.getModel().setHasTestResults(this.data.getTests().size() > 0);
        this.registry.getModel().setDataProvider(this.data);
        if (spec.getTestFilter() != null) {
            this.testOnlyModel = this.registry.getModel().copy(spec.getTestFilter());
            this.appOnlyModel = this.registry.getModel().copy(spec.getTestFilter().invert());
        }
        return this.data;
    }

    public void setCoverageData(CoverageDataSpec spec, CoverageData data) {
        this.data = data;
        this.collator.setSpec(spec);
        if (spec.isResolve()) {
            data.resolve(this.registry);
        }
        if (!spec.isPreserveTestCaseCache()) {
            TestCaseInfo.Factory.reset();
        }
        this.registry.getModel().setHasTestResults(data.getTests().size() > 0);
        this.registry.getModel().setDataProvider(data);
        if (spec.getTestFilter() != null) {
            this.testOnlyModel = this.registry.getModel().copy(spec.getTestFilter());
            this.appOnlyModel = this.registry.getModel().copy(spec.getTestFilter().invert());
        }
    }

    public String getInitstring() {
        return this.initstring;
    }

    public String getName() {
        return this.registry.getModel().getName();
    }

    public ProjectInfo getModel() {
        return this.getAppOnlyModel();
    }

    public ProjectInfo getTestOnlyModel() {
        return this.testOnlyModel;
    }

    public ProjectInfo getAppOnlyModel() {
        return this.appOnlyModel != null ? this.appOnlyModel : this.getFullModel();
    }

    public ProjectInfo getFullModel() {
        return this.registry.getModel();
    }

    public boolean isOutOfDate() {
        return this.isRegistryOutOfDate() || this.isCoverageOutOfDate();
    }

    public boolean isRegistryOutOfDate() {
        return this.registry.isOutOfDate();
    }

    public boolean isCoverageOutOfDate() {
        return this.data.isOutOfDate();
    }

    public void resolve(Path sourcePath) {
        this.registry.getModel().resolve(sourcePath);
        if (this.appOnlyModel != null) {
            this.appOnlyModel.resolve(sourcePath);
        }
        if (this.testOnlyModel != null) {
            this.testOnlyModel.resolve(sourcePath);
        }
    }

    public ContextSet getContextSet(String spec) {
        return this.registry.getContextStore().createContextSetFilter(spec == null ? "" : spec);
    }

    public Set<TestCaseInfo> getTestHits(CoverageDataRange range) {
        return this.data.getTestsCovering(range);
    }

    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FileInfo fileInfo) {
        return this.data.mapTestsAndCoverageForFile(fileInfo);
    }

    public Clover2Registry getRegistry() {
        return this.registry;
    }

    public ContextStore getContextStore() {
        return this.registry.getContextStore();
    }

    public CoverageData getCoverageData() {
        return this.data;
    }

    public TestCaseInfo getTestCase(int id) {
        return this.data.getTestById(id);
    }

    public boolean hasCoverage() {
        return !this.data.isEmpty();
    }

    public long getRecordingTimestamp() {
        return this.data.getTimestamp();
    }

    public static CloverDatabase loadWithCoverage(String initString, CoverageDataSpec spec) throws CloverException {
        CloverDatabase database = new CloverDatabase(initString);
        database.loadCoverageData(spec);
        return database;
    }

    public static void merge(List dbspecs, String initString) throws CloverException, IOException {
        CloverDatabase.merge(dbspecs, initString, ProgressListener.NOOP_LISTENER);
    }

    public static void merge(List dbspecs, String initString, ProgressListener listener) throws CloverException, IOException {
        CloverDatabase.merge(dbspecs, initString, false, Interval.DEFAULT_SPAN, listener);
    }

    public static void merge(List dbspecs, String initString, boolean update, Interval updateSpan, ProgressListener listener) throws CloverException, IOException {
        String originalInitString = null;
        File tmpDb = null;
        if (update) {
            try {
                Clover2Registry.readRegistryHeaderAndModeOnly(new File(initString));
            }
            catch (ReadOnlyRegistryException e) {
            }
            catch (IOException e) {
                Logger.getInstance().verbose(new StringBuffer().append("No database to update at ").append(initString).toString());
                update = false;
            }
            if (update) {
                originalInitString = initString;
                dbspecs.add(new CloverDatabaseSpec(originalInitString, updateSpan));
                tmpDb = File.createTempFile("clovermerge", ".db");
                tmpDb.delete();
                initString = tmpDb.getAbsolutePath();
                listener.handleProgress(new StringBuffer().append("updating existing database at ").append(originalInitString).toString(), 0.0f);
            }
        }
        if (dbspecs.size() < 1) {
            throw new CloverException("need to specify a non-zero number of databases to merge");
        }
        Clover2Registry destReg = new Clover2Registry(new File(initString), "Merged Project");
        destReg.setVersion(System.currentTimeMillis());
        destReg.setReadOnly(true);
        ProjectInfo baseProject = destReg.getModel();
        LinkedHashMap<CloverDatabaseSpec, CloverDatabase> speccedDbs = new LinkedHashMap<CloverDatabaseSpec, CloverDatabase>();
        for (int i = 0; i < dbspecs.size(); ++i) {
            CloverDatabaseSpec spec = (CloverDatabaseSpec)dbspecs.get(i);
            CloverDatabase mergingDb = new CloverDatabase(spec.getInitString());
            speccedDbs.put(spec, mergingDb);
        }
        ContextStore.ContextMapper contextMapper = ContextStore.mergeContextStores(destReg, speccedDbs.values());
        int[] mergedCoverage = null;
        InMemPerTestCoverage mergedSliceHits = null;
        int projectDataLength = 0;
        float progress = 0.0f;
        float progressInc = 0.8f / (float)dbspecs.size();
        int slotsUsed = 0;
        TestCaseInfo.Factory.reset();
        Iterator speccedDbEntries = speccedDbs.entrySet().iterator();
        int i = 0;
        while (speccedDbEntries.hasNext()) {
            Map.Entry entry = speccedDbEntries.next();
            CloverDatabaseSpec spec = (CloverDatabaseSpec)entry.getKey();
            CloverDatabase mergingDb = (CloverDatabase)entry.getValue();
            listener.handleProgress(new StringBuffer().append("Merging database ").append(i + 1).append(" of ").append(dbspecs.size()).append(": ").append(mergingDb.getInitstring()).toString(), progress);
            CoverageData mergingData = mergingDb.loadCoverageData(new CoverageDataSpec(null, spec.getSpan().getValueInMillis(), false, false, true, true, PerTestCoverageStrategy.IN_MEMORY));
            ProjectInfo mergingProject = mergingDb.getFullModel();
            if (mergedCoverage == null) {
                mergedCoverage = new int[mergingProject.getDataLength()];
                mergedSliceHits = new InMemPerTestCoverage(mergingDb.getRegistry());
            }
            List mergingFiles = mergingProject.getFiles(HasMetricsFilter.NO_OP);
            for (FileInfo mergeFI : mergingFiles) {
                FileInfo baseFI = null;
                String mergePkgName = mergeFI.getContainingPackage().getName();
                PackageInfo basePkg = (PackageInfo)baseProject.getNamedPackage(mergePkgName);
                if (basePkg != null) {
                    baseFI = (FileInfo)basePkg.getFile(mergeFI.getPackagePath());
                }
                int newDataIndex = baseProject.getDataLength();
                int newDataLength = mergeFI.getDataLength();
                int oldDataIndex = mergeFI.getDataIndex();
                if (baseFI != null && baseFI.getFilesize() == mergeFI.getFilesize() && baseFI.getChecksum() == mergeFI.getChecksum()) {
                    newDataIndex = baseFI.getDataIndex();
                    newDataLength = baseFI.getDataLength();
                } else {
                    if (baseFI != null && baseFI.getTimestamp() >= mergeFI.getTimestamp()) continue;
                    mergeFI.setDataIndex(newDataIndex);
                    mergeFI.resetVersions(baseProject.getVersion());
                    if (basePkg == null) {
                        basePkg = new PackageInfo(baseProject, mergePkgName, newDataIndex);
                        baseProject.addPackage(basePkg);
                    }
                    basePkg.addFile(mergeFI);
                    projectDataLength = Math.max(projectDataLength, mergeFI.getDataIndex() + mergeFI.getDataLength());
                    baseProject.setDataLength(projectDataLength);
                    if (baseFI != null) {
                        slotsUsed -= baseFI.getDataLength();
                    }
                    slotsUsed += mergeFI.getDataLength();
                    contextMapper.applyContextMapping(mergingDb, mergeFI);
                }
                mergedCoverage = CloverDatabase.addIntArrays(mergingData.getHitCounts(), oldDataIndex, mergedCoverage, newDataIndex, newDataLength);
                mergedSliceHits = CloverDatabase.mergePerTestCoverage(mergingData, oldDataIndex, mergedSliceHits, newDataIndex, newDataLength);
            }
            progress += progressInc;
            ++i;
        }
        int[] compactedCoverage = new int[slotsUsed];
        InMemPerTestCoverage compactedSliceHits = new InMemPerTestCoverage(slotsUsed);
        int insertPoint = 0;
        List mergedFiles = baseProject.getFiles(HasMetricsFilter.NO_OP);
        for (FileInfo fileInfo : mergedFiles) {
            System.arraycopy(mergedCoverage, fileInfo.getDataIndex(), compactedCoverage, insertPoint, fileInfo.getDataLength());
            for (TestCaseInfo tci : mergedSliceHits.getTests()) {
                BitSet compactedSlice = compactedSliceHits.getHitsFor(tci);
                BitSet mergedSlice = mergedSliceHits.getHitsFor(tci);
                for (int i2 = 0; i2 < fileInfo.getDataLength(); ++i2) {
                    compactedSlice.set(insertPoint + i2, mergedSlice.get(fileInfo.getDataIndex() + i2));
                }
            }
            fileInfo.setDataIndex(insertPoint);
            insertPoint += fileInfo.getDataLength();
        }
        baseProject.setDataLength(slotsUsed);
        listener.handleProgress("Writing merged database registry", progress);
        destReg.setCoverageData(new CoverageData(System.currentTimeMillis(), compactedCoverage, compactedSliceHits));
        destReg.store();
        TestCaseInfo.Factory.reset();
        if (update) {
            CloverUtils.scrubCoverageData(originalInitString, true, true, false);
            FileUtils.fileCopy(tmpDb, new File(originalInitString));
            tmpDb.delete();
        }
        listener.handleProgress("Merge complete", 1.0f);
    }

    private static InMemPerTestCoverage mergePerTestCoverage(PerTestCoverage src, int spos, InMemPerTestCoverage dest, int dpos, int length) {
        if (dpos + length > dest.getCoverageSize()) {
            dest = new InMemPerTestCoverage(dest, dpos + length);
        }
        for (TestCaseInfo tci : src.getTests()) {
            BitSet srcSlots = src.getHitsFor(tci);
            BitSet destSlots = dest.getHitsFor(tci);
            for (int i = 0; i < length; ++i) {
                destSlots.set(dpos + i, srcSlots.get(spos + i));
            }
        }
        return dest;
    }

    private static int[] addIntArrays(int[] src, int spos, int[] dest, int dpos, int length) {
        if (dpos + length > dest.length) {
            int[] tmp = new int[dpos + length];
            System.arraycopy(dest, 0, tmp, 0, dest.length);
            dest = tmp;
        }
        for (int i = 0; i < length; ++i) {
            int n = dpos + i;
            dest[n] = dest[n] + src[spos + i];
        }
        return dest;
    }
}

