/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.commons.lang.mutable;

import clover.org.apache.commons.lang.math.NumberUtils;
import clover.org.apache.commons.lang.mutable.Mutable;

public class MutableDouble
extends Number
implements Comparable,
Mutable {
    private static final long serialVersionUID = 1587163916L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(Number value) {
        this.value = value.doubleValue();
    }

    public int compareTo(Object obj) {
        MutableDouble other = (MutableDouble)obj;
        double anotherVal = other.value;
        return NumberUtils.compare(this.value, anotherVal);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableDouble && Double.doubleToLongBits(((MutableDouble)obj).value) == Double.doubleToLongBits(this.value);
    }

    public float floatValue() {
        return (float)this.value;
    }

    public Object getValue() {
        return new Double(this.value);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public long longValue() {
        return (long)this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setValue(Object value) {
        this.setValue(((Number)value).doubleValue());
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

