/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import clover.it.unimi.dsi.fastutil.longs.LongArrayIndirectPriorityQueue;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import clover.it.unimi.dsi.fastutil.longs.LongComparators;
import java.util.Comparator;

public class LongArrayIndirectDoublePriorityQueue
extends LongArrayIndirectPriorityQueue
implements IndirectDoublePriorityQueue {
    protected LongComparator secondaryComparator;

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int capacity, LongComparator c, LongComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int capacity, LongComparator c) {
        super(refArray, capacity, c == null ? LongComparators.OPPOSITE_COMPARATOR : LongComparators.oppositeComparator(c));
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, LongComparator c, LongComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, LongComparator c) {
        this(refArray, refArray.length, c);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray) {
        this(refArray, refArray.length, null);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int[] a, int size, LongComparator c, LongComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int[] a, LongComparator c, LongComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int[] a, int size, LongComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int[] a, LongComparator c) {
        this(refArray, a, a.length, c);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public LongArrayIndirectDoublePriorityQueue(long[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        long first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (this.refArray[this.array[i]] >= first) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        long last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (last >= this.refArray[this.array[i]]) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public Comparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

