/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.Sets;
import clover.it.unimi.dsi.fastutil.bytes.ByteBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteComparator;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterators;
import clover.it.unimi.dsi.fastutil.bytes.ByteSets;
import clover.it.unimi.dsi.fastutil.bytes.ByteSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class ByteSortedSets {
    private ByteSortedSets() {
    }

    public static ByteSortedSet singleton(byte element) {
        return new Singleton(element);
    }

    public static ByteSortedSet singleton(byte element, ByteComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static ByteSortedSet singleton(Object element) {
        return new Singleton((byte)((Byte)element));
    }

    public static ByteSortedSet singleton(Object element, ByteComparator comparator) {
        return new Singleton((Byte)element, comparator);
    }

    public static ByteSortedSet synchronize(ByteSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static ByteSortedSet synchronize(ByteSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static ByteSortedSet unmodifiable(ByteSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends ByteSets.UnmodifiableSet
    implements ByteSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ByteSortedSet sortedSet;

        protected UnmodifiableSortedSet(ByteSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public ByteSortedSet subSet(byte from, byte to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public ByteSortedSet headSet(byte to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public ByteSortedSet tailSet(byte from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public ByteBidirectionalIterator iterator(byte from) {
            return ByteIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        public byte firstByte() {
            return this.sortedSet.firstByte();
        }

        public byte lastByte() {
            return this.sortedSet.lastByte();
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }

        public Iterator iterator(Object from) {
            return ByteIterators.unmodifiable(this.sortedSet.iterator((Byte)from));
        }

        public SortedSet subSet(Object from, Object to) {
            return new UnmodifiableSortedSet((ByteSortedSet)this.sortedSet.subSet(from, to));
        }

        public SortedSet headSet(Object to) {
            return new UnmodifiableSortedSet((ByteSortedSet)this.sortedSet.headSet(to));
        }

        public SortedSet tailSet(Object from) {
            return new UnmodifiableSortedSet((ByteSortedSet)this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends ByteSets.SynchronizedSet
    implements ByteSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ByteSortedSet sortedSet;

        protected SynchronizedSortedSet(ByteSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(ByteSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public ByteSortedSet subSet(byte from, byte to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public ByteSortedSet headSet(byte to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public ByteSortedSet tailSet(byte from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public ByteBidirectionalIterator iterator(byte from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte firstByte() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte lastByte() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        public Iterator iterator(Object from) {
            return this.sortedSet.iterator((Byte)from);
        }

        public SortedSet subSet(Object from, Object to) {
            return new SynchronizedSortedSet((ByteSortedSet)this.sortedSet.subSet(from, to), this.sync);
        }

        public SortedSet headSet(Object to) {
            return new SynchronizedSortedSet((ByteSortedSet)this.sortedSet.headSet(to), this.sync);
        }

        public SortedSet tailSet(Object from) {
            return new SynchronizedSortedSet((ByteSortedSet)this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends ByteSets.Singleton
    implements ByteSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final ByteComparator comparator;

        private Singleton(byte element, ByteComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(byte element) {
            this(element, (ByteComparator)null);
        }

        final int compare(byte k1, byte k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public ByteBidirectionalIterator iterator(byte from) {
            ByteBidirectionalIterator i = (ByteBidirectionalIterator)this.byteIterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public ByteSortedSet subSet(byte from, byte to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public ByteSortedSet headSet(byte to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public ByteSortedSet tailSet(byte from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public byte firstByte() {
            return this.element;
        }

        public byte lastByte() {
            return this.element;
        }

        public Object first() {
            return new Byte(this.element);
        }

        public Object last() {
            return new Byte(this.element);
        }

        public Iterator iterator(Object from) {
            return this.iterator((Byte)from);
        }

        public SortedSet subSet(Object from, Object to) {
            return this.subSet((Byte)from, (Byte)to);
        }

        public SortedSet headSet(Object to) {
            return this.headSet((Byte)to);
        }

        public SortedSet tailSet(Object from) {
            return this.tailSet((Byte)from);
        }
    }
}

